/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.daemon.queueProcessor.service;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.Member;
import com.tangosol.coherence.component.net.Message;
import com.tangosol.coherence.component.net.ServiceInfo;
import com.tangosol.coherence.component.net.memberSet.actualMemberSet.ServiceMemberSet;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.ClusterService;
import com.tangosol.util.UUID;
import com.tangosol.util.WrapperException;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Date;

public class ClusterService$NewMemberWelcome
extends Message {
    private UUID __m_FromMemberUid;
    private int __m_ServiceCount;
    private int[] __m_ServiceId;
    private long[] __m_ServiceJoined;
    private boolean[] __m_ServiceLeaving;
    private String[] __m_ServiceName;
    private String[] __m_ServiceType;
    private String[] __m_ServiceVersion;

    public ClusterService$NewMemberWelcome() {
        this(null, null, true);
    }

    public ClusterService$NewMemberWelcome(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setMessageType(14);
        }
        catch (Exception e) {
            throw new WrapperException((Throwable)e);
        }
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    public String getDescription() {
        StringBuffer sb = new StringBuffer();
        int cServices = this.getServiceCount();
        sb.append("FromMemberUid=").append(this.getFromMemberUid()).append(", ServiceCount=").append(cServices).append("\nServiceId/ServiceName/ServiceVersion/ServiceLeaving=[");
        int i = 0;
        while (i < cServices) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.getServiceId(i)).append('/').append(this.getServiceName(i)).append('/').append(this.getServiceVersion(i)).append('/').append(new Date(this.getServiceJoined(i))).append('/').append(this.isServiceLeaving(i));
            ++i;
        }
        sb.append(']');
        return sb.toString();
    }

    public UUID getFromMemberUid() {
        return this.__m_FromMemberUid;
    }

    public int getServiceCount() {
        int[] anId = this.getServiceId();
        return anId == null ? 0 : anId.length;
    }

    public int[] getServiceId() {
        return this.__m_ServiceId;
    }

    public int getServiceId(int i) {
        return this.getServiceId()[i];
    }

    public long[] getServiceJoined() {
        return this.__m_ServiceJoined;
    }

    public long getServiceJoined(int i) {
        return this.getServiceJoined()[i];
    }

    public String[] getServiceName() {
        return this.__m_ServiceName;
    }

    public String getServiceName(int i) {
        return this.getServiceName()[i];
    }

    public String[] getServiceType() {
        return this.__m_ServiceType;
    }

    public String getServiceType(int i) {
        return this.getServiceType()[i];
    }

    public String[] getServiceVersion() {
        return this.__m_ServiceVersion;
    }

    public String getServiceVersion(int i) {
        return this.getServiceVersion()[i];
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/daemon/queueProcessor/service/ClusterService$NewMemberWelcome".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    public static Component get_Instance() {
        return new ClusterService$NewMemberWelcome();
    }

    private final Component get_Module() {
        return ((Component)this).get_Parent();
    }

    public boolean[] isServiceLeaving() {
        return this.__m_ServiceLeaving;
    }

    public boolean isServiceLeaving(int i) {
        return this.isServiceLeaving()[i];
    }

    public void onReceived() {
        super.onReceived();
        ClusterService service = (ClusterService)this.getService();
        Member member = service.getClusterMemberSet().getMember(this.getFromMember().getId());
        if (member != null) {
            Component._assert(this.getFromMemberUid().equals((Object)member.getUid32()));
            int cServices = this.getServiceCount();
            if (cServices > 0) {
                ServiceInfo info;
                int[] anServiceId = this.getServiceId();
                String[] asServiceName = this.getServiceName();
                String[] asServiceType = this.getServiceType();
                String[] asServiceVersion = this.getServiceVersion();
                long[] alServiceJoined = this.getServiceJoined();
                boolean[] afServiceLeaving = this.isServiceLeaving();
                ServiceInfo[] ainfoJoined = new ServiceInfo[cServices];
                int i = 0;
                while (i < cServices) {
                    info = service.ensureServiceInfo(anServiceId[i], asServiceName[i], asServiceType[i]);
                    ServiceMemberSet setServiceMember = info.getMemberSet();
                    if (setServiceMember.add(member)) {
                        int nId = member.getId();
                        setServiceMember.setServiceVersion(nId, asServiceVersion[i]);
                        setServiceMember.setServiceJoined(nId, alServiceJoined[i]);
                        if (afServiceLeaving[i]) {
                            setServiceMember.setServiceLeaving(nId, true);
                        }
                        ainfoJoined[i] = info;
                    }
                    ++i;
                }
                i = 0;
                while (i < cServices) {
                    info = ainfoJoined[i];
                    if (info != null) {
                        service.onServiceJoined(info, member, null, true);
                    }
                    ++i;
                }
            }
        }
    }

    public void read(DataInputStream stream) throws IOException {
        this.setFromMemberUid(new UUID((DataInput)stream));
        int cServices = stream.readUnsignedShort();
        if (cServices > 0) {
            int[] anServiceId = new int[cServices];
            String[] asServiceName = new String[cServices];
            String[] asServiceType = new String[cServices];
            String[] asServiceVersion = new String[cServices];
            long[] alServiceJoined = new long[cServices];
            boolean[] afServiceLeaving = new boolean[cServices];
            int i = 0;
            while (i < cServices) {
                anServiceId[i] = stream.readUnsignedShort();
                asServiceName[i] = stream.readUTF();
                asServiceType[i] = stream.readUTF();
                asServiceVersion[i] = stream.readUTF();
                alServiceJoined[i] = stream.readLong();
                afServiceLeaving[i] = stream.readBoolean();
                ++i;
            }
            this.setServiceId(anServiceId);
            this.setServiceName(asServiceName);
            this.setServiceType(asServiceType);
            this.setServiceVersion(asServiceVersion);
            this.setServiceJoined(alServiceJoined);
            this.setServiceLeaving(afServiceLeaving);
        }
    }

    public void setFromMemberUid(UUID uid) {
        this.__m_FromMemberUid = uid;
    }

    public void setServiceCount(int c) {
        boolean[] afOldLeaving;
        int cOldLeaving;
        long[] alOldJoined;
        int cOldJoined;
        String[] asOldVersion;
        int cOldVersions;
        String[] asOldType;
        int cOldTypes;
        String[] asOldName;
        int cOldNames;
        int[] anOldId = this.getServiceId();
        int cOldIds = anOldId == null ? 0 : anOldId.length;
        if (c != cOldIds) {
            int[] anNewId = new int[c];
            if (cOldIds > 0) {
                System.arraycopy(anOldId, 0, anNewId, 0, Math.min(c, cOldIds));
            }
            this.setServiceId(anNewId);
        }
        if (c != (cOldNames = (asOldName = this.getServiceName()) == null ? 0 : asOldName.length)) {
            String[] asNewName = new String[c];
            if (cOldNames > 0) {
                System.arraycopy(asOldName, 0, asNewName, 0, Math.min(c, cOldNames));
            }
            this.setServiceName(asNewName);
        }
        if (c != (cOldTypes = (asOldType = this.getServiceType()) == null ? 0 : asOldType.length)) {
            String[] asNewType = new String[c];
            if (cOldTypes > 0) {
                System.arraycopy(asOldType, 0, asNewType, 0, Math.min(c, cOldTypes));
            }
            this.setServiceType(asNewType);
        }
        if (c != (cOldVersions = (asOldVersion = this.getServiceVersion()) == null ? 0 : asOldVersion.length)) {
            String[] asNewVersion = new String[c];
            if (cOldVersions > 0) {
                System.arraycopy(asOldVersion, 0, asNewVersion, 0, Math.min(c, cOldVersions));
            }
            this.setServiceVersion(asNewVersion);
        }
        if (c != (cOldJoined = (alOldJoined = this.getServiceJoined()) == null ? 0 : alOldJoined.length)) {
            long[] alNewJoined = new long[c];
            if (cOldJoined > 0) {
                System.arraycopy(alOldJoined, 0, alNewJoined, 0, Math.min(c, cOldJoined));
            }
            this.setServiceJoined(alNewJoined);
        }
        if (c != (cOldLeaving = (afOldLeaving = this.isServiceLeaving()) == null ? 0 : afOldLeaving.length)) {
            boolean[] afNewLeaving = new boolean[c];
            if (cOldLeaving > 0) {
                System.arraycopy(afOldLeaving, 0, afNewLeaving, 0, Math.min(c, cOldLeaving));
            }
            this.setServiceLeaving(afNewLeaving);
        }
    }

    public void setServiceId(int i, int nId) {
        this.getServiceId()[i] = nId;
    }

    public void setServiceId(int[] anId) {
        this.__m_ServiceId = anId;
    }

    public void setServiceJoined(int i, long lJoined) {
        this.getServiceJoined()[i] = lJoined;
    }

    public void setServiceJoined(long[] alJoined) {
        this.__m_ServiceJoined = alJoined;
    }

    public void setServiceLeaving(int i, boolean fLeaving) {
        this.isServiceLeaving()[i] = fLeaving;
    }

    public void setServiceLeaving(boolean[] afLeaving) {
        this.__m_ServiceLeaving = afLeaving;
    }

    public void setServiceName(int i, String sName) {
        this.getServiceName()[i] = sName;
    }

    public void setServiceName(String[] asName) {
        this.__m_ServiceName = asName;
    }

    public void setServiceType(int i, String sType) {
        this.getServiceType()[i] = sType;
    }

    public void setServiceType(String[] asType) {
        this.__m_ServiceType = asType;
    }

    public void setServiceVersion(int i, String version) {
        this.getServiceVersion()[i] = version;
    }

    public void setServiceVersion(String[] aVersion) {
        this.__m_ServiceVersion = aVersion;
    }

    public void write(DataOutputStream stream) throws IOException {
        this.getFromMemberUid().writeExternal((DataOutput)stream);
        int cServices = this.getServiceCount();
        stream.writeShort(cServices);
        if (cServices > 0) {
            int[] anServiceId = this.getServiceId();
            String[] asServiceName = this.getServiceName();
            String[] asServiceType = this.getServiceType();
            String[] asServiceVersion = this.getServiceVersion();
            long[] alServiceJoined = this.getServiceJoined();
            boolean[] afServiceLeaving = this.isServiceLeaving();
            int i = 0;
            while (i < cServices) {
                stream.writeShort(anServiceId[i]);
                stream.writeUTF(asServiceName[i]);
                stream.writeUTF(asServiceType[i]);
                stream.writeUTF(asServiceVersion[i]);
                stream.writeLong(alServiceJoined[i]);
                stream.writeBoolean(afServiceLeaving[i]);
                ++i;
            }
        }
    }
}

