/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.daemon.queueProcessor.service;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.Member;
import com.tangosol.coherence.component.net.MemberSet;
import com.tangosol.coherence.component.net.memberSet.ActualMemberSet;
import com.tangosol.coherence.component.net.memberSet.actualMemberSet.MasterMemberSet;
import com.tangosol.coherence.component.net.message.DiscoveryMessage;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.ClusterService;
import com.tangosol.util.UUID;
import com.tangosol.util.WrapperException;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class ClusterService$NewMemberWelcomeAnnounce
extends DiscoveryMessage {
    private Member __m_SeniorMember;
    private String __m_ServiceVersion;

    public ClusterService$NewMemberWelcomeAnnounce() {
        this(null, null, true);
    }

    public ClusterService$NewMemberWelcomeAnnounce(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setMessageType(15);
        }
        catch (Exception e) {
            throw new WrapperException((Throwable)e);
        }
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    public String getDescription() {
        return String.valueOf("SeniorMember=") + this.getSeniorMember() + "\nServiceVersion=" + this.getServiceVersion();
    }

    public Member getSeniorMember() {
        return this.__m_SeniorMember;
    }

    public String getServiceVersion() {
        return this.__m_ServiceVersion;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/daemon/queueProcessor/service/ClusterService$NewMemberWelcomeAnnounce".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    public static Component get_Instance() {
        return new ClusterService$NewMemberWelcomeAnnounce();
    }

    private final Component get_Module() {
        return ((Component)this).get_Parent();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void onReceived() {
        super.onReceived();
        ClusterService service = (ClusterService)this.getService();
        if (service.isRunning() ^ true) {
            return;
        }
        boolean bl = this.isReadError();
        if (bl) {
            return;
        }
        Member memberFrom = this.getFromMember();
        switch (service.getState()) {
            case 0: 
            case 1: {
                Member memberThis = service.getState() == ClusterService.STATE_ANNOUNCE ? service.getAnnounceMember() : service.getRequestMember();
                if (!(memberThis.equals(memberFrom) ^ true)) return;
                service.resetBroadcastCounter("the presence of an existing cluster", this);
                return;
            }
            case 2: {
                Member memberThis = service.getThisMember();
                if (!(memberThis.equals(memberFrom) ^ true)) return;
                int idMember = memberFrom.getId();
                UUID uidMember = memberFrom.getUid32();
                MasterMemberSet setMember = service.getClusterMemberSet();
                ActualMemberSet setRecycled = setMember.getRecycleSet();
                Member memberById = setMember.getMember(idMember);
                Member memberByUid = setMember.getMember(uidMember);
                Member memberRecycle = ((MemberSet)setRecycled).getMember(idMember);
                if (!(!(memberById == null) ? false : memberByUid == null) ? false : memberRecycle == null) {
                    Member memberSenior = this.getSeniorMember();
                    if (!(memberSenior.equals(setMember.getOldestMember()) ? true : memberSenior.equals(((MemberSet)setRecycled).getMember(memberSenior.getId())))) return;
                    service.ensureMember(memberFrom, this.getServiceVersion());
                    return;
                }
                if (memberById != memberByUid) return;
                return;
            }
            default: {
                return;
            }
        }
    }

    public void read(DataInputStream stream) throws IOException {
        super.read(stream);
        ClusterService service = (ClusterService)this.get_Parent();
        Member memberSenior = service.instantiateMember();
        memberSenior.readExternal(stream);
        this.setSeniorMember(memberSenior);
        this.setServiceVersion(stream.readUTF());
    }

    public void setSeniorMember(Member member) {
        this.__m_SeniorMember = member;
    }

    public void setServiceVersion(String sVersion) {
        this.__m_ServiceVersion = sVersion;
    }

    public void write(DataOutputStream stream) throws IOException {
        super.write(stream);
        this.getSeniorMember().writeExternal(stream);
        stream.writeUTF(this.getServiceVersion());
    }
}

