/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.daemon.queueProcessor.service;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.Member;
import com.tangosol.coherence.component.net.MemberSet;
import com.tangosol.coherence.component.net.message.DiscoveryMessage;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.ClusterService;
import com.tangosol.run.component.EventDeathException;
import com.tangosol.util.WrapperException;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Date;

public class ClusterService$SeniorMemberHeartbeat
extends DiscoveryMessage {
    private long __m_LastReceivedMillis;
    private MemberSet __m_MemberSet;
    private boolean __m_WkaEnabled;

    public ClusterService$SeniorMemberHeartbeat() {
        this(null, null, true);
    }

    public ClusterService$SeniorMemberHeartbeat(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setMessageType(17);
        }
        catch (Exception e) {
            throw new WrapperException((Throwable)e);
        }
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    public String getDescription() {
        long lLastRecvTimestamp = this.getLastReceivedMillis();
        String sLastRecvTimestamp = lLastRecvTimestamp == 0L ? "none" : new Date(lLastRecvTimestamp).toString();
        return String.valueOf("\nLastRecvTimestamp=") + sLastRecvTimestamp + "\nMemberSet=" + this.getMemberSet();
    }

    public long getLastReceivedMillis() {
        return this.__m_LastReceivedMillis;
    }

    public MemberSet getMemberSet() {
        return this.__m_MemberSet;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/daemon/queueProcessor/service/ClusterService$SeniorMemberHeartbeat".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    public static Component get_Instance() {
        return new ClusterService$SeniorMemberHeartbeat();
    }

    private final Component get_Module() {
        return ((Component)this).get_Parent();
    }

    public boolean isWkaEnabled() {
        return this.__m_WkaEnabled;
    }

    public void onReceived() {
        super.onReceived();
        ClusterService service = (ClusterService)this.getService();
        Member memberFrom = this.getFromMember();
        if (this.isReadError()) {
            service.onMemberRejected(-2, memberFrom);
            throw new EventDeathException("Version mismatch");
        }
        if (this.isWkaEnabled() ^ service.isWkaEnabled()) {
            service.onMemberRejected(-6, memberFrom);
            throw new EventDeathException("WKA mismatch");
        }
        if (service.validateSeniorBroadcast(this, this.getMemberSet())) {
            Member memberThis = service.getThisMember();
            Member memberOldest = service.getClusterOldestMember();
            if (this.getMemberSet().contains(memberThis) ^ true) {
                long ldtBirth = memberThis.getTimestamp();
                long ldtLast = this.getLastReceivedMillis();
                long ldtCurrent = service.getTimestamp();
                long lGrace = service.getHeartbeatDelay() * 4;
                if (!(ldtLast > ldtBirth) ? false : ldtCurrent > ldtBirth + lGrace) {
                    Component._trace(String.valueOf("Received cluster heartbeat from the senior ") + memberOldest + " that does not contain this " + memberThis + "; stopping cluster service.", 1);
                    service.onStopRunning();
                }
            }
        }
    }

    public void read(DataInputStream stream) throws IOException {
        super.read(stream);
        this.setLastReceivedMillis(stream.readLong());
        MemberSet setMember = new MemberSet();
        setMember.readMany(stream);
        this.setMemberSet(setMember);
        this.setWkaEnabled(stream.readBoolean());
        this.ensureEOS(stream);
    }

    public void setLastReceivedMillis(long cMillis) {
        this.__m_LastReceivedMillis = cMillis;
    }

    public void setMemberSet(MemberSet setMember) {
        this.__m_MemberSet = setMember;
    }

    public void setWkaEnabled(boolean pWkaEnabled) {
        this.__m_WkaEnabled = pWkaEnabled;
    }

    public void write(DataOutputStream stream) throws IOException {
        super.write(stream);
        stream.writeLong(this.getLastReceivedMillis());
        this.getMemberSet().writeMany(stream);
        stream.writeBoolean(this.isWkaEnabled());
    }
}

