/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.daemon.queueProcessor.service;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.Member;
import com.tangosol.coherence.component.net.MemberSet;
import com.tangosol.coherence.component.net.Message;
import com.tangosol.coherence.component.net.ServiceInfo;
import com.tangosol.coherence.component.net.memberSet.actualMemberSet.ServiceMemberSet;
import com.tangosol.coherence.component.net.message.RequestMessage;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.ClusterService;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.ClusterService$ServiceJoinRequest$Poll;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.ClusterService$ServiceJoined;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.ClusterService$ServiceUpdateResponse;
import com.tangosol.util.ListMap;
import com.tangosol.util.WrapperException;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;

public class ClusterService$ServiceJoinRequest
extends RequestMessage {
    private Map __m_MemberConfigMap;
    private int __m_ServiceId;
    private String __m_ServiceVersion;
    private static ListMap __mapChildren;

    static {
        ClusterService$ServiceJoinRequest.__initStatic();
    }

    public ClusterService$ServiceJoinRequest() {
        this(null, null, true);
    }

    public ClusterService$ServiceJoinRequest(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setMessageType(20);
        }
        catch (Exception e) {
            throw new WrapperException((Throwable)e);
        }
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    private static void __initStatic() {
        __mapChildren = new ListMap();
        Object object = __mapChildren.put((Object)"Poll", (Object)ClusterService$ServiceJoinRequest$Poll.get_CLASS());
    }

    public String getDescription() {
        return String.valueOf("ServiceId=") + this.getServiceId() + "\nServiceVersion=" + this.getServiceVersion() + "\nMemberConfigMap=" + this.getMemberConfigMap();
    }

    public Map getMemberConfigMap() {
        return this.__m_MemberConfigMap;
    }

    public int getServiceId() {
        return this.__m_ServiceId;
    }

    public String getServiceVersion() {
        return this.__m_ServiceVersion;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/daemon/queueProcessor/service/ClusterService$ServiceJoinRequest".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    public static Component get_Instance() {
        return new ClusterService$ServiceJoinRequest();
    }

    private final Component get_Module() {
        return ((Component)this).get_Parent();
    }

    public void onReceived() {
        super.onReceived();
        ClusterService service = (ClusterService)this.getService();
        int nService = this.getServiceId();
        ServiceInfo info = service.getServiceInfo(nService);
        if (info == null) {
            ClusterService$ServiceUpdateResponse msg = (ClusterService$ServiceUpdateResponse)service.instantiateMessage("ServiceUpdateResponse");
            msg.respondTo(this);
            service.send(msg);
        } else {
            Member member = this.getFromMember();
            int nMember = member.getId();
            String sVersion = this.getServiceVersion();
            long lJoined = service.getTimestamp();
            Map mapConfig = this.getMemberConfigMap();
            ServiceMemberSet setMember = info.getMemberSet();
            Iterator iter = setMember.iterator();
            while (iter.hasNext()) {
                long lOld = setMember.getServiceJoined(((Member)iter.next()).getId());
                if (!(lJoined <= lOld)) continue;
                lJoined = lOld + (long)1;
            }
            boolean fNew = setMember.add(member);
            if (fNew) {
                setMember.setServiceVersion(nMember, sVersion);
                setMember.setServiceJoined(nMember, lJoined);
            }
            service.onServiceJoined(info, member, mapConfig, fNew);
            MemberSet setOthers = service.getOthersMemberSet();
            setOthers.remove(member);
            ClusterService$ServiceJoined msg = (ClusterService$ServiceJoined)service.instantiateMessage("ServiceJoined");
            msg.setMemberId(nMember);
            msg.setServiceId(nService);
            msg.setServiceName(info.getServiceName());
            msg.setServiceType(info.getServiceType());
            msg.setServiceJoined(lJoined);
            msg.setServiceVersion(sVersion);
            msg.setMemberConfigMap(mapConfig);
            msg.setToMemberSet(setOthers);
            msg.setJoinRequest(this);
            service.registerServiceJoined(msg);
            service.send(msg);
        }
    }

    public void read(DataInputStream stream) throws IOException {
        this.setServiceId(stream.readUnsignedShort());
        this.setServiceVersion(stream.readUTF());
        this.setMemberConfigMap((Map)Message.readObject(stream, null));
    }

    public void setMemberConfigMap(Map map) {
        this.__m_MemberConfigMap = map;
    }

    public void setServiceId(int nId) {
        this.__m_ServiceId = nId;
    }

    public void setServiceVersion(String sVersion) {
        this.__m_ServiceVersion = sVersion;
    }

    public void write(DataOutputStream stream) throws IOException {
        stream.writeShort(this.getServiceId());
        stream.writeUTF(this.getServiceVersion());
        Message.writeObject(stream, this.getMemberConfigMap());
    }
}

