/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.daemon.queueProcessor.service;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.Util;
import com.tangosol.coherence.component.net.Lease;
import com.tangosol.coherence.component.net.Member;
import com.tangosol.coherence.component.net.MemberSet;
import com.tangosol.coherence.component.net.Message;
import com.tangosol.coherence.component.net.Poll;
import com.tangosol.coherence.component.net.memberSet.SingleMemberSet;
import com.tangosol.coherence.component.net.message.DistributedCacheResponse;
import com.tangosol.coherence.component.net.message.DistributedPartialResponse;
import com.tangosol.coherence.component.net.message.requestMessage.DistributedCacheKeyRequest;
import com.tangosol.coherence.component.net.message.requestMessage.distributedCacheRequest.KeySetRequest;
import com.tangosol.coherence.component.net.message.requestMessage.distributedCacheRequest.PartialRequest;
import com.tangosol.coherence.component.net.requestContext.IdempotentContext;
import com.tangosol.coherence.component.util.CacheEvent;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.DistributedCache;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.DistributedCache$AggregateAllRequest;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.DistributedCache$AggregateFilterRequest;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.DistributedCache$BinaryMap$Entry;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.DistributedCache$BinaryMap$EntrySet;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.DistributedCache$BinaryMap$KeySet;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.DistributedCache$BinaryMap$Values;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.DistributedCache$ClearRequest;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.DistributedCache$ContainsAllRequest;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.DistributedCache$ContainsKeyRequest;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.DistributedCache$ContainsValueRequest;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.DistributedCache$GetAllRequest;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.DistributedCache$GetRequest;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.DistributedCache$IndexRequest;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.DistributedCache$InvokeAllRequest;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.DistributedCache$InvokeFilterRequest;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.DistributedCache$InvokeRequest;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.DistributedCache$KeyIteratorRequest;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.DistributedCache$KeyListenerRequest;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.DistributedCache$ListenerRequest;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.DistributedCache$LockRequest;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.DistributedCache$MapEvent;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.DistributedCache$PartialMapResponse;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.DistributedCache$PartialValueResponse;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.DistributedCache$PutAllRequest;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.DistributedCache$PutRequest;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.DistributedCache$QueryRequest;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.DistributedCache$QueryResponse;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.DistributedCache$RemoveAllRequest;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.DistributedCache$RemoveRequest;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.DistributedCache$Response;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.DistributedCache$SizeRequest;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.DistributedCache$UnlockRequest;
import com.tangosol.net.CacheService;
import com.tangosol.net.NamedCache;
import com.tangosol.net.RequestTimeoutException;
import com.tangosol.net.partition.PartitionSet;
import com.tangosol.util.Base;
import com.tangosol.util.Binary;
import com.tangosol.util.Filter;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.ListMap;
import com.tangosol.util.Listeners;
import com.tangosol.util.LiteMap;
import com.tangosol.util.LiteSet;
import com.tangosol.util.LongArray;
import com.tangosol.util.MapEvent;
import com.tangosol.util.MapListener;
import com.tangosol.util.MapListenerSupport;
import com.tangosol.util.NullImplementation;
import com.tangosol.util.ObservableMap;
import com.tangosol.util.SimpleEnumerator;
import com.tangosol.util.SparseArray;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.WrapperException;
import com.tangosol.util.filter.LimitFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DistributedCache$BinaryMap
extends Util
implements NamedCache {
    public static final int RESPONSE_MAP = 3;
    public static final int RESPONSE_SET = 2;
    public static final int RESPONSE_SIMPLE = 1;
    public static final int RESPONSE_VOID = 0;
    private long __m_CacheId;
    private String __m_CacheName;
    private LongArray __m_FilterArray;
    private transient MapListenerSupport __m_ListenerSupport;
    private transient Map __m_ProcessedEvents;
    private static ListMap __mapChildren;

    static {
        DistributedCache$BinaryMap.__initStatic();
    }

    public DistributedCache$BinaryMap() {
        this(null, null, true);
    }

    public DistributedCache$BinaryMap(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setFilterArray((LongArray)new SparseArray());
            this.setListenerSupport(new MapListenerSupport());
        }
        catch (Exception e) {
            throw new WrapperException((Throwable)e);
        }
        this._addChild(new DistributedCache$BinaryMap$EntrySet("EntrySet", this, true), "EntrySet");
        this._addChild(new DistributedCache$BinaryMap$KeySet("KeySet", this, true), "KeySet");
        this._addChild(new DistributedCache$BinaryMap$Values("Values", this, true), "Values");
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    private static void __initStatic() {
        __mapChildren = new ListMap();
        Object object = __mapChildren.put((Object)"Entry", (Object)DistributedCache$BinaryMap$Entry.get_CLASS());
    }

    public void addIndex(ValueExtractor extractor, boolean fOrdered, Comparator comp) {
        DistributedCache service = this.getService();
        MemberSet setStorage = service.getStorageMemberSet();
        if (setStorage.isEmpty() ^ true) {
            LinkedList listResults = new LinkedList();
            DistributedCache$IndexRequest msg = (DistributedCache$IndexRequest)service.instantiateMessage("IndexRequest");
            msg.setToMemberSet(setStorage);
            msg.setCacheId(this.getCacheId());
            msg.setPartResults(listResults);
            msg.setAdd(true);
            msg.setExtractor(extractor);
            msg.setOrdered(fOrdered);
            msg.setComparator(comp);
            service.poll(msg);
            this.mergePartialResponse(listResults);
        }
    }

    public void addMapListener(MapListener listener) {
        this.addMapListener(listener, null, false);
    }

    public void addMapListener(MapListener listener, Filter filter, boolean fLite) {
        long lFilterId;
        boolean fWasLite;
        boolean fWasEmpty;
        DistributedCache service = this.getService();
        MapListenerSupport support = this.getListenerSupport();
        if (!(listener instanceof MapListenerSupport.SynchronousListener) ? false : Thread.currentThread() == service.getThread()) {
            Component._trace(String.valueOf("SynchronousListener cannot be added on the service thread:\n") + Component.get_StackTrace(), 1);
            return;
        }
        MapListenerSupport mapListenerSupport = support;
        synchronized (mapListenerSupport) {
            fWasEmpty = support.isEmpty(filter);
            fWasLite = fWasEmpty ? true : support.containsStandardListeners(filter) ^ true;
            support.addListener(listener, filter, fLite);
            lFilterId = fWasEmpty ? this.registerFilter(filter) : this.getFilterId(filter);
        }
        if (fWasEmpty ? true : (!fWasLite ? false : fLite ^ true)) {
            MemberSet setStorage = service.getStorageMemberSet();
            if (setStorage.isEmpty()) {
                this.onMissingStorage();
                MapListenerSupport mapListenerSupport2 = support;
                synchronized (mapListenerSupport2) {
                    support.removeListener(listener, filter);
                    this.getFilterArray().remove(lFilterId);
                }
                return;
            }
            LinkedList listResults = new LinkedList();
            DistributedCache$ListenerRequest msg = (DistributedCache$ListenerRequest)service.instantiateMessage("ListenerRequest");
            msg.setToMemberSet(setStorage);
            msg.setCacheId(this.getCacheId());
            msg.setPartResults(listResults);
            msg.setAdd(true);
            msg.setFilter(filter);
            msg.setFilterId(lFilterId);
            msg.setLite(fLite);
            try {
                service.poll(msg);
                this.mergePartialResponse(listResults);
            }
            catch (RuntimeException e) {
                MapListenerSupport mapListenerSupport3 = support;
                synchronized (mapListenerSupport3) {
                    support.removeListener(listener, filter);
                    this.getFilterArray().remove(lFilterId);
                }
                throw e;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public void addMapListener(MapListener listener, Object oKey, boolean fLite) {
        binKey = (Binary)oKey;
        service = this.getService();
        support = this.getListenerSupport();
        if (listener instanceof MapListenerSupport.SynchronousListener == false ? false : Thread.currentThread() == service.getThread()) {
            Component._trace(String.valueOf("SynchronousListener cannot be added on the service thread:\n") + Component.get_StackTrace(), 1);
            return;
        }
        var9_7 = support;
        synchronized (var9_7) {
            fWasEmpty = support.isEmpty((Object)binKey);
            fWasLite = fWasEmpty != false ? true : support.containsStandardListeners((Object)binKey) ^ true;
            support.addListener(listener, (Object)binKey, fLite);
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl13 : MonitorExitStatement: MONITOREXIT : var9_7
            if (true) ** GOTO lbl37
        }
        do {
            if ((memberOwner = service.getPrimaryOwner(binKey)) == null) {
                if (service.getStorageMemberSet().isEmpty()) {
                    this.onMissingStorage();
                    support.removeListener(listener, (Object)binKey);
                    return;
                }
            } else {
                msg = (DistributedCache$KeyListenerRequest)service.instantiateMessage("KeyListenerRequest");
                msg.setCacheId(this.getCacheId());
                msg.setKey(binKey);
                msg.setAdd(true);
                msg.setLite(fLite);
                msg.setPrimary(true);
                msg.setToMemberSet(SingleMemberSet.instantiate(memberOwner));
                oResponse = service.poll(msg);
                if (oResponse != DistributedCacheKeyRequest.RESPONSE_UNKNOWN) {
                    if (!(oResponse instanceof RuntimeException)) break;
                    support.removeListener(listener, (Object)binKey);
                    throw (RuntimeException)oResponse;
                }
            }
            this.waitForRedistribution();
lbl37:
            // 2 sources

        } while (fWasEmpty != false ? true : (fWasLite == false ? false : fLite ^ true));
    }

    public Object aggregate(Filter filter, InvocableMap.EntryAggregator agent) {
        DistributedCache$AggregateFilterRequest msg = (DistributedCache$AggregateFilterRequest)this.getService().instantiateMessage("AggregateFilterRequest");
        msg.setCacheId(this.getCacheId());
        msg.setFilter(filter);
        msg.setAggregator(agent);
        try {
            return this.mergePartialResponse(this.sendPartitionedRequest(msg, this.makePartitionSet()));
        }
        catch (RequestTimeoutException e) {
            throw this.processPartitionedRequestTimeout(e, RESPONSE_SIMPLE);
        }
    }

    public Object aggregate(Filter filter, InvocableMap.EntryAggregator agent, Binary binHostKey) {
        DistributedCache service = this.getService();
        int iBucket = service.getKeyBucket(binHostKey);
        PartitionSet partitions = new PartitionSet(service.getPartitionCount());
        partitions.add(iBucket);
        DistributedCache$AggregateFilterRequest msg = (DistributedCache$AggregateFilterRequest)service.instantiateMessage("AggregateFilterRequest");
        msg.setCacheId(this.getCacheId());
        msg.setFilter(filter);
        msg.setAggregator(agent);
        try {
            return this.mergePartialResponse(this.sendPartitionedRequest(msg, partitions));
        }
        catch (RequestTimeoutException e) {
            throw this.processPartitionedRequestTimeout(e, RESPONSE_SIMPLE);
        }
    }

    public Object aggregate(Collection colKeys, InvocableMap.EntryAggregator agent) {
        Set setKeys = colKeys instanceof Set ? (Set)colKeys : new HashSet(colKeys);
        int cKeys = setKeys.size();
        if (cKeys == 0) {
            return Collections.EMPTY_LIST;
        }
        DistributedCache$AggregateAllRequest msg = (DistributedCache$AggregateAllRequest)this.getService().instantiateMessage("AggregateAllRequest");
        msg.setCacheId(this.getCacheId());
        msg.setKeySet(setKeys);
        msg.setAggregator(agent);
        try {
            return this.mergePartialResponse(this.sendPartitionedRequest(msg, setKeys));
        }
        catch (RequestTimeoutException e) {
            throw this.processPartitionedRequestTimeout(e, RESPONSE_SIMPLE);
        }
    }

    public void clear() {
        DistributedCache$ClearRequest msg = (DistributedCache$ClearRequest)this.getService().instantiateMessage("ClearRequest");
        msg.setCacheId(this.getCacheId());
        try {
            this.mergePartialResponse(this.sendPartitionedRequest(msg, this.makePartitionSet()));
        }
        catch (RequestTimeoutException e) {
            throw this.processPartitionedRequestTimeout(e, RESPONSE_VOID);
        }
    }

    protected Set collectUnprocessedKeys(Set setKeys, PartitionSet partitions, Set setResend) {
        DistributedCache service = this.getService();
        Iterator iter = setKeys.iterator();
        while (iter.hasNext()) {
            Binary binKey = (Binary)iter.next();
            if (!partitions.contains(service.getKeyBucket(binKey))) continue;
            if (setResend == null) {
                setResend = new HashSet<Binary>();
            }
            setResend.add(binKey);
        }
        return setResend;
    }

    public boolean containsAll(Collection colKeys) {
        List listResponse;
        RequestTimeoutException eTimeout;
        block7: {
            Set setKeys = colKeys instanceof Set ? (Set)colKeys : new HashSet(colKeys);
            int cKeys = setKeys.size();
            if (cKeys == 0) {
                return true;
            }
            if (cKeys == 1) {
                Binary binKey = (Binary)setKeys.iterator().next();
                return this.containsKey(binKey);
            }
            DistributedCache$ContainsAllRequest msg = (DistributedCache$ContainsAllRequest)this.getService().instantiateMessage("ContainsAllRequest");
            msg.setCacheId(this.getCacheId());
            msg.setKeySet(setKeys);
            eTimeout = null;
            try {
                listResponse = this.sendPartitionedRequest(msg, setKeys);
            }
            catch (RequestTimeoutException e) {
                eTimeout = e;
                listResponse = (List)e.getPartialResult();
                if (!(listResponse == null)) break block7;
                throw e;
            }
        }
        Iterator iter = listResponse.iterator();
        while (iter.hasNext()) {
            DistributedCache$PartialValueResponse response = (DistributedCache$PartialValueResponse)iter.next();
            Object oResult = response.getResult();
            if (oResult instanceof RuntimeException) {
                throw (RuntimeException)oResult;
            }
            if (!(!(oResult instanceof Boolean) ? false : (Boolean)oResult ^ true)) continue;
            return false;
        }
        if (eTimeout != null) {
            eTimeout.setPartialResult(null);
            throw eTimeout;
        }
        return true;
    }

    public boolean containsKey(Object oKey) {
        DistributedCache service = this.getService();
        Binary binKey = (Binary)oKey;
        while (true) {
            Member memberOwner;
            if ((memberOwner = service.getPrimaryOwner(binKey)) == null) {
                if (service.getStorageMemberSet().isEmpty()) {
                    this.onMissingStorage();
                    return false;
                }
            } else {
                DistributedCache$ContainsKeyRequest msg = (DistributedCache$ContainsKeyRequest)service.instantiateMessage("ContainsKeyRequest");
                msg.setToMemberSet(SingleMemberSet.instantiate(memberOwner));
                msg.setCacheId(this.getCacheId());
                msg.setKey(binKey);
                Object oResponse = service.poll(msg);
                if (oResponse != DistributedCacheKeyRequest.RESPONSE_UNKNOWN) {
                    if (oResponse instanceof RuntimeException) {
                        throw (RuntimeException)oResponse;
                    }
                    return (Boolean)oResponse;
                }
            }
            this.waitForRedistribution();
        }
    }

    public boolean containsValue(Object oValue) {
        List listResponse;
        RequestTimeoutException eTimeout;
        block5: {
            DistributedCache$ContainsValueRequest msg = (DistributedCache$ContainsValueRequest)this.getService().instantiateMessage("ContainsValueRequest");
            msg.setCacheId(this.getCacheId());
            msg.setValue((Binary)oValue);
            eTimeout = null;
            try {
                listResponse = this.sendPartitionedRequest(msg, this.makePartitionSet());
            }
            catch (RequestTimeoutException e) {
                eTimeout = e;
                listResponse = (List)e.getPartialResult();
                if (!(listResponse == null)) break block5;
                throw e;
            }
        }
        Iterator iter = listResponse.iterator();
        while (iter.hasNext()) {
            DistributedCache$PartialValueResponse msgResponse = (DistributedCache$PartialValueResponse)iter.next();
            Object oResult = msgResponse.getResult();
            if (oResult instanceof RuntimeException) {
                throw (RuntimeException)oResult;
            }
            if (!(!(oResult instanceof Boolean) ? false : (Boolean)oResult)) continue;
            return true;
        }
        if (eTimeout != null) {
            eTimeout.setPartialResult(null);
            throw eTimeout;
        }
        return false;
    }

    public void destroy() {
        MapListenerSupport support;
        MapListenerSupport mapListenerSupport = support = this.getListenerSupport();
        synchronized (mapListenerSupport) {
            support.clear();
            this.getFilterArray().clear();
        }
    }

    public void dispatch(DistributedCache$MapEvent msgEvent) {
        com.tangosol.net.cache.CacheEvent event;
        int nEventType = msgEvent.getEventType();
        Binary binKey = msgEvent.getKey();
        boolean fSynthetic = msgEvent.isSynthetic();
        long[] alFilterId = msgEvent.getFilterId();
        int cFilters = alFilterId == null ? 0 : alFilterId.length;
        MapListenerSupport support = this.getListenerSupport();
        Listeners listeners = support.getListeners((Object)binKey);
        if (cFilters == 0) {
            event = new com.tangosol.net.cache.CacheEvent((ObservableMap)this, nEventType, (Object)binKey, (Object)msgEvent.getOldValue(), (Object)msgEvent.getNewValue(), fSynthetic);
        } else {
            LongArray laFilters = this.getFilterArray();
            LiteSet setFilters = new LiteSet();
            int i = 0;
            while (i < cFilters) {
                long lFilterId = alFilterId[i];
                if (laFilters.exists(lFilterId)) {
                    Filter filter = (Filter)laFilters.get(lFilterId);
                    Listeners listenersTemp = new Listeners();
                    if (listeners != null) {
                        listenersTemp.addAll(listeners);
                    }
                    listeners = listenersTemp;
                    listeners.addAll(support.getListeners(filter));
                    setFilters.add((Object)filter);
                }
                ++i;
            }
            Filter[] aFilter = (Filter[])setFilters.toArray((Object[])new Filter[setFilters.size()]);
            event = new MapListenerSupport.FilterEvent((ObservableMap)this, nEventType, (Object)binKey, (Object)msgEvent.getOldValue(), (Object)msgEvent.getNewValue(), fSynthetic, aFilter);
        }
        if (listeners == null ? true : listeners.isEmpty()) {
            MapListenerSupport mapListenerSupport = support;
            synchronized (mapListenerSupport) {
                DistributedCache service;
                Member memberOwner;
                if (support.getListeners((Object)binKey) == null && (memberOwner = (service = this.getService()).getPrimaryOwner(binKey)) != null) {
                    DistributedCache$KeyListenerRequest msg = (DistributedCache$KeyListenerRequest)service.instantiateMessage("KeyListenerRequest");
                    msg.setCacheId(this.getCacheId());
                    msg.setKey(binKey);
                    msg.setAdd(false);
                    msg.setPrimary(true);
                    msg.addToMember(memberOwner);
                    service.post(msg);
                }
            }
        } else {
            CacheEvent.dispatchSafe((MapEvent)event, listeners, this.getService().ensureEventDispatcher().getQueue());
        }
    }

    public Set entrySet() {
        return (DistributedCache$BinaryMap$EntrySet)this._findChild("EntrySet");
    }

    public Set entrySet(Filter filter) {
        PartitionSet partitions = this.makePartitionSet();
        try {
            return filter instanceof LimitFilter ? this.limitQuerySequential(partitions, (LimitFilter)filter, false) : this.mergeQueryResponse(this.query(partitions, filter, false));
        }
        catch (RequestTimeoutException e) {
            throw this.processPartitionedRequestTimeout(e, filter instanceof LimitFilter ? RESPONSE_VOID : RESPONSE_SET);
        }
    }

    public Set entrySet(Filter filter, Binary binHostKey) {
        DistributedCache service = this.getService();
        int iBucket = service.getKeyBucket(binHostKey);
        PartitionSet partitions = new PartitionSet(service.getPartitionCount());
        partitions.add(iBucket);
        try {
            return filter instanceof LimitFilter ? this.limitQuerySequential(partitions, (LimitFilter)filter, false) : this.mergeQueryResponse(this.query(partitions, filter, false));
        }
        catch (RequestTimeoutException e) {
            throw this.processPartitionedRequestTimeout(e, filter instanceof LimitFilter ? RESPONSE_VOID : RESPONSE_SET);
        }
    }

    public Set entrySet(Filter filter, Comparator comparator) {
        PartitionSet partitions = this.makePartitionSet();
        try {
            return filter instanceof LimitFilter ? this.limitQueryDistributed(partitions, (LimitFilter)filter) : this.mergeQueryResponse(this.query(partitions, filter, false));
        }
        catch (RequestTimeoutException e) {
            throw this.processPartitionedRequestTimeout(e, filter instanceof LimitFilter ? RESPONSE_VOID : RESPONSE_SET);
        }
    }

    public Set entrySet(Filter filter, Comparator comparator, Binary binHostKey) {
        DistributedCache service = this.getService();
        int iBucket = service.getKeyBucket(binHostKey);
        PartitionSet partitions = new PartitionSet(service.getPartitionCount());
        partitions.add(iBucket);
        try {
            return filter instanceof LimitFilter ? this.limitQueryDistributed(partitions, (LimitFilter)filter) : this.mergeQueryResponse(this.query(partitions, filter, false));
        }
        catch (RequestTimeoutException e) {
            throw this.processPartitionedRequestTimeout(e, filter instanceof LimitFilter ? RESPONSE_VOID : RESPONSE_SET);
        }
    }

    public Object get(Object oKey) {
        DistributedCache service = this.getService();
        Binary binKey = (Binary)oKey;
        while (true) {
            Member memberOwner;
            if ((memberOwner = service.getPrimaryOwner(binKey)) == null) {
                if (service.getStorageMemberSet().isEmpty()) {
                    this.onMissingStorage();
                    return null;
                }
            } else {
                DistributedCache$GetRequest msg = (DistributedCache$GetRequest)service.instantiateMessage("GetRequest");
                msg.setToMemberSet(SingleMemberSet.instantiate(memberOwner));
                msg.setCacheId(this.getCacheId());
                msg.setKey(binKey);
                Object oResponse = service.poll(msg);
                if (oResponse != DistributedCacheKeyRequest.RESPONSE_UNKNOWN) {
                    if (oResponse instanceof RuntimeException) {
                        throw (RuntimeException)oResponse;
                    }
                    return (Binary)oResponse;
                }
            }
            this.waitForRedistribution();
        }
    }

    public Map getAll(Collection colKeys) {
        Set setKeys = colKeys instanceof Set ? (Set)colKeys : new HashSet(colKeys);
        int cKeys = setKeys.size();
        if (cKeys == 0) {
            return new LiteMap();
        }
        DistributedCache$GetAllRequest msg = (DistributedCache$GetAllRequest)this.getService().instantiateMessage("GetAllRequest");
        msg.setCacheId(this.getCacheId());
        msg.setKeySet(setKeys);
        try {
            return this.mergePartialMapResponse(this.sendPartitionedRequest(msg, setKeys));
        }
        catch (RequestTimeoutException e) {
            throw this.processPartitionedRequestTimeout(e, RESPONSE_MAP);
        }
    }

    public long getCacheId() {
        return this.__m_CacheId;
    }

    public String getCacheName() {
        return this.__m_CacheName;
    }

    public CacheService getCacheService() {
        return (DistributedCache)this.get_Module();
    }

    public LongArray getFilterArray() {
        return this.__m_FilterArray;
    }

    public long getFilterId(Filter filter) {
        LongArray.Iterator iter = this.getFilterArray().iterator();
        while (iter.hasNext()) {
            Filter filterThat = (Filter)iter.next();
            if (!Base.equals((Object)filter, (Object)filterThat)) continue;
            return iter.getIndex();
        }
        return 0L;
    }

    public MapListenerSupport getListenerSupport() {
        return this.__m_ListenerSupport;
    }

    public Map getProcessedEvents() {
        return this.__m_ProcessedEvents;
    }

    public DistributedCache getService() {
        return (DistributedCache)this.get_Module();
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/daemon/queueProcessor/service/DistributedCache$BinaryMap".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    public static Component get_Instance() {
        return new DistributedCache$BinaryMap();
    }

    private final Component get_Module() {
        return this.get_Parent();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object invoke(Object oKey, InvocableMap.EntryProcessor agent) {
        Binary binary;
        DistributedCache service = this.getService();
        Binary binKey = (Binary)oKey;
        IdempotentContext context = service.createRequestContext();
        long suidReq = context.getRequestSUID();
        service.registerRequestInfo(suidReq, Thread.currentThread());
        try {
            while (true) {
                Member memberOwner;
                if ((memberOwner = service.getPrimaryOwner(binKey)) == null) {
                    if (service.getStorageMemberSet().isEmpty()) {
                        this.onMissingStorage();
                        Object var9_9 = null;
                        Object var12_11 = null;
                        service.unregisterRequestInfo(suidReq);
                        return var9_9;
                    }
                } else {
                    DistributedCache$InvokeRequest msg = (DistributedCache$InvokeRequest)service.instantiateMessage("InvokeRequest");
                    msg.setToMemberSet(SingleMemberSet.instantiate(memberOwner));
                    msg.setRequestContext(context);
                    msg.setCacheId(this.getCacheId());
                    msg.setKey(binKey);
                    msg.setProcessor(agent);
                    Object oResponse = service.poll(msg);
                    if (oResponse != DistributedCacheKeyRequest.RESPONSE_UNKNOWN) {
                        if (oResponse instanceof RuntimeException) {
                            throw (RuntimeException)oResponse;
                        }
                        binary = (Binary)oResponse;
                        break;
                    }
                }
                this.waitForRedistribution();
                context.setOldestPendingSUID(service.getOldestPendingRequestSUID());
            }
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            service.unregisterRequestInfo(suidReq);
            throw throwable;
        }
        Object var12_12 = null;
        service.unregisterRequestInfo(suidReq);
        return binary;
    }

    public Map invokeAll(Filter filter, InvocableMap.EntryProcessor agent) {
        DistributedCache$InvokeFilterRequest msg = (DistributedCache$InvokeFilterRequest)this.getService().instantiateMessage("InvokeFilterRequest");
        msg.setCacheId(this.getCacheId());
        msg.setFilter(filter);
        msg.setProcessor(agent);
        try {
            return this.mergePartialMapResponse(this.sendPartitionedRequest(msg, this.makePartitionSet()));
        }
        catch (RequestTimeoutException e) {
            throw this.processPartitionedRequestTimeout(e, RESPONSE_MAP);
        }
    }

    public Map invokeAll(Filter filter, InvocableMap.EntryProcessor agent, Binary binHostKey) {
        DistributedCache service = this.getService();
        int iBucket = service.getKeyBucket(binHostKey);
        PartitionSet partitions = new PartitionSet(service.getPartitionCount());
        partitions.add(iBucket);
        DistributedCache$InvokeFilterRequest msg = (DistributedCache$InvokeFilterRequest)service.instantiateMessage("InvokeFilterRequest");
        msg.setCacheId(this.getCacheId());
        msg.setFilter(filter);
        msg.setProcessor(agent);
        try {
            return this.mergePartialMapResponse(this.sendPartitionedRequest(msg, partitions));
        }
        catch (RequestTimeoutException e) {
            throw this.processPartitionedRequestTimeout(e, RESPONSE_MAP);
        }
    }

    public Map invokeAll(Collection colKeys, InvocableMap.EntryProcessor agent) {
        Set setKeys = colKeys instanceof Set ? (Set)colKeys : new HashSet(colKeys);
        int cKeys = setKeys.size();
        if (cKeys <= 1) {
            LiteMap mapResult = new LiteMap();
            if (cKeys == 1) {
                Binary binKey = (Binary)setKeys.iterator().next();
                mapResult.put(binKey, this.invoke(binKey, agent));
            }
            return mapResult;
        }
        DistributedCache$InvokeAllRequest msg = (DistributedCache$InvokeAllRequest)this.getService().instantiateMessage("InvokeAllRequest");
        msg.setCacheId(this.getCacheId());
        msg.setKeySet(setKeys);
        msg.setProcessor(agent);
        try {
            return this.mergePartialMapResponse(this.sendPartitionedRequest(msg, setKeys));
        }
        catch (RequestTimeoutException e) {
            throw this.processPartitionedRequestTimeout(e, RESPONSE_MAP);
        }
    }

    public boolean isActive() {
        return true;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Set keySet() {
        return (DistributedCache$BinaryMap$KeySet)this._findChild("KeySet");
    }

    public Set keySet(Filter filter) {
        PartitionSet partitions = this.makePartitionSet();
        try {
            return filter instanceof LimitFilter ? this.limitQuerySequential(partitions, (LimitFilter)filter, true) : this.mergeQueryResponse(this.query(partitions, filter, true));
        }
        catch (RequestTimeoutException e) {
            throw this.processPartitionedRequestTimeout(e, filter instanceof LimitFilter ? RESPONSE_VOID : RESPONSE_SET);
        }
    }

    public Set keySet(Filter filter, Binary binHostKey) {
        DistributedCache service = this.getService();
        int iBucket = service.getKeyBucket(binHostKey);
        PartitionSet partitions = new PartitionSet(service.getPartitionCount());
        partitions.add(iBucket);
        try {
            return filter instanceof LimitFilter ? this.limitQuerySequential(partitions, (LimitFilter)filter, true) : this.mergeQueryResponse(this.query(partitions, filter, true));
        }
        catch (RequestTimeoutException e) {
            throw this.processPartitionedRequestTimeout(e, filter instanceof LimitFilter ? RESPONSE_VOID : RESPONSE_SET);
        }
    }

    public Iterator keySetIterator(PartitionSet partitions) {
        PartitionSet partMember;
        Member member;
        DistributedCache service = this.getService();
        HashMap mapByOwner = new HashMap();
        Member memberThis = service.getThisMember();
        service.splitByOwner(partitions, 0, mapByOwner);
        if (mapByOwner.isEmpty()) {
            if (service.getStorageMemberSet().isEmpty()) {
                this.onMissingStorage();
                partitions.clear();
            } else {
                this.waitForRedistribution();
            }
            return NullImplementation.getIterator();
        }
        if (mapByOwner.containsKey(memberThis)) {
            member = memberThis;
            partMember = (PartitionSet)mapByOwner.get(member);
        } else {
            Iterator iter = mapByOwner.entrySet().iterator();
            int c = Base.getRandom().nextInt(mapByOwner.size());
            while (c > 1) {
                iter.next();
                --c;
            }
            Map.Entry entry = (Map.Entry)iter.next();
            member = (Member)entry.getKey();
            partMember = (PartitionSet)entry.getValue();
        }
        PartitionSet partMask = new PartitionSet(partMember);
        PartitionSet partRequest = new PartitionSet(partMember);
        DistributedCache$KeyIteratorRequest msg = (DistributedCache$KeyIteratorRequest)service.instantiateMessage("KeyIteratorRequest");
        msg.setCacheId(this.getCacheId());
        msg.setToMemberSet(SingleMemberSet.instantiate(member));
        msg.setRequestMask(partMask);
        msg.setPartitions(partMember);
        DistributedCache$QueryResponse msgResponse = (DistributedCache$QueryResponse)service.poll(msg);
        if (msgResponse == null) {
            return NullImplementation.getIterator();
        }
        if (msgResponse.getException() != null) {
            throw msgResponse.getException();
        }
        partRequest.remove(partMember);
        partitions.remove(partRequest);
        return new SimpleEnumerator(msgResponse.getResult());
    }

    protected Set limitQueryDistributed(PartitionSet partitions, LimitFilter filterLimit) {
        DistributedCache$QueryResponse response;
        int cPageSize;
        Component._assert(filterLimit.getComparator() != null);
        DistributedCache service = this.getService();
        int cPartSize = cPageSize = filterLimit.getPageSize();
        while (true) {
            HashMap mapByOwner;
            PartitionSet partOrphan;
            if ((partOrphan = service.splitByOwner(partitions, 0, mapByOwner = new HashMap())) == null ? true : partOrphan.isEmpty()) {
                int cMembers = mapByOwner.size();
                if (!(cMembers > 1)) break;
                cPartSize = Math.max(10, (cPageSize + (cPageSize >> 2)) / cMembers);
                break;
            }
            if (service.getStorageMemberSet().isEmpty()) {
                this.onMissingStorage();
                return NullImplementation.getSet();
            }
            this.waitForRedistribution();
        }
        LimitFilter filterPart = (LimitFilter)filterLimit.clone();
        filterPart.setPageSize(cPartSize);
        List listResponse = this.query(new PartitionSet(partitions), (Filter)filterPart, false);
        int cActual = 0;
        int cAvail = 0;
        Iterator iter = listResponse.iterator();
        while (iter.hasNext()) {
            response = (DistributedCache$QueryResponse)iter.next();
            if (response.getException() != null) {
                throw response.getException();
            }
            cActual += response.getResult().length;
            cAvail += response.getAvailable();
        }
        if (!(cActual < cPartSize) ? false : cAvail > cActual) {
            filterPart.setPageSize(cPageSize);
            iter = listResponse.iterator();
            while (iter.hasNext()) {
                int cPartAvail;
                response = (DistributedCache$QueryResponse)iter.next();
                int cPartActual = response.getResult().length;
                if (!(cPartActual == (cPartAvail = response.getAvailable()))) continue;
                partitions.remove(service.calculatePartitionSet(response.getFromMember(), 0));
            }
            if (partitions.isEmpty() ^ true) {
                listResponse.addAll(this.query(partitions, (Filter)filterPart, false));
            }
        }
        return this.mergeQueryResponse(listResponse);
    }

    protected Set limitQuerySequential(PartitionSet partitions, LimitFilter filterLimit, boolean fKeysOnly) {
        Object[] objectArray;
        int cSkipActual;
        Component._assert(filterLimit.getComparator() == null);
        Component._assert(filterLimit.getTopAnchor() == null);
        Component._assert(filterLimit.getBottomAnchor() == null);
        DistributedCache service = this.getService();
        int cPageSize = filterLimit.getPageSize();
        Object[] aoCookie = (Object[])filterLimit.getCookie();
        Iterator iterMember = null;
        Member member = null;
        int cSkipMember = -1;
        int cSkipGlobal = -1;
        if (aoCookie != null) {
            iterMember = (Iterator)aoCookie[0];
            member = (Member)aoCookie[1];
            cSkipMember = (Integer)aoCookie[2];
            cSkipGlobal = (Integer)aoCookie[3];
        }
        if ((cSkipActual = cPageSize * filterLimit.getPage()) != cSkipGlobal) {
            Object[] aMember = service.getStorageMemberSet().toArray();
            int cMembers = aMember.length;
            int ofShuffle = System.identityHashCode(filterLimit) % cMembers;
            if (ofShuffle != 0) {
                Object[] ao = new Object[cMembers];
                System.arraycopy(aMember, ofShuffle, ao, 0, cMembers - ofShuffle);
                System.arraycopy(aMember, 0, ao, cMembers - ofShuffle, ofShuffle);
                aMember = ao;
            }
            iterMember = new SimpleEnumerator(aMember);
            member = (Member)iterMember.next();
            cSkipMember = cSkipActual;
            cSkipGlobal = cSkipActual;
        }
        int cPartSize = cPageSize;
        HashSet setResult = new HashSet();
        do {
            LimitFilter filterPart = new LimitFilter(filterLimit.getFilter(), cPartSize);
            filterPart.setTopAnchor((Object)Base.makeInteger((int)cSkipMember));
            int cPartActual = 0;
            int cPartAvail = 0;
            PartitionSet partMember = service.calculatePartitionSet(member, 0);
            partMember.retain(partitions);
            if (partMember.isEmpty() ^ true) {
                List listPart = this.query(partMember, (Filter)filterPart, fKeysOnly);
                if (listPart.isEmpty()) {
                    iterMember = new SimpleEnumerator(service.getStorageMemberSet().toArray());
                    if (iterMember.hasNext()) {
                        member = (Member)iterMember.next();
                        cSkipMember = cSkipActual;
                        cSkipGlobal = cSkipActual;
                        cPartSize = cPageSize;
                        setResult.clear();
                        continue;
                    }
                    return setResult;
                }
                Iterator iter = listPart.iterator();
                while (iter.hasNext()) {
                    DistributedCache$QueryResponse response = (DistributedCache$QueryResponse)iter.next();
                    if (response.getException() != null) {
                        throw response.getException();
                    }
                    cPartActual += response.getResult().length;
                    cPartAvail += response.getAvailable();
                }
                if (cPartActual > 0) {
                    setResult.addAll(this.mergeQueryResponse(listPart));
                    cSkipGlobal += cPartActual;
                    listPart = null;
                    if (cPartActual == cPartSize) {
                        cSkipMember += cPartActual;
                        break;
                    }
                    Component._assert((cPartSize -= cPartActual) > 0);
                    cSkipActual = 0;
                    cSkipMember = 0;
                } else {
                    cSkipMember = cSkipActual -= cPartAvail;
                }
            }
            if (cSkipActual + cPartSize > 2 * cPartAvail) {
                PartitionSet partRest = new PartitionSet(service.getPartitionCount());
                while (iterMember.hasNext()) {
                    try {
                        partRest.add(service.calculatePartitionSet((Member)iterMember.next(), 0));
                    }
                    catch (ConcurrentModificationException e) {
                        // empty catch block
                    }
                }
                if (partRest.isEmpty() ^ true) {
                    filterPart.setTopAnchor((Object)Base.makeInteger((int)0));
                    filterPart.setPageSize(cSkipActual + cPartSize);
                    List listPart = this.query(partRest, (Filter)filterPart, fKeysOnly);
                    if (listPart.isEmpty() ^ true) {
                        setResult.addAll(this.mergeQueryResponse(listPart, cSkipActual, cPartSize));
                    }
                }
                member = null;
                break;
            }
            try {
                member = iterMember.hasNext() ? (Member)iterMember.next() : null;
            }
            catch (ConcurrentModificationException e) {
                member = null;
            }
        } while (member != null);
        if (member == null) {
            objectArray = null;
        } else {
            Object[] objectArray2 = new Object[4];
            objectArray2[0] = iterMember;
            objectArray2[1] = member;
            objectArray2[2] = Base.makeInteger((int)cSkipMember);
            objectArray = objectArray2;
            objectArray2[3] = Base.makeInteger((int)cSkipGlobal);
        }
        filterLimit.setCookie(objectArray);
        return setResult;
    }

    public boolean lock(Object oKey) {
        return this.lock(oKey, 0);
    }

    public boolean lock(Object oKey, long cWaitMillis) {
        DistributedCache service = this.getService();
        Binary binKey = (Binary)oKey;
        int nMemberId = service.getThisMember().getId();
        long cLeaseMillis = service.getStandardLeaseMillis();
        long lThreadId = service.getLeaseGranularity() == Lease.BY_THREAD ? Lease.getCurrentThreadId() : 0L;
        while (true) {
            Member memberOwner;
            if ((memberOwner = service.getPrimaryOwner(binKey)) == null) {
                if (service.getStorageMemberSet().isEmpty()) {
                    this.onMissingStorage();
                    return false;
                }
            } else {
                Object oResponse;
                DistributedCache$LockRequest msg = (DistributedCache$LockRequest)service.instantiateMessage("LockRequest");
                msg.setToMemberSet(SingleMemberSet.instantiate(memberOwner));
                msg.setCacheId(this.getCacheId());
                msg.setKey(binKey);
                msg.setLeaseHolderId(nMemberId);
                msg.setLeaseThreadId(lThreadId);
                msg.setLeaseMillis(cLeaseMillis);
                msg.setLeaseWaitMillis(cWaitMillis);
                msg.setPrimary(true);
                try {
                    long cTimeout = service.getRequestTimeout();
                    if (cTimeout > 0L) {
                        cTimeout = service.adjustWaitTime(cWaitMillis, cTimeout);
                    }
                    oResponse = service.poll(msg, cTimeout);
                }
                catch (RuntimeException e) {
                    boolean fInterrupt = Thread.interrupted();
                    try {
                        this.unlock(oKey);
                    }
                    catch (RuntimeException x) {
                        // empty catch block
                    }
                    if (fInterrupt) {
                        Thread.currentThread().interrupt();
                    }
                    throw e;
                }
                if (oResponse != DistributedCacheKeyRequest.RESPONSE_UNKNOWN) {
                    if (oResponse instanceof RuntimeException) {
                        throw (RuntimeException)oResponse;
                    }
                    return (Boolean)oResponse;
                }
            }
            this.waitForRedistribution();
        }
    }

    public Map.Entry makeEntry(Binary binKey) {
        DistributedCache$BinaryMap$Entry entry = (DistributedCache$BinaryMap$Entry)this._newChild("Entry");
        entry.setKey(binKey);
        return entry;
    }

    public PartitionSet makePartitionSet() {
        PartitionSet partitions = new PartitionSet(this.getService().getPartitionCount());
        partitions.fill();
        return partitions;
    }

    protected Map mergePartialMapResponse(List listResponse) {
        HashMap<Object, Object> mapResult = new HashMap<Object, Object>();
        Iterator iter = listResponse.iterator();
        while (iter.hasNext()) {
            DistributedPartialResponse msgResponse;
            Message msg = (Message)iter.next();
            if (msg instanceof DistributedCache$PartialMapResponse) {
                msgResponse = (DistributedCache$PartialMapResponse)msg;
                if (((DistributedCache$PartialMapResponse)msgResponse).getException() != null) {
                    throw ((DistributedCache$PartialMapResponse)msgResponse).getException();
                }
                int cSize = ((DistributedCache$PartialMapResponse)msgResponse).getSize();
                Binary[] abinKey = ((DistributedCache$PartialMapResponse)msgResponse).getKey();
                Binary[] abinVal = ((DistributedCache$PartialMapResponse)msgResponse).getValue();
                int i = 0;
                while (i < cSize) {
                    mapResult.put(abinKey[i], abinVal[i]);
                    ++i;
                }
                continue;
            }
            msgResponse = (DistributedCache$QueryResponse)msg;
            if (((DistributedCache$QueryResponse)msgResponse).getException() != null) {
                throw ((DistributedCache$QueryResponse)msgResponse).getException();
            }
            Object[] aoEntry = ((DistributedCache$QueryResponse)msgResponse).getResult();
            int cEntries = aoEntry == null ? 0 : aoEntry.length;
            int i = 0;
            while (i < cEntries) {
                Map.Entry entry = (Map.Entry)aoEntry[i];
                mapResult.put(entry.getKey(), entry.getValue());
                ++i;
            }
        }
        return mapResult;
    }

    protected List mergePartialResponse(List listResponse) {
        ArrayList<Object> listResults = new ArrayList<Object>(listResponse.size());
        Iterator iter = listResponse.iterator();
        while (iter.hasNext()) {
            Message msgResponse;
            Message msg = (Message)iter.next();
            if (msg instanceof DistributedCache$Response) {
                msgResponse = (DistributedCache$Response)msg;
                switch (((DistributedCacheResponse)msgResponse).getResult()) {
                    case 0: {
                        listResults.add(((DistributedCacheResponse)msgResponse).getValue());
                        break;
                    }
                    case 2: {
                        throw ((DistributedCacheResponse)msgResponse).getFailure();
                    }
                    default: {
                        throw new IllegalStateException(String.valueOf("Invalid partial response: ") + msgResponse);
                    }
                }
                continue;
            }
            msgResponse = (DistributedCache$PartialValueResponse)msg;
            Object oResult = ((DistributedCache$PartialValueResponse)msgResponse).getResult();
            if (oResult instanceof RuntimeException) {
                throw (RuntimeException)oResult;
            }
            listResults.add(oResult);
        }
        return listResults;
    }

    protected Set mergeQueryResponse(List listResponse) {
        return this.mergeQueryResponse(listResponse, 0, 0);
    }

    protected Set mergeQueryResponse(List listResponse, int cSkip, int cLimit) {
        HashSet<Object> setMerge = new HashSet<Object>();
        int cMerge = 0;
        Iterator iter = listResponse.iterator();
        block0: while (iter.hasNext()) {
            DistributedCache$QueryResponse msgResponse = (DistributedCache$QueryResponse)iter.next();
            if (msgResponse.getException() != null) {
                throw msgResponse.getException();
            }
            Object[] aoEntry = msgResponse.getResult();
            int cEntries = aoEntry == null ? 0 : aoEntry.length;
            if (cSkip >= cEntries) {
                cSkip -= cEntries;
                continue;
            }
            int i = 0;
            while (i < cEntries) {
                if (cSkip > 0) {
                    --cSkip;
                } else {
                    setMerge.add(aoEntry[i]);
                    if (++cMerge == cLimit) break block0;
                }
                ++i;
            }
        }
        return setMerge;
    }

    public void onMissingStorage() {
        String sMsg;
        String string = sMsg = this.getService().isRunning() ? "Storage is not configured" : "Service has been terminated";
        if (!Boolean.getBoolean("tangosol.coherence.ignore_disabled_storage")) {
            throw new RuntimeException(sMsg);
        }
        Component._trace(sMsg, 4);
    }

    protected RequestTimeoutException processPartitionedRequestTimeout(RequestTimeoutException eTimeout, int nResponseType) {
        Object oResult = null;
        List listParts = (List)eTimeout.getPartialResult();
        try {
            switch (nResponseType) {
                case 1: {
                    oResult = this.mergePartialResponse(listParts);
                    break;
                }
                case 2: {
                    oResult = this.mergeQueryResponse(listParts);
                    break;
                }
                case 3: {
                    oResult = this.mergePartialMapResponse(listParts);
                    break;
                }
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
        eTimeout.setPartialResult(oResult);
        return eTimeout;
    }

    public Object put(Object oKey, Object oValue) {
        return this.put(oKey, oValue, 0L, true);
    }

    public Object put(Object oKey, Object oValue, long cMillis) {
        return this.put(oKey, oValue, cMillis, true);
    }

    public Object put(Object oKey, Object oValue, long cMillis, boolean fReturn) {
        DistributedCache service = this.getService();
        Binary binKey = (Binary)oKey;
        Binary binValue = (Binary)oValue;
        while (true) {
            Member memberOwner;
            if ((memberOwner = service.getPrimaryOwner(binKey)) == null) {
                if (service.getStorageMemberSet().isEmpty()) {
                    this.onMissingStorage();
                    return null;
                }
            } else {
                DistributedCache$PutRequest msg = (DistributedCache$PutRequest)service.instantiateMessage("PutRequest");
                msg.setToMemberSet(SingleMemberSet.instantiate(memberOwner));
                msg.setCacheId(this.getCacheId());
                msg.setKey(binKey);
                msg.setValue(binValue);
                msg.setExpiryDelay(cMillis);
                msg.setPrimary(true);
                msg.setReturnRequired(fReturn);
                Object oResponse = service.poll(msg);
                if (oResponse != DistributedCacheKeyRequest.RESPONSE_UNKNOWN) {
                    if (oResponse instanceof RuntimeException) {
                        throw (RuntimeException)oResponse;
                    }
                    return (Binary)oResponse;
                }
            }
            this.waitForRedistribution();
        }
    }

    public void putAll(Map map) {
        int cItems = map.size();
        if (cItems <= 1) {
            if (cItems == 1) {
                Map.Entry entry = (Map.Entry)map.entrySet().iterator().next();
                this.put(entry.getKey(), entry.getValue(), 0L, false);
            }
            return;
        }
        DistributedCache service = this.getService();
        LinkedList listParts = new LinkedList();
        while (true) {
            HashMap mapByOwner = new HashMap();
            HashMap mapResend = service.splitEntriesByOwner(map.entrySet().iterator(), 0, mapByOwner);
            if (mapByOwner.isEmpty()) {
                if (service.getStorageMemberSet().isEmpty()) {
                    this.onMissingStorage();
                    return;
                }
                this.waitForRedistribution();
                continue;
            }
            int cMsgs = mapByOwner.size();
            DistributedCache$PutAllRequest[] aMsg = new DistributedCache$PutAllRequest[cMsgs];
            HashSet<Poll> setPolls = new HashSet<Poll>();
            long lTimeout = 0L;
            Iterator iter = mapByOwner.entrySet().iterator();
            int iMsg = 0;
            while (iMsg < cMsgs) {
                Map.Entry entry = (Map.Entry)iter.next();
                Member member = (Member)entry.getKey();
                Map mapMember = (Map)entry.getValue();
                DistributedCache$PutAllRequest msg = (DistributedCache$PutAllRequest)service.instantiateMessage("PutAllRequest");
                msg.setToMemberSet(SingleMemberSet.instantiate(member));
                msg.setCacheId(this.getCacheId());
                msg.setMap(mapMember);
                msg.setPendingPolls(setPolls);
                msg.setPartResults(listParts);
                if (iMsg == 0) {
                    lTimeout = msg.getRequestTimeoutMillis();
                }
                setPolls.add(msg.ensureRequestPoll());
                aMsg[iMsg] = msg;
                ++iMsg;
            }
            iMsg = 0;
            while (iMsg < cMsgs) {
                service.post(aMsg[iMsg]);
                ++iMsg;
            }
            this.waitPolls(setPolls, Service.adjustTimeout(service.getRequestTimeout(), lTimeout));
            iMsg = 0;
            while (iMsg < cMsgs) {
                Map mapMember = aMsg[iMsg].getMap();
                if (!(mapMember != null) ? false : mapMember.isEmpty() ^ true) {
                    if (mapResend == null) {
                        mapResend = new HashMap();
                    }
                    Iterator iterMember = mapMember.keySet().iterator();
                    while (iterMember.hasNext()) {
                        Binary binKey = (Binary)iterMember.next();
                        mapResend.put(binKey, map.get(binKey));
                    }
                }
                ++iMsg;
            }
            cItems = mapResend == null ? 0 : mapResend.size();
            if (cItems == 0) break;
            Component._trace(String.valueOf("Repeating $PutAllRequest for ") + cItems + " out of " + map.size() + " items due to re-distribution", 5);
            map = mapResend;
            this.waitForRedistribution();
        }
        this.validatePartialResponse(listParts);
    }

    protected List query(PartitionSet partitions, Filter filter, boolean fKeysOnly) {
        DistributedCache$QueryRequest msg = (DistributedCache$QueryRequest)this.getService().instantiateMessage("QueryRequest");
        msg.setCacheId(this.getCacheId());
        msg.setFilter(filter);
        msg.setKeysOnly(fKeysOnly);
        return this.sendPartitionedRequest(msg, partitions);
    }

    protected long registerFilter(Filter filter) {
        long lFilterId = this.getService().getSUID();
        this.getFilterArray().set(lFilterId, (Object)filter);
        return lFilterId;
    }

    public void release() {
        throw new UnsupportedOperationException();
    }

    public Object remove(Object oKey) {
        return this.remove(oKey, true);
    }

    public Object remove(Object oKey, boolean fReturn) {
        DistributedCache service = this.getService();
        Binary binKey = (Binary)oKey;
        while (true) {
            Member memberOwner;
            if ((memberOwner = service.getPrimaryOwner(binKey)) == null) {
                if (service.getStorageMemberSet().isEmpty()) {
                    this.onMissingStorage();
                    return null;
                }
            } else {
                DistributedCache$RemoveRequest msg = (DistributedCache$RemoveRequest)service.instantiateMessage("RemoveRequest");
                msg.setToMemberSet(SingleMemberSet.instantiate(memberOwner));
                msg.setCacheId(this.getCacheId());
                msg.setKey(binKey);
                msg.setPrimary(true);
                msg.setReturnRequired(fReturn);
                Object oResponse = service.poll(msg);
                if (oResponse != DistributedCacheKeyRequest.RESPONSE_UNKNOWN) {
                    if (oResponse instanceof RuntimeException) {
                        throw (RuntimeException)oResponse;
                    }
                    return (Binary)oResponse;
                }
            }
            this.waitForRedistribution();
        }
    }

    public boolean removeAll(Collection colKeys) {
        List listResponse;
        RequestTimeoutException eTimeout;
        block7: {
            Set setKeys = colKeys instanceof Set ? (Set)colKeys : new HashSet(colKeys);
            int cKeys = setKeys.size();
            if (cKeys == 0) {
                return false;
            }
            if (cKeys == 1) {
                Binary binKey = (Binary)setKeys.iterator().next();
                return this.remove(binKey, false) != null;
            }
            DistributedCache$RemoveAllRequest msg = (DistributedCache$RemoveAllRequest)this.getService().instantiateMessage("RemoveAllRequest");
            msg.setCacheId(this.getCacheId());
            msg.setKeySet(setKeys);
            eTimeout = null;
            try {
                listResponse = this.sendPartitionedRequest(msg, setKeys);
            }
            catch (RequestTimeoutException e) {
                eTimeout = e;
                listResponse = (List)e.getPartialResult();
                if (!(listResponse == null)) break block7;
                throw e;
            }
        }
        Iterator iter = listResponse.iterator();
        while (iter.hasNext()) {
            DistributedCache$PartialValueResponse response = (DistributedCache$PartialValueResponse)iter.next();
            Object oResult = response.getResult();
            if (oResult instanceof RuntimeException) {
                throw (RuntimeException)oResult;
            }
            if (!(oResult != null)) continue;
            return true;
        }
        if (eTimeout != null) {
            eTimeout.setPartialResult(null);
            throw eTimeout;
        }
        return false;
    }

    public void removeIndex(ValueExtractor extractor) {
        DistributedCache service = this.getService();
        MemberSet setStorage = service.getStorageMemberSet();
        if (setStorage.isEmpty() ^ true) {
            LinkedList listResults = new LinkedList();
            DistributedCache$IndexRequest msg = (DistributedCache$IndexRequest)service.instantiateMessage("IndexRequest");
            msg.setToMemberSet(setStorage);
            msg.setCacheId(this.getCacheId());
            msg.setPartResults(listResults);
            msg.setAdd(false);
            msg.setExtractor(extractor);
            service.poll(msg);
            this.mergePartialResponse(listResults);
        }
    }

    public void removeMapListener(MapListener listener) {
        this.removeMapListener(listener, null);
    }

    public void removeMapListener(MapListener listener, Filter filter) {
        long lFilterId;
        boolean fStandard;
        boolean fEmpty;
        boolean fWasStandard;
        MapListenerSupport support;
        MapListenerSupport mapListenerSupport = support = this.getListenerSupport();
        synchronized (mapListenerSupport) {
            fWasStandard = support.containsStandardListeners(filter);
            support.removeListener(listener, filter);
            fEmpty = support.isEmpty(filter);
            fStandard = support.containsStandardListeners(filter);
            lFilterId = this.getFilterId(filter);
            if (fEmpty) {
                this.getFilterArray().remove(lFilterId);
            }
        }
        if (fEmpty ^ true) {
            if (!fWasStandard ? false : fStandard ^ true) {
                this.addMapListener(listener, filter, true);
            }
            return;
        }
        DistributedCache service = this.getService();
        MemberSet setStorage = service.getStorageMemberSet();
        if (setStorage.isEmpty() ^ true) {
            LinkedList listResults = new LinkedList();
            DistributedCache$ListenerRequest msg = (DistributedCache$ListenerRequest)service.instantiateMessage("ListenerRequest");
            msg.setToMemberSet(setStorage);
            msg.setCacheId(this.getCacheId());
            msg.setPartResults(listResults);
            msg.setAdd(false);
            msg.setFilter(filter);
            msg.setFilterId(lFilterId);
            if (listener instanceof MapListenerSupport.SynchronousListener) {
                service.send(msg);
            } else {
                service.poll(msg);
                this.mergePartialResponse(listResults);
            }
        }
    }

    public void removeMapListener(MapListener listener, Object oKey) {
        boolean fStandard;
        boolean fEmpty;
        boolean fWasStandard;
        MapListenerSupport support;
        Binary binKey = (Binary)oKey;
        MapListenerSupport mapListenerSupport = support = this.getListenerSupport();
        synchronized (mapListenerSupport) {
            fWasStandard = support.containsStandardListeners((Object)binKey);
            support.removeListener(listener, (Object)binKey);
            fEmpty = support.isEmpty((Object)binKey);
            fStandard = support.containsStandardListeners((Object)binKey);
        }
        if (fEmpty ^ true) {
            if (!fWasStandard ? false : fStandard ^ true) {
                this.addMapListener(listener, binKey, true);
            }
            return;
        }
        while (true) {
            DistributedCache service;
            Member memberOwner;
            if ((memberOwner = (service = this.getService()).getPrimaryOwner(binKey)) == null) {
                if (service.getStorageMemberSet().isEmpty()) {
                    return;
                }
                if (Thread.currentThread() == service.getThread()) {
                    return;
                }
            } else {
                DistributedCache$KeyListenerRequest msg = (DistributedCache$KeyListenerRequest)service.instantiateMessage("KeyListenerRequest");
                msg.setToMemberSet(SingleMemberSet.instantiate(memberOwner));
                msg.setCacheId(this.getCacheId());
                msg.setKey(binKey);
                msg.setAdd(false);
                msg.setPrimary(true);
                if (listener instanceof MapListenerSupport.SynchronousListener) {
                    service.send(msg);
                    break;
                }
                Object oResponse = service.poll(msg);
                if (oResponse != DistributedCacheKeyRequest.RESPONSE_UNKNOWN) {
                    if (!(oResponse instanceof RuntimeException)) break;
                    throw (RuntimeException)oResponse;
                }
            }
            this.waitForRedistribution();
        }
    }

    protected List sendPartitionedRequest(KeySetRequest msgRequest, Set setKeys) {
        DistributedCache service = this.getService();
        LinkedList listParts = new LinkedList();
        HashSet setResend = setKeys;
        boolean fClone = false;
        while (true) {
            HashMap mapByOwner = new HashMap();
            setResend = service.splitKeysByOwner(setResend.iterator(), 0, mapByOwner);
            if (mapByOwner.isEmpty()) {
                if (service.getStorageMemberSet().isEmpty()) {
                    this.onMissingStorage();
                    return listParts;
                }
                this.waitForRedistribution();
                continue;
            }
            int cMsgs = mapByOwner.size();
            KeySetRequest[] aMsg = new KeySetRequest[cMsgs];
            HashSet<Poll> setPolls = new HashSet<Poll>();
            Iterator iter = mapByOwner.entrySet().iterator();
            int iMsg = 0;
            while (iMsg < cMsgs) {
                Map.Entry entry = (Map.Entry)iter.next();
                Member member = (Member)entry.getKey();
                Set setMember = (Set)entry.getValue();
                if (fClone) {
                    msgRequest = (KeySetRequest)msgRequest.cloneMessage();
                } else {
                    fClone = true;
                }
                msgRequest.setToMemberSet(SingleMemberSet.instantiate(member));
                msgRequest.setKeySet(setMember);
                msgRequest.setPendingPolls(setPolls);
                msgRequest.setPartResults(listParts);
                setPolls.add(msgRequest.ensureRequestPoll());
                aMsg[iMsg] = msgRequest;
                ++iMsg;
            }
            iMsg = 0;
            while (iMsg < cMsgs) {
                service.post(aMsg[iMsg]);
                ++iMsg;
            }
            try {
                this.waitPolls(setPolls, Service.adjustTimeout(service.getRequestTimeout(), msgRequest.getRequestTimeoutMillis()));
            }
            catch (RequestTimeoutException e) {
                e.setPartialResult(listParts);
                throw e;
            }
            iMsg = 0;
            while (iMsg < cMsgs) {
                Set setReject = aMsg[iMsg].getKeySet();
                if (!(setReject != null) ? false : setReject.isEmpty() ^ true) {
                    if (setResend == null) {
                        setResend = new HashSet();
                    }
                    setResend.addAll(setReject);
                }
                ++iMsg;
            }
            if (setResend == null ? true : setResend.isEmpty()) break;
            Component._trace(String.valueOf("Repeating \"") + msgRequest.get_Name() + "\" for " + setResend.size() + " keys due to the re-distribution", 5);
            this.waitForRedistribution();
        }
        return listParts;
    }

    protected List sendPartitionedRequest(PartialRequest msgRequest, PartitionSet partitions) {
        DistributedCache service = this.getService();
        LinkedList<Object> listParts = new LinkedList<Object>();
        boolean fClone = false;
        while (true) {
            Map mapByOwner = partitions.cardinality() > 1 ? new HashMap() : (Map)new LiteMap();
            service.splitByOwner(partitions, 0, mapByOwner);
            if (mapByOwner.isEmpty()) {
                if (service.getStorageMemberSet().isEmpty()) {
                    this.onMissingStorage();
                    return listParts;
                }
                this.waitForRedistribution();
                continue;
            }
            if (mapByOwner.size() == 1) {
                if (fClone) {
                    msgRequest = (PartialRequest)msgRequest.cloneMessage();
                } else {
                    fClone = true;
                }
                PartitionSet partMember = new PartitionSet(partitions);
                Member member = (Member)mapByOwner.keySet().iterator().next();
                msgRequest.setToMemberSet(SingleMemberSet.instantiate(member));
                msgRequest.setRequestMask(partMember);
                msgRequest.setPartitions(partitions);
                Object oResult = service.poll(msgRequest);
                if (oResult != null) {
                    listParts.add(oResult);
                }
            } else {
                int cMsgs = mapByOwner.size();
                PartialRequest[] aMsg = new PartialRequest[cMsgs];
                HashSet<Poll> setPolls = new HashSet<Poll>();
                Iterator iter = mapByOwner.entrySet().iterator();
                int iMsg = 0;
                while (iMsg < cMsgs) {
                    Map.Entry entry = (Map.Entry)iter.next();
                    Member member = (Member)entry.getKey();
                    PartitionSet partMember = (PartitionSet)entry.getValue();
                    if (fClone) {
                        msgRequest = (PartialRequest)msgRequest.cloneMessage();
                    } else {
                        fClone = true;
                    }
                    msgRequest.setToMemberSet(SingleMemberSet.instantiate(member));
                    msgRequest.setRequestMask(partMember);
                    msgRequest.setPendingPolls(setPolls);
                    msgRequest.setPartResults(listParts);
                    msgRequest.setPartitions(partitions);
                    setPolls.add(msgRequest.ensureRequestPoll());
                    aMsg[iMsg] = msgRequest;
                    ++iMsg;
                }
                iMsg = 0;
                while (iMsg < cMsgs) {
                    service.post(aMsg[iMsg]);
                    ++iMsg;
                }
                try {
                    this.waitPolls(setPolls, Service.adjustTimeout(service.getRequestTimeout(), msgRequest.getRequestTimeoutMillis()));
                }
                catch (RequestTimeoutException e) {
                    e.setPartialResult(listParts);
                    throw e;
                }
            }
            if (partitions.isEmpty()) break;
            Component._trace(String.valueOf("Repeating \"") + msgRequest.get_Name() + "\" for " + partitions.cardinality() + " partitions due to the re-distribution", 5);
            this.waitForRedistribution();
        }
        return listParts;
    }

    public void setCacheId(long lCacheId) {
        this.__m_CacheId = lCacheId;
    }

    public void setCacheName(String sCacheName) {
        this.__m_CacheName = sCacheName;
    }

    protected void setFilterArray(LongArray array) {
        this.__m_FilterArray = array;
    }

    protected void setListenerSupport(MapListenerSupport support) {
        this.__m_ListenerSupport = support;
    }

    protected void setProcessedEvents(Map map) {
        this.__m_ProcessedEvents = map;
    }

    public int size() {
        List listResponse;
        RequestTimeoutException eTimeout;
        block5: {
            DistributedCache$SizeRequest msg = (DistributedCache$SizeRequest)this.getService().instantiateMessage("SizeRequest");
            msg.setCacheId(this.getCacheId());
            eTimeout = null;
            try {
                listResponse = this.sendPartitionedRequest(msg, this.makePartitionSet());
            }
            catch (RequestTimeoutException e) {
                eTimeout = e;
                listResponse = (List)e.getPartialResult();
                if (!(listResponse == null)) break block5;
                throw e;
            }
        }
        int cSize = 0;
        Iterator iter = listResponse.iterator();
        while (iter.hasNext()) {
            DistributedCache$PartialValueResponse response = (DistributedCache$PartialValueResponse)iter.next();
            Object oResult = response.getResult();
            if (oResult instanceof RuntimeException) {
                throw (RuntimeException)oResult;
            }
            if (!(oResult instanceof Integer)) continue;
            cSize += ((Integer)oResult).intValue();
        }
        if (eTimeout != null) {
            eTimeout.setPartialResult((Object)new Integer(cSize));
            throw eTimeout;
        }
        return cSize;
    }

    public boolean unlock(Object oKey) {
        DistributedCache service = this.getService();
        Binary binKey = (Binary)oKey;
        int nMemberId = service.getThisMember().getId();
        long lThreadId = service.getLeaseGranularity() == Lease.BY_THREAD ? Lease.getCurrentThreadId() : 0L;
        while (true) {
            Member memberOwner;
            if ((memberOwner = service.getPrimaryOwner(binKey)) == null) {
                if (service.getStorageMemberSet().isEmpty()) {
                    this.onMissingStorage();
                    return false;
                }
            } else {
                DistributedCache$UnlockRequest msg = (DistributedCache$UnlockRequest)service.instantiateMessage("UnlockRequest");
                msg.setToMemberSet(SingleMemberSet.instantiate(memberOwner));
                msg.setCacheId(this.getCacheId());
                msg.setKey(binKey);
                msg.setLeaseHolderId(nMemberId);
                msg.setLeaseThreadId(lThreadId);
                msg.setPrimary(true);
                Object oResponse = service.poll(msg);
                if (oResponse != DistributedCacheKeyRequest.RESPONSE_UNKNOWN) {
                    if (oResponse instanceof RuntimeException) {
                        throw (RuntimeException)oResponse;
                    }
                    return (Boolean)oResponse;
                }
            }
            this.waitForRedistribution();
        }
    }

    protected void validatePartialResponse(List listResponse) {
        Iterator iter = listResponse.iterator();
        while (iter.hasNext()) {
            Message msgResponse;
            Message msg = (Message)iter.next();
            if (msg instanceof DistributedCache$Response) {
                msgResponse = (DistributedCache$Response)msg;
                switch (((DistributedCacheResponse)msgResponse).getResult()) {
                    case 0: {
                        break;
                    }
                    case 2: {
                        throw ((DistributedCacheResponse)msgResponse).getFailure();
                    }
                    default: {
                        throw new IllegalStateException(String.valueOf("Invalid partial response: ") + msgResponse);
                    }
                }
                continue;
            }
            msgResponse = (DistributedCache$PartialValueResponse)msg;
            Object oResult = ((DistributedCache$PartialValueResponse)msgResponse).getResult();
            if (!(oResult instanceof RuntimeException)) continue;
            throw (RuntimeException)oResult;
        }
    }

    public Collection values() {
        return (DistributedCache$BinaryMap$Values)this._findChild("Values");
    }

    protected void waitForRedistribution() {
        try {
            Thread.sleep(5);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new WrapperException((Throwable)e);
        }
    }

    protected void waitPolls(Set setPolls, long lTimeout) {
        DistributedCache service = this.getService();
        service.flushSend();
        Set set = setPolls;
        synchronized (set) {
            block10: {
                if (setPolls.isEmpty() ^ true) {
                    try {
                        if (lTimeout == 0L) {
                            do {
                                setPolls.wait();
                            } while (setPolls.isEmpty() ^ true);
                            break block10;
                        }
                        long cWait = lTimeout;
                        while (true) {
                            long ldtStart = System.currentTimeMillis();
                            setPolls.wait(cWait);
                            if (!setPolls.isEmpty()) {
                                cWait = service.checkRequestTimeout(ldtStart, lTimeout);
                                continue;
                            }
                            break;
                        }
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new WrapperException((Throwable)e);
                    }
                }
            }
        }
    }
}

