/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.daemon.queueProcessor.service;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.Util;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.DistributedCache;
import com.tangosol.net.partition.PartitionSet;
import com.tangosol.util.Binary;
import com.tangosol.util.ThreadGate;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class DistributedCache$PinningIterator
extends Util
implements Iterator {
    private boolean __m_Concurrent;
    private Iterator __m_FullIterator;
    private Set __m_FullSet;
    private boolean __m_InitialRun;
    private boolean __m_Next;
    private Object __m_NextItem;
    private PartitionSet __m_PinnedPartitions;
    private Set __m_RejectedKeys;
    private PartitionSet __m_RejectedPartitions;
    private boolean __m_Removable;

    public DistributedCache$PinningIterator() {
        this(null, null, true);
    }

    public DistributedCache$PinningIterator(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    protected Set ensureRejectedKeys() {
        HashSet setReject = this.getRejectedKeys();
        if (setReject == null) {
            setReject = new HashSet();
            this.setRejectedKeys(setReject);
        }
        return setReject;
    }

    private boolean evaluate(Object o) {
        Binary binKey = o instanceof Binary ? (Binary)o : (Binary)((Map.Entry)o).getKey();
        if (this.isInitialRun()) {
            DistributedCache service = (DistributedCache)this.get_Module();
            PartitionSet partAccept = this.getPinnedPartitions();
            PartitionSet partReject = this.getRejectedPartitions();
            int iBucket = service.getKeyBucket(binKey);
            if (partAccept.contains(iBucket)) {
                return true;
            }
            if (!(partReject != null) ? false : partReject.contains(iBucket)) {
                this.ensureRejectedKeys().add(binKey);
                return false;
            }
            ThreadGate gate = null;
            boolean fEntered = true;
            if (this.isConcurrent()) {
                gate = service.enterBucket(iBucket);
                fEntered = gate != null;
            }
            if (!fEntered ? false : service.isPrimaryOwner(iBucket)) {
                partAccept.add(iBucket);
                return true;
            }
            if (partReject == null) {
                partReject = new PartitionSet(service.getPartitionCount());
                this.setRejectedPartitions(partReject);
            }
            partReject.add(iBucket);
            this.ensureRejectedKeys().add(binKey);
            if (gate != null) {
                gate.exit();
            }
            return false;
        }
        Set setRejected = this.getRejectedKeys();
        return setRejected == null ? true : setRejected.contains(binKey) ^ true;
    }

    private Iterator getFullIterator() {
        return this.__m_FullIterator;
    }

    public Set getFullSet() {
        return this.__m_FullSet;
    }

    private Object getNextItem() {
        return this.__m_NextItem;
    }

    public PartitionSet getPinnedPartitions() {
        return this.__m_PinnedPartitions;
    }

    public Set getRejectedKeys() {
        return this.__m_RejectedKeys;
    }

    public PartitionSet getRejectedPartitions() {
        return this.__m_RejectedPartitions;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/daemon/queueProcessor/service/DistributedCache$PinningIterator".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    public static Component get_Instance() {
        return new DistributedCache$PinningIterator();
    }

    private final Component get_Module() {
        return this.get_Parent();
    }

    public boolean hasNext() {
        boolean fNext = this.isNext();
        if (fNext) {
            return true;
        }
        Iterator iter = this.getFullIterator();
        while (iter.hasNext()) {
            Object oNext = iter.next();
            if (!this.evaluate(oNext)) continue;
            this.setNextItem(oNext);
            fNext = true;
            this.setNext(true);
            break;
        }
        this.setRemovable(false);
        return fNext;
    }

    public boolean isConcurrent() {
        return this.__m_Concurrent;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    private boolean isInitialRun() {
        return this.__m_InitialRun;
    }

    private boolean isNext() {
        return this.__m_Next;
    }

    private boolean isRemovable() {
        return this.__m_Removable;
    }

    public Object next() {
        if (this.isNext()) {
            this.setNext(false);
            this.setRemovable(true);
            return this.getNextItem();
        }
        throw new NoSuchElementException();
    }

    public void remove() {
        if (!this.isRemovable()) {
            throw new IllegalStateException();
        }
        this.setRemovable(false);
        Object oNext = this.getNextItem();
        this.ensureRejectedKeys().add(oNext instanceof Map.Entry ? ((Map.Entry)oNext).getKey() : oNext);
    }

    public void reset() {
        this.setNext(false);
        this.setRemovable(false);
        this.setInitialRun(false);
        this.setFullIterator(this.getFullSet().iterator());
    }

    protected void setConcurrent(boolean fConcurrent) {
        this.__m_Concurrent = fConcurrent;
    }

    private void setFullIterator(Iterator iter) {
        this.__m_FullIterator = iter;
    }

    public void setFullSet(Set set) {
        Component._assert(this.getFullSet() == null, "Not resettable");
        DistributedCache service = (DistributedCache)this.get_Module();
        this.setPinnedPartitions(new PartitionSet(service.getPartitionCount()));
        this.setConcurrent(service.getDaemonPool().isStarted());
        this.setFullIterator(set.iterator());
        this.setInitialRun(true);
        this.__m_FullSet = set;
    }

    private void setInitialRun(boolean f) {
        this.__m_InitialRun = f;
    }

    private void setNext(boolean f) {
        this.__m_Next = f;
    }

    private void setNextItem(Object oNext) {
        this.__m_NextItem = oNext;
    }

    protected void setPinnedPartitions(PartitionSet partitions) {
        this.__m_PinnedPartitions = partitions;
    }

    protected void setRejectedKeys(Set set) {
        this.__m_RejectedKeys = set;
    }

    protected void setRejectedPartitions(PartitionSet partitions) {
        this.__m_RejectedPartitions = partitions;
    }

    private void setRemovable(boolean f) {
        this.__m_Removable = f;
    }

    public int size() {
        Set setReject = this.getRejectedKeys();
        int cReject = setReject == null ? 0 : setReject.size();
        return this.getFullSet().size() - cReject;
    }
}

