/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.daemon.queueProcessor.service;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.Util;
import com.tangosol.coherence.component.net.Lease;
import com.tangosol.coherence.component.net.Member;
import com.tangosol.coherence.component.net.MemberSet;
import com.tangosol.coherence.component.net.memberSet.actualMemberSet.ServiceMemberSet;
import com.tangosol.coherence.component.net.message.DistributedCacheResponse;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.DistributedCache;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.DistributedCache$LockRequest;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.DistributedCache$MapEvent;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.DistributedCache$Response;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.DistributedCache$Storage$BinaryEntry;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.DistributedCache$Storage$EntryStatus;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.DistributedCache$Storage$MapIndex;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.DistributedCache$Storage$PrimaryListener;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.DistributedCache$Storage$ProxyStorage;
import com.tangosol.io.WriteBuffer;
import com.tangosol.io.nio.BinaryMap;
import com.tangosol.io.nio.ByteBufferManager;
import com.tangosol.io.nio.DirectBufferManager;
import com.tangosol.io.nio.MappedBufferManager;
import com.tangosol.net.BackingMapManager;
import com.tangosol.net.BackingMapManagerContext;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.DefaultConfigurableCacheFactory;
import com.tangosol.net.cache.CacheMap;
import com.tangosol.net.management.Registry;
import com.tangosol.net.partition.PartitionSet;
import com.tangosol.run.component.EventDeathException;
import com.tangosol.run.xml.XmlConfigurable;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.util.AtomicCounter;
import com.tangosol.util.Base;
import com.tangosol.util.Binary;
import com.tangosol.util.BinaryWriteBuffer;
import com.tangosol.util.ConcurrentMap;
import com.tangosol.util.Converter;
import com.tangosol.util.ConverterCollections;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.Filter;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.InvocableMapHelper;
import com.tangosol.util.ListMap;
import com.tangosol.util.LiteMap;
import com.tangosol.util.LiteSet;
import com.tangosol.util.MapEvent;
import com.tangosol.util.MapListener;
import com.tangosol.util.NullImplementation;
import com.tangosol.util.ObservableMap;
import com.tangosol.util.SafeHashMap;
import com.tangosol.util.SafeLinkedList;
import com.tangosol.util.SubSet;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.WrapperConcurrentMap;
import com.tangosol.util.WrapperException;
import com.tangosol.util.comparator.EntryComparator;
import com.tangosol.util.filter.IndexAwareFilter;
import com.tangosol.util.filter.LimitFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DistributedCache$Storage
extends Util {
    public static final int BACKUP_CUSTOM = 3;
    public static final int BACKUP_FILE = 2;
    public static final int BACKUP_OFFHEAP = 1;
    public static final int BACKUP_ONHEAP = 0;
    public static final int BACKUP_SCHEME = 4;
    public static final Binary BINARY_EXISTS;
    public static final int EVENT_NONE = 0;
    public static final int LISTEN_CONDITIONAL = 2;
    public static final int LISTEN_HEAVY = 3;
    public static final int LISTEN_LITE = 1;
    public static final int LISTEN_NONE = 0;
    public static final int QUERY_AGGREGATE = 4;
    public static final int QUERY_ENTRIES = 2;
    public static final int QUERY_INVOKE = 3;
    public static final int QUERY_KEYS = 1;
    private transient Map __m_BackupKeyListenerMap;
    private Map __m_BackupLeaseMap;
    private Map __m_BackupMap;
    private long __m_CacheId;
    private String __m_CacheName;
    private transient Map __m_ConfiguredBackupListeners;
    private transient Converter __m_ConverterUp;
    private transient Converter __m_ConverterValueDown;
    private Map __m_FilterIdMap;
    private transient Map __m_IgnoreMap;
    private volatile Map __m_IndexMap;
    private Map __m_KeyListenerMap;
    private Map __m_LeaseMap;
    private transient boolean __m_ListenerHeavy;
    private transient Map __m_ListenerMap;
    private List __m_PendingLockRequest;
    private boolean __m_PreferPutAllBackup;
    private boolean __m_PreferPutAllPrimary;
    private transient MapListener __m_PrimaryListener;
    private transient ConcurrentMap __m_ResourceControlMap;
    private Map __m_ResourceMap;
    private long __m_StatsEventsDispatched;
    private transient AtomicCounter __m_StatsEvictions;
    private transient AtomicCounter __m_StatsInserts;
    private long __m_StatsListenerRegistrations;
    private transient AtomicCounter __m_StatsRemoves;
    private transient ThreadLocal __m_ThreadLocal;
    private boolean __m_Valid;
    private static ListMap __mapChildren;

    static {
        try {
            BINARY_EXISTS = new Binary();
        }
        catch (Exception e) {
            throw new WrapperException((Throwable)e);
        }
        DistributedCache$Storage.__initStatic();
    }

    public DistributedCache$Storage() {
        this(null, null, true);
    }

    public DistributedCache$Storage(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setLeaseMap((Map)new SafeHashMap());
            this.setPendingLockRequest((List)new SafeLinkedList());
            this.setResourceMap((Map)new SafeHashMap());
            this.setValid(true);
        }
        catch (Exception e) {
            throw new WrapperException((Throwable)e);
        }
        this._addChild(new DistributedCache$Storage$ProxyStorage("ProxyStorage", this, true), "ProxyStorage");
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    private static void __initStatic() {
        __mapChildren = new ListMap();
        Object object = __mapChildren.put((Object)"BinaryEntry", (Object)DistributedCache$Storage$BinaryEntry.get_CLASS());
        Object object2 = __mapChildren.put((Object)"EntryStatus", (Object)DistributedCache$Storage$EntryStatus.get_CLASS());
        Object object3 = __mapChildren.put((Object)"MapIndex", (Object)DistributedCache$Storage$MapIndex.get_CLASS());
        Object object4 = __mapChildren.put((Object)"PrimaryListener", (Object)DistributedCache$Storage$PrimaryListener.get_CLASS());
    }

    public void addIndex(ValueExtractor extractor, boolean fOrdered, Comparator comparator) {
        Map mapIndex = this.ensureIndexMap();
        DistributedCache$Storage$MapIndex index = (DistributedCache$Storage$MapIndex)mapIndex.get(extractor);
        if (index == null) {
            try {
                int cAttempts = 4;
                while (true) {
                    try {
                        index = (DistributedCache$Storage$MapIndex)this._newChild("MapIndex");
                        index.initialize(extractor, fOrdered, comparator);
                        index.rebuild();
                    }
                    catch (ConcurrentModificationException cme) {
                        if (--cAttempts > 0) {
                            Thread.sleep(5L);
                            continue;
                        }
                        throw cme;
                    }
                    break;
                }
            }
            catch (Throwable e) {
                Component._trace(String.valueOf("Exception occured during index rebuild: ") + Component.getStackTrace(e), 1);
                this.removeIndex(extractor);
                DistributedCache$Storage.rethrow(e);
            }
            mapIndex.put(extractor, index);
        } else if ((!(fOrdered ^ index.isOrdered() ^ true) ? false : Base.equals((Object)comparator, (Object)index.getComparator())) ^ true) {
            throw new IllegalArgumentException(String.valueOf("Index for ") + extractor + " already exists;" + " remove the index and add it with the new settings");
        }
    }

    public void addKeyListener(Member member, Binary binKey, boolean fLite, boolean fPrimary) {
        this.addProxyMember(fPrimary ? this.ensureKeyListenerMap() : this.ensureBackupKeyListenerMap(), binKey, member, fLite);
        if (fPrimary) {
            this.setStatsListenerRegistrations(this.getStatsListenerRegistrations() + 1L);
        }
    }

    public void addListener(Member member, Filter filter, long lFilterId, boolean fLite) {
        Set setFilterId;
        Map mapMemberFilterId;
        this.addProxyMember(this.ensureListenerMap(), filter, member, fLite);
        Map mapFilterId = this.getFilterIdMap();
        if (mapFilterId == null) {
            mapFilterId = new SafeHashMap();
            this.setFilterIdMap(mapFilterId);
        }
        if ((mapMemberFilterId = (Map)mapFilterId.get(member)) == null) {
            mapMemberFilterId = new SafeHashMap();
            mapFilterId.put(member, mapMemberFilterId);
        }
        if ((setFilterId = (Set)mapMemberFilterId.get(filter)) == null) {
            setFilterId = new LiteSet();
            mapMemberFilterId.put(filter, setFilterId);
        }
        setFilterId.add(new Long(lFilterId));
        if (fLite ^ true) {
            this.setListenerHeavy(true);
        }
        this.setStatsListenerRegistrations(this.getStatsListenerRegistrations() + 1L);
    }

    protected void addProxyMember(Map map, Object anyKey, Member member, Object oProxy) {
        Map mapMembers = (Map)map.get(anyKey);
        if (mapMembers == null) {
            mapMembers = new SafeHashMap();
            map.put(anyKey, mapMembers);
        }
        mapMembers.put(member, oProxy);
    }

    public Set clear(PartitionSet partMask) {
        DistributedCache service = this.getService();
        HashSet<Binary> setKeys = new HashSet<Binary>();
        int nEvent = MapEvent.ENTRY_DELETED;
        DistributedCache$Storage$BinaryEntry entryTemp = null;
        if (this.isIndexed()) {
            entryTemp = this.instantiateBinaryEntry(null, null, true);
        }
        Iterator iter = this.getResourceMap().entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry)iter.next();
            Binary binKey = (Binary)entry.getKey();
            if (!partMask.contains(service.getKeyBucket(binKey))) continue;
            Binary binValue = (Binary)entry.getValue();
            this.registerIgnoreKey(binKey);
            try {
                iter.remove();
                setKeys.add(binKey);
                this.getStatsRemoves().increment();
            }
            finally {
                Object var11_10 = null;
                this.unregisterIgnoreKey(binKey, nEvent);
            }
            if (entryTemp != null) {
                entryTemp.setBinaryKey(binKey);
                this.updateIndex(nEvent, entryTemp);
            }
            this.dispatch(nEvent, binKey, binValue, null, false);
        }
        return setKeys;
    }

    protected void dispatch(int nEventType, Binary binKey, Binary binValueOld, Binary binValueNew, boolean fSynthetic) {
        DistributedCache$MapEvent msg;
        Map mapMembers;
        Map mapListeners = this.getListenerMap();
        Map mapKeyListeners = this.getKeyListenerMap();
        int cFilters = mapListeners == null ? 0 : mapListeners.size();
        int cKeys = mapKeyListeners == null ? 0 : mapKeyListeners.size();
        if (!(cFilters == 0) ? false : cKeys == 0) {
            return;
        }
        DistributedCache service = this.getService();
        MemberSet setStd = new MemberSet();
        MemberSet setLite = new MemberSet();
        long[] alFilterId = null;
        if (cKeys > 0 && (mapMembers = (Map)mapKeyListeners.get(binKey)) != null) {
            Iterator iter = mapMembers.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = (Map.Entry)iter.next();
                Member member = (Member)entry.getKey();
                Boolean FLite = (Boolean)entry.getValue();
                if (FLite.booleanValue()) {
                    setLite.add(member);
                    continue;
                }
                setStd.add(member);
            }
        }
        if (cFilters > 0) {
            HashSet setFilters = new HashSet();
            MapEvent evtConv = null;
            Iterator iterFilter = mapListeners.keySet().iterator();
            while (iterFilter.hasNext()) {
                boolean fHit;
                Filter filter = (Filter)iterFilter.next();
                if (filter == null) {
                    fHit = true;
                } else {
                    if (evtConv == null) {
                        Converter conv = this.getConverterUp();
                        DistributedCache$Storage$ProxyStorage mapProxy = (DistributedCache$Storage$ProxyStorage)this._findChild("ProxyStorage");
                        MapEvent evtProxy = new MapEvent((ObservableMap)mapProxy, nEventType, (Object)binKey, (Object)binValueOld, (Object)binValueNew);
                        evtConv = ConverterCollections.getMapEvent((ObservableMap)mapProxy, (MapEvent)evtProxy, (Converter)conv, (Converter)conv);
                    }
                    try {
                        fHit = filter.evaluate(evtConv);
                    }
                    catch (RuntimeException e) {
                        Component._trace(String.valueOf("Exception occured during filter evaluation: ") + filter + "; removing the filter...", 1);
                        Component._trace(e);
                        iterFilter.remove();
                        continue;
                    }
                }
                if (!fHit) continue;
                Map mapMembers2 = (Map)mapListeners.get(filter);
                Iterator iter = mapMembers2.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry entry = (Map.Entry)iter.next();
                    Member member = (Member)entry.getKey();
                    Boolean FLite = (Boolean)entry.getValue();
                    try {
                        Map mapMemberFilterId = (Map)this.getFilterIdMap().get(member);
                        Set setFilterId = (Set)mapMemberFilterId.get(filter);
                        setFilters.addAll(setFilterId);
                    }
                    catch (NullPointerException e) {
                        Component._trace(String.valueOf("Invalid listeners for member ") + member.getId() + " filter " + filter + "; removing member listeners...", 1);
                        try {
                            iter.remove();
                            this.getFilterIdMap().remove(member);
                        }
                        catch (RuntimeException x) {}
                        continue;
                    }
                    if (FLite.booleanValue()) {
                        if (!(setStd.contains(member) ^ true)) continue;
                        setLite.add(member);
                        continue;
                    }
                    setStd.add(member);
                    setLite.remove(member);
                }
            }
            int cFilterIds = setFilters.size();
            if (cFilterIds > 0) {
                alFilterId = new long[cFilterIds];
                Iterator iter = setFilters.iterator();
                int i = 0;
                while (iter.hasNext()) {
                    alFilterId[i] = (Long)iter.next();
                    ++i;
                }
            }
        }
        if (setLite.isEmpty() ^ true) {
            msg = (DistributedCache$MapEvent)service.instantiateMessage("MapEvent");
            msg.setToMemberSet(setLite);
            msg.setCacheId(this.getCacheId());
            msg.setCacheName(this.getCacheName());
            msg.setEventType(nEventType);
            msg.setKey(binKey);
            msg.setSynthetic(fSynthetic);
            msg.setFilterId(alFilterId);
            service.send(msg);
            this.setStatsEventsDispatched(this.getStatsEventsDispatched() + 1L);
        }
        if (setStd.isEmpty() ^ true) {
            msg = (DistributedCache$MapEvent)service.instantiateMessage("MapEvent");
            msg.setToMemberSet(setStd);
            msg.setCacheId(this.getCacheId());
            msg.setCacheName(this.getCacheName());
            msg.setEventType(nEventType);
            msg.setKey(binKey);
            msg.setOldValue(binValueOld);
            msg.setNewValue(binValueNew);
            msg.setSynthetic(fSynthetic);
            msg.setFilterId(alFilterId);
            service.send(msg);
            this.setStatsEventsDispatched(this.getStatsEventsDispatched() + 1L);
        }
    }

    protected Map ensureBackupKeyListenerMap() {
        Map map = this.getBackupKeyListenerMap();
        if (map == null) {
            DistributedCache$Storage distributedCache$Storage = this;
            synchronized (distributedCache$Storage) {
                map = this.getBackupKeyListenerMap();
                if (map == null) {
                    map = new SafeHashMap();
                    this.setBackupKeyListenerMap(map);
                }
            }
        }
        return map;
    }

    public Map ensureIndexMap() {
        Map mapIndex = this.getIndexMap();
        if (mapIndex == null) {
            DistributedCache$Storage distributedCache$Storage = this;
            synchronized (distributedCache$Storage) {
                mapIndex = this.getIndexMap();
                if (mapIndex == null) {
                    mapIndex = new SafeHashMap();
                    this.setIndexMap(mapIndex);
                }
            }
        }
        return mapIndex;
    }

    protected Map ensureKeyListenerMap() {
        Map map = this.getKeyListenerMap();
        if (map == null) {
            DistributedCache$Storage distributedCache$Storage = this;
            synchronized (distributedCache$Storage) {
                map = this.getKeyListenerMap();
                if (map == null) {
                    map = new SafeHashMap();
                    this.setKeyListenerMap(map);
                }
            }
        }
        return map;
    }

    protected Map ensureListenerMap() {
        Map map = this.getListenerMap();
        if (map == null) {
            DistributedCache$Storage distributedCache$Storage = this;
            synchronized (distributedCache$Storage) {
                map = this.getListenerMap();
                if (map == null) {
                    map = new SafeHashMap();
                    this.setListenerMap(map);
                }
            }
        }
        return map;
    }

    protected Object[] extractBinaryEntries(Object[] aEntry, LimitFilter filterLimit) {
        EntryComparator comparator = new EntryComparator(filterLimit.getComparator(), EntryComparator.CMP_ENTRY);
        Arrays.sort(aEntry, comparator);
        filterLimit = (LimitFilter)filterLimit.clone();
        filterLimit.setComparator((Comparator)comparator);
        aEntry = filterLimit.extractPage(aEntry);
        return aEntry;
    }

    protected void firePendingLocks(int iBucket) {
        List listPending;
        DistributedCache service = this.getService();
        ArrayList<DistributedCache$LockRequest> listFire = null;
        List list = listPending = this.getPendingLockRequest();
        synchronized (list) {
            if (listPending.isEmpty() ^ true) {
                listFire = new ArrayList<DistributedCache$LockRequest>(listPending.size());
                Iterator iter = listPending.iterator();
                while (iter.hasNext()) {
                    DistributedCache$LockRequest msgLock = (DistributedCache$LockRequest)iter.next();
                    if (!(service.getKeyBucket(msgLock.getKey()) == iBucket)) continue;
                    iter.remove();
                    listFire.add(msgLock);
                }
            }
        }
        if (!(listFire != null) ? false : listFire.isEmpty() ^ true) {
            Iterator iter = listFire.iterator();
            while (iter.hasNext()) {
                DistributedCache$LockRequest msgLock = (DistributedCache$LockRequest)iter.next();
                try {
                    msgLock.onReceived();
                }
                catch (EventDeathException e) {
                    // empty catch block
                }
            }
        }
    }

    public void firePendingLocks(Binary binKey) {
        DistributedCache$LockRequest msgLock;
        Iterator iter;
        List listPending;
        ArrayList<DistributedCache$LockRequest> listFire = null;
        List list = listPending = this.getPendingLockRequest();
        synchronized (list) {
            if (listPending.isEmpty() ^ true) {
                listFire = new ArrayList<DistributedCache$LockRequest>(listPending.size());
                iter = listPending.iterator();
                while (iter.hasNext()) {
                    msgLock = (DistributedCache$LockRequest)iter.next();
                    if (!msgLock.getKey().equals((Object)binKey)) continue;
                    iter.remove();
                    listFire.add(msgLock);
                }
            }
        }
        if (!(listFire != null) ? false : listFire.isEmpty() ^ true) {
            DistributedCache service = this.getService();
            iter = listFire.iterator();
            while (iter.hasNext()) {
                msgLock = (DistributedCache$LockRequest)iter.next();
                try {
                    if (Thread.currentThread() == service.getThread()) {
                        msgLock.onReceived();
                        continue;
                    }
                    service.onLockRequest(msgLock);
                }
                catch (EventDeathException e) {
                    // empty catch block
                }
            }
        }
    }

    public Map getBackupKeyListenerMap() {
        return this.__m_BackupKeyListenerMap;
    }

    public Map getBackupLeaseMap() {
        return this.__m_BackupLeaseMap;
    }

    public Map getBackupMap() {
        return this.__m_BackupMap;
    }

    public long getCacheId() {
        return this.__m_CacheId;
    }

    public String getCacheName() {
        return this.__m_CacheName;
    }

    protected Map getConfiguredBackupListeners() {
        Map mapListeners = this.__m_ConfiguredBackupListeners;
        if (mapListeners == null) {
            mapListeners = new SafeHashMap();
            this.setConfiguredBackupListeners(mapListeners);
        }
        return mapListeners;
    }

    public Converter getConverterUp() {
        return this.__m_ConverterUp;
    }

    public Converter getConverterValueDown() {
        return this.__m_ConverterValueDown;
    }

    public Map getFilterIdMap() {
        return this.__m_FilterIdMap;
    }

    public Map getIgnoreMap() {
        ThreadLocal tlo = this.getThreadLocal();
        if (tlo == null) {
            return this.__m_IgnoreMap;
        }
        Map map = (Map)tlo.get();
        if (map == null) {
            map = new LiteMap();
            tlo.set(map);
        }
        return map;
    }

    public Map getIndexMap() {
        return this.__m_IndexMap;
    }

    public Map getKeyListenerMap() {
        return this.__m_KeyListenerMap;
    }

    public Map getLeaseMap() {
        return this.__m_LeaseMap;
    }

    public Map getListenerMap() {
        return this.__m_ListenerMap;
    }

    protected int getListenerType(Binary binKey) {
        Map mapMembers;
        if (this.isListenerHeavy()) {
            return LISTEN_HEAVY;
        }
        Map mapFilters = this.getListenerMap();
        if (!(mapFilters != null) ? false : mapFilters.isEmpty() ^ true) {
            return LISTEN_CONDITIONAL;
        }
        Map mapKeys = this.getKeyListenerMap();
        int cKeys = mapKeys == null ? 0 : mapKeys.size();
        int iType = LISTEN_NONE;
        if (cKeys > 0 && (mapMembers = (Map)mapKeys.get(binKey)) != null) {
            iType = LISTEN_LITE;
            Iterator iter = mapMembers.values().iterator();
            while (iter.hasNext()) {
                Boolean FLite = (Boolean)iter.next();
                if (!(FLite ^ true)) continue;
                iType = LISTEN_HEAVY;
                break;
            }
        }
        return iType;
    }

    public List getPendingLockRequest() {
        return this.__m_PendingLockRequest;
    }

    public MapListener getPrimaryListener() {
        return this.__m_PrimaryListener;
    }

    public ConcurrentMap getResourceControlMap() {
        return this.__m_ResourceControlMap;
    }

    public Map getResourceMap() {
        return this.__m_ResourceMap;
    }

    public DistributedCache getService() {
        return (DistributedCache)this.get_Module();
    }

    public long getStatsEventsDispatched() {
        return this.__m_StatsEventsDispatched;
    }

    public AtomicCounter getStatsEvictions() {
        return this.__m_StatsEvictions;
    }

    public AtomicCounter getStatsInserts() {
        return this.__m_StatsInserts;
    }

    public long getStatsListenerRegistrations() {
        return this.__m_StatsListenerRegistrations;
    }

    public AtomicCounter getStatsRemoves() {
        return this.__m_StatsRemoves;
    }

    protected ThreadLocal getThreadLocal() {
        return this.__m_ThreadLocal;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/daemon/queueProcessor/service/DistributedCache$Storage".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    public static Component get_Instance() {
        return new DistributedCache$Storage();
    }

    private final Component get_Module() {
        return this.get_Parent();
    }

    public void insertBackupTransfer(Map.Entry[] aEntry) {
        boolean fPutAll = this.isPreferPutAllBackup();
        int cEntries = aEntry.length;
        Map map = fPutAll ? new HashMap(cEntries) : this.getBackupMap();
        int i = 0;
        while (i < cEntries) {
            Map.Entry entry = aEntry[i];
            map.put(entry.getKey(), entry.getValue());
            ++i;
        }
        if (fPutAll) {
            this.getBackupMap().putAll(map);
        }
    }

    public void insertLeaseTransfer(Lease[] aLease, boolean fPrimary) {
        Map map = fPrimary ? this.getLeaseMap() : this.getBackupLeaseMap();
        int i = 0;
        int c = aLease.length;
        while (i < c) {
            Lease lease = aLease[i];
            map.put(lease.getResourceKey(), lease);
            ++i;
        }
    }

    public void insertListenerTransfer(Map.Entry[] aEntry, boolean fPrimary) {
        Map map = fPrimary ? this.ensureKeyListenerMap() : this.ensureBackupKeyListenerMap();
        int i = 0;
        int c = aEntry.length;
        while (i < c) {
            Map.Entry entry = aEntry[i];
            map.put(entry.getKey(), entry.getValue());
            ++i;
        }
    }

    protected void insertPrimaryResource(Binary binKey, Binary binValue) {
        boolean fExpiry;
        Map map = this.getResourceMap();
        boolean fPutAll = this.isPreferPutAllPrimary();
        Binary binExpiry = ExternalizableHelper.getDecoration((Binary)binValue, (int)ExternalizableHelper.DECO_EXPIRY);
        boolean bl = fExpiry = binExpiry != null;
        if (fExpiry) {
            if (map instanceof CacheMap) {
                long ldtTime = this.getService().getClusterTime();
                long cMillis = CacheMap.EXPIRY_DEFAULT;
                try {
                    long ldtExpiry = binExpiry.getBufferInput().readLong();
                    cMillis = ldtExpiry == CacheMap.EXPIRY_NEVER ? ldtExpiry : Math.max(ldtExpiry - ldtTime, 1L);
                }
                catch (Exception e) {
                    // empty catch block
                }
                ((CacheMap)map).put((Object)binKey, (Object)binValue, cMillis);
            } else {
                fExpiry = false;
                Component._trace(String.valueOf("Dropping an entry expiry attribute due to incompatible ") + "backing map configuration (cache=" + this.getCacheName() + ')', 1);
            }
        }
        if (fExpiry ^ true) {
            if (fPutAll) {
                map.putAll(Collections.singletonMap(binKey, binValue));
            } else {
                map.put(binKey, binValue);
            }
        }
        this.getStatsInserts().increment();
    }

    public void insertPrimaryTransfer(Map.Entry[] aEntry) {
        DistributedCache$Storage$BinaryEntry entryTemp = null;
        if (this.isIndexed()) {
            entryTemp = this.instantiateBinaryEntry(null, null, true);
        }
        int nEvent = MapEvent.ENTRY_INSERTED;
        int i = 0;
        int c = aEntry.length;
        while (i < c) {
            Binary binUpdate;
            Object var10_9;
            Map.Entry entry = aEntry[i];
            Binary binKey = (Binary)entry.getKey();
            Binary binValue = (Binary)entry.getValue();
            this.registerIgnoreKey(binKey);
            try {
                this.insertPrimaryResource(binKey, binValue);
            }
            catch (Throwable throwable) {
                var10_9 = null;
                binUpdate = this.unregisterIgnoreKey(binKey, nEvent);
                if (binUpdate != BINARY_EXISTS) {
                    binValue = binUpdate;
                }
                throw throwable;
            }
            var10_9 = null;
            binUpdate = this.unregisterIgnoreKey(binKey, nEvent);
            if (binUpdate != BINARY_EXISTS) {
                binValue = binUpdate;
            }
            if (!(entryTemp != null) ? false : binValue != null) {
                entryTemp.setBinaryKey(binKey);
                entryTemp.setBinaryValue(binValue);
                this.updateIndex(nEvent, entryTemp);
            }
            ++i;
        }
    }

    protected void instantiateBackupMap() {
        DistributedCache service = this.getService();
        Map mapBackup = null;
        switch (service.getBackupType()) {
            case 3: {
                try {
                    mapBackup = (Map)service.getBackupClass().newInstance();
                    if (!(mapBackup instanceof XmlConfigurable)) break;
                    XmlElement xmlBackup = service.getServiceConfig().getSafeElement("backup-storage");
                    ((XmlConfigurable)mapBackup).setConfig(xmlBackup);
                }
                catch (Exception e) {
                    Component._trace(String.valueOf("Failed to create a 'custom' backup map: ") + e + "\nusing the 'on-heap' type instead", 1);
                }
                break;
            }
            case 2: {
                mapBackup = new BinaryMap((ByteBufferManager)new MappedBufferManager(service.getBackupInitSize(), service.getBackupMaxSize(), service.getBackupDir()));
                break;
            }
            case 1: {
                mapBackup = new BinaryMap((ByteBufferManager)new DirectBufferManager(service.getBackupInitSize(), service.getBackupMaxSize()));
                break;
            }
            case 4: {
                try {
                    DefaultConfigurableCacheFactory factory = (DefaultConfigurableCacheFactory)CacheFactory.getConfigurableCacheFactory();
                    String sName = this.getCacheName();
                    DefaultConfigurableCacheFactory.CacheInfo info = factory.findSchemeMapping(sName);
                    XmlElement xmlScheme = factory.resolveScheme(new DefaultConfigurableCacheFactory.CacheInfo(sName, service.getBackupScheme(), info.getAttributes()));
                    xmlScheme.addAttribute("target").setString("backup");
                    mapBackup = factory.configureBackingMap(info, xmlScheme, (BackingMapManagerContext)service.getBackingMapContext(), null, this.getConfiguredBackupListeners());
                }
                catch (ClassCastException e) {
                    Component._trace(String.valueOf("\"Scheme\" backup is only supported by ") + "com.tangosol.net.DefaultConfigurableCacheFactory" + "\nusing the 'on-heap' type instead", 1);
                }
                break;
            }
        }
        if (mapBackup != null) {
            Map mapOld = this.getBackupMap();
            if (mapOld.isEmpty() ^ true) {
                Component._trace(String.valueOf("Transferring ") + mapOld.size() + " to backup for: " + this.getCacheName(), 5);
                mapBackup.putAll(mapOld);
                mapOld.clear();
            }
            this.setPreferPutAllBackup(DefaultConfigurableCacheFactory.isPutAllOptimized((Map)mapBackup));
            this.setBackupMap(mapBackup);
        }
    }

    public DistributedCache$Storage$BinaryEntry instantiateBinaryEntry(Binary binKey, Binary binValue, boolean fReadOnly) {
        DistributedCache$Storage$BinaryEntry entry = new DistributedCache$Storage$BinaryEntry();
        entry.set_Feed(this);
        entry.setBinaryKey(binKey);
        entry.setBinaryValue(binValue);
        if (fReadOnly) {
            entry.ensureReadOnly();
        }
        return entry;
    }

    protected MapListener instantiatePrimaryListener() {
        DistributedCache$Storage$PrimaryListener listener = (DistributedCache$Storage$PrimaryListener)this._newChild("PrimaryListener");
        this.setPrimaryListener(listener);
        return listener;
    }

    protected void instantiateResourceMap() {
        String sName = this.getCacheName();
        DistributedCache service = this.getService();
        BackingMapManager manager = service.getBackingMapManager();
        if (!(manager == null)) {
            Map mapNew = null;
            try {
                mapNew = manager.instantiateBackingMap(sName);
                if (mapNew == null) {
                    Component._trace(String.valueOf("BackingMapManager ") + manager.getClass().getName() + ": returned \"null\" for a cache: " + sName, 1);
                } else if (mapNew.isEmpty() ^ true) {
                    mapNew.clear();
                }
            }
            catch (RuntimeException e) {
                Component._trace(String.valueOf("BackingMapManager ") + manager.getClass().getName() + ": failed to instantiate a cache: " + sName, 1);
                Component._trace(e);
            }
            if (mapNew != null) {
                Map mapOld = this.getResourceMap();
                if (mapOld.isEmpty() ^ true) {
                    Component._trace(String.valueOf("Transferring ") + mapOld.size() + " to: " + sName, 5);
                    mapNew.putAll(mapOld);
                    mapOld.clear();
                }
                if (mapNew instanceof ObservableMap) {
                    ((ObservableMap)mapNew).addMapListener(this.instantiatePrimaryListener());
                }
                this.setPreferPutAllPrimary(DefaultConfigurableCacheFactory.isPutAllOptimized((Map)mapNew));
                this.setResourceMap(mapNew);
            }
        }
    }

    public void invalidate() {
        DistributedCache service = this.getService();
        Map mapPrime = this.getResourceMap();
        MapListener listener = this.getPrimaryListener();
        if (listener != null) {
            ((ObservableMap)mapPrime).removeMapListener(listener);
        }
        this.setListenerMap(null);
        this.setKeyListenerMap(null);
        String sName = this.getCacheName();
        BackingMapManager manager = service.getBackingMapManager();
        if (sName != null) {
            Registry registry;
            if (manager != null) {
                try {
                    manager.releaseBackingMap(sName, mapPrime);
                }
                catch (RuntimeException e) {
                    Component._trace(String.valueOf("BackingMapManager ") + manager.getClass().getName() + ": failed to release a cache: " + sName, 1);
                    Component._trace(e);
                }
            }
            if ((registry = service.getCluster().getManagement()) != null) {
                String sBean = Registry.STORAGE_MANAGER_TYPE + ",service=" + service.getServiceName() + ",cache=" + sName;
                registry.unregister(registry.ensureGlobalName(sBean));
            }
        }
        if (service.getBackupCount() > 0) {
            this.setBackupKeyListenerMap(null);
            this.invalidateBackupMap();
        }
        this.getLeaseMap().clear();
        this.setResourceMap(Collections.EMPTY_MAP);
        this.setIndexMap(null);
        this.setFilterIdMap(null);
        this.setValid(false);
    }

    protected void invalidateBackupMap() {
        DistributedCache service = this.getService();
        Map mapBackup = this.getBackupMap();
        if (mapBackup instanceof SafeHashMap ^ true) {
            try {
                switch (service.getBackupType()) {
                    case 3: {
                        break;
                    }
                    case 2: {
                        mapBackup.clear();
                        try {
                            ByteBufferManager bufferMgr = ((BinaryMap)mapBackup).getBufferManager();
                            ((MappedBufferManager)bufferMgr).close();
                        }
                        catch (ClassCastException e) {}
                        break;
                    }
                    case 1: {
                        mapBackup.clear();
                        break;
                    }
                    case 4: {
                        try {
                            DefaultConfigurableCacheFactory factory = (DefaultConfigurableCacheFactory)CacheFactory.getConfigurableCacheFactory();
                            factory.release(mapBackup, this.getConfiguredBackupListeners());
                        }
                        catch (ClassCastException e) {}
                        break;
                    }
                }
            }
            catch (Exception e) {
                Component._trace(String.valueOf("Failed to invalidate backup map: ") + e, 2);
            }
        }
        this.setBackupMap(Collections.EMPTY_MAP);
    }

    public DistributedCache$Storage$EntryStatus invoke(DistributedCache$Storage$BinaryEntry entry, InvocableMap.EntryProcessor agent) {
        boolean fEvicted;
        Binary binValueOld;
        Binary binValueNew;
        Binary binKey;
        DistributedCache$Storage$EntryStatus status;
        boolean fSynthetic;
        int nEvent;
        block17: {
            Map map = this.getResourceMap();
            Converter convDown = this.getConverterValueDown();
            nEvent = EVENT_NONE;
            fSynthetic = false;
            status = null;
            binKey = entry.getBinaryKey();
            binValueNew = null;
            binValueOld = null;
            fEvicted = false;
            this.registerIgnoreKey(binKey);
            try {
                entry.ensureDeferredRead();
                Object oResult = agent.process((InvocableMap.Entry)entry);
                status = new DistributedCache$Storage$EntryStatus();
                status.setResult((Binary)convDown.convert(oResult));
                if (!entry.isValueChanged()) break block17;
                binValueOld = entry.getBinaryValue();
                if (entry.isValueRemoved()) {
                    status.setValueRemoved(true);
                    map.keySet().remove(binKey);
                    nEvent = MapEvent.ENTRY_DELETED;
                    this.getStatsRemoves().increment();
                } else {
                    binValueNew = (Binary)convDown.convert(entry.getValue());
                    status.setValueUpdated(true);
                    status.setOldValue(binValueOld);
                    status.setNewValue(binValueNew);
                    if (this.isPreferPutAllPrimary()) {
                        map.putAll(Collections.singletonMap(binKey, binValueNew));
                    } else {
                        map.put(binKey, binValueNew);
                    }
                    if (binValueOld == null) {
                        nEvent = MapEvent.ENTRY_INSERTED;
                        this.getStatsInserts().increment();
                    } else {
                        nEvent = MapEvent.ENTRY_UPDATED;
                    }
                }
                fSynthetic = entry.isSynthetic();
            }
            catch (Throwable throwable) {
                Object var13_15 = null;
                Binary binUpdate = this.unregisterIgnoreKey(binKey, nEvent);
                if (!(!(binUpdate != BINARY_EXISTS) ? false : binUpdate != binValueNew) ? false : status != null) {
                    if (binUpdate == null) {
                        fEvicted = true;
                        status.setValueRemoved(true);
                    } else {
                        binValueNew = binUpdate;
                    }
                    status.setNewValue(binValueNew);
                }
                throw throwable;
            }
        }
        Object var13_14 = null;
        Binary binUpdate = this.unregisterIgnoreKey(binKey, nEvent);
        if (!(!(binUpdate != BINARY_EXISTS) ? false : binUpdate != binValueNew) ? false : status != null) {
            if (binUpdate == null) {
                fEvicted = true;
                status.setValueRemoved(true);
            } else {
                binValueNew = binUpdate;
            }
            status.setNewValue(binValueNew);
        }
        if (nEvent != EVENT_NONE) {
            this.dispatch(nEvent, binKey, binValueOld, binValueNew, fSynthetic);
            if (fEvicted) {
                nEvent = MapEvent.ENTRY_DELETED;
                entry.remove(true);
                this.dispatch(nEvent, binKey, binValueNew, null, true);
                status.setNewValue(null);
            }
            if (this.isIndexed()) {
                entry.ensureReadOnly();
                this.updateIndex(nEvent, entry);
            }
        }
        return status;
    }

    public boolean isIndexed() {
        Map mapIndex = this.getIndexMap();
        return !(mapIndex != null) ? false : mapIndex.isEmpty() ^ true;
    }

    public boolean isListenerHeavy() {
        return this.__m_ListenerHeavy;
    }

    public boolean isPreferPutAllBackup() {
        return this.__m_PreferPutAllBackup;
    }

    public boolean isPreferPutAllPrimary() {
        return this.__m_PreferPutAllPrimary;
    }

    public boolean isValid() {
        return this.__m_Valid;
    }

    public boolean lock(Lease lease) {
        Object binKey;
        Map mapLease = this.getLeaseMap();
        Lease leaseCurrent = (Lease)mapLease.get(binKey = lease.getResourceKey());
        if (leaseCurrent == null ? true : (!(leaseCurrent.getHolderId() == lease.getHolderId()) ? false : leaseCurrent.getHolderThreadId() == lease.getHolderThreadId())) {
            mapLease.put(binKey, lease);
            return true;
        }
        return false;
    }

    public void moveBucket(int iBucket, boolean fToBackup) {
        if (fToBackup ^ true) {
            this.moveResourcesToPrimary(iBucket);
        }
        Map mapFrom = fToBackup ? this.getLeaseMap() : this.getBackupLeaseMap();
        Map mapTo = fToBackup ? this.getBackupLeaseMap() : this.getLeaseMap();
        this.moveData(iBucket, mapFrom, mapTo, "locks");
        if (fToBackup) {
            this.firePendingLocks(iBucket);
        }
        if (!((mapFrom = fToBackup ? this.getKeyListenerMap() : this.getBackupKeyListenerMap()) != null) ? false : mapFrom.isEmpty() ^ true) {
            mapTo = fToBackup ? this.ensureBackupKeyListenerMap() : this.ensureKeyListenerMap();
            this.moveData(iBucket, mapFrom, mapTo, "listeners");
        }
        if (fToBackup) {
            this.moveResourcesToBackup(iBucket);
        }
    }

    protected void moveData(int iBucket, Map mapFrom, Map mapTo, String sDescr) {
        DistributedCache service = this.getService();
        while (true) {
            try {
                Iterator iter = mapFrom.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry entry = (Map.Entry)iter.next();
                    Binary binKey = (Binary)entry.getKey();
                    if (!(service.getKeyBucket(binKey) == iBucket)) continue;
                    mapTo.put(binKey, entry.getValue());
                    iter.remove();
                }
            }
            catch (ConcurrentModificationException e) {
                Component._trace(String.valueOf("Failed to move ") + sDescr + ": " + e + "; trying again", 2);
                continue;
            }
            break;
        }
    }

    protected void moveResourcesToBackup(int iBucket) {
        DistributedCache service = this.getService();
        Map mapFrom = this.getResourceMap();
        Map mapTo = this.getBackupMap();
        boolean fPutAll = this.isPreferPutAllBackup();
        while (true) {
            DistributedCache$Storage$BinaryEntry entryTemp = null;
            if (this.isIndexed()) {
                entryTemp = this.instantiateBinaryEntry(null, null, true);
            }
            int nEvent = MapEvent.ENTRY_DELETED;
            try {
                Iterator iter = mapFrom.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry entry = (Map.Entry)iter.next();
                    Binary binKey = (Binary)entry.getKey();
                    if (!(service.getKeyBucket(binKey) == iBucket)) continue;
                    Binary binValue = (Binary)entry.getValue();
                    if (fPutAll) {
                        mapTo.putAll(Collections.singletonMap(binKey, binValue));
                    } else {
                        mapTo.put(binKey, binValue);
                    }
                    this.registerIgnoreKey(binKey);
                    try {
                        iter.remove();
                        this.getStatsInserts().decrement();
                    }
                    finally {
                        Object var13_13 = null;
                        this.unregisterIgnoreKey(binKey, nEvent);
                    }
                    if (!(entryTemp != null)) continue;
                    entryTemp.setBinaryKey(binKey);
                    this.updateIndex(nEvent, entryTemp);
                }
            }
            catch (ConcurrentModificationException e) {
                Component._trace(String.valueOf("Failed to move from primary to backup: ") + e + "; trying again", 2);
                continue;
            }
            break;
        }
    }

    protected void moveResourcesToPrimary(int iBucket) {
        DistributedCache service = this.getService();
        Map mapFrom = this.getBackupMap();
        while (true) {
            DistributedCache$Storage$BinaryEntry entryTemp = null;
            if (this.isIndexed()) {
                entryTemp = this.instantiateBinaryEntry(null, null, true);
            }
            int nEvent = MapEvent.ENTRY_INSERTED;
            try {
                Iterator iter = mapFrom.entrySet().iterator();
                while (iter.hasNext()) {
                    Binary binUpdate;
                    Object var11_11;
                    Map.Entry entry = (Map.Entry)iter.next();
                    Binary binKey = (Binary)entry.getKey();
                    if (!(service.getKeyBucket(binKey) == iBucket)) continue;
                    Binary binValue = (Binary)entry.getValue();
                    this.registerIgnoreKey(binKey);
                    try {
                        this.insertPrimaryResource(binKey, binValue);
                    }
                    catch (Throwable throwable) {
                        var11_11 = null;
                        binUpdate = this.unregisterIgnoreKey(binKey, nEvent);
                        if (binUpdate != BINARY_EXISTS) {
                            binValue = binUpdate;
                        }
                        throw throwable;
                    }
                    var11_11 = null;
                    binUpdate = this.unregisterIgnoreKey(binKey, nEvent);
                    if (binUpdate != BINARY_EXISTS) {
                        binValue = binUpdate;
                    }
                    iter.remove();
                    if (!(!(entryTemp != null) ? false : binValue != null)) continue;
                    entryTemp.setBinaryKey(binKey);
                    entryTemp.setBinaryValue(binValue);
                    this.updateIndex(nEvent, entryTemp);
                }
            }
            catch (ConcurrentModificationException e) {
                Component._trace(String.valueOf("Failed to move from backup to primary: ") + e + "; trying again", 2);
                continue;
            }
            break;
        }
    }

    public void onBackingMapEvent(MapEvent evt) {
        block19: {
            Binary binKey;
            block18: {
                binKey = (Binary)evt.getKey();
                Binary binValueNew = (Binary)evt.getNewValue();
                Map mapIgnore = this.getIgnoreMap();
                if (mapIgnore.containsKey(binKey)) {
                    Object oHolder = mapIgnore.get(binKey);
                    if (oHolder == BINARY_EXISTS) {
                        mapIgnore.put(binKey, evt);
                    } else {
                        ArrayList<Object> listEvents;
                        if (oHolder instanceof MapEvent) {
                            listEvents = new ArrayList<Object>(2);
                            listEvents.add(oHolder);
                            mapIgnore.put(binKey, listEvents);
                        } else {
                            listEvents = (ArrayList<Object>)oHolder;
                            if (evt.getId() == MapEvent.ENTRY_INSERTED) {
                                Component._trace(String.valueOf("Detected a re-insert of an entry after a remove operation: ") + evt + '\n' + Component.get_StackTrace() + "\nthis may result in an inconstent backing map content state", 1);
                            }
                        }
                        listEvents.add(evt);
                    }
                    return;
                }
                DistributedCache service = this.getService();
                int iBucket = service.getKeyBucket(binKey);
                int nEvent = evt.getId();
                Binary binValueOld = (Binary)evt.getOldValue();
                boolean fOwned = service.isPrimaryOwner(iBucket) ? true : service.getPrimaryTransfer() == iBucket;
                boolean fIndex = this.isIndexed();
                boolean fDispatch = fOwned;
                boolean fBackup = !fDispatch ? false : service.getBackupCount() > 0;
                Binary binValueUpd = binValueNew;
                switch (nEvent) {
                    case 1: {
                        this.getStatsInserts().increment();
                        break;
                    }
                    case 2: {
                        Binary binDataOld;
                        Binary binDataNew;
                        boolean fDecorNew = !(binValueNew != null) ? false : ExternalizableHelper.isDecorated((Binary)binValueNew);
                        boolean fDecorOld = !(binValueOld != null) ? false : ExternalizableHelper.isDecorated((Binary)binValueOld);
                        if (!(fDecorNew ? true : fDecorOld) || !(binDataNew = ExternalizableHelper.getDecoration((Binary)binValueNew, (int)ExternalizableHelper.DECO_VALUE)).equals((Object)(binDataOld = ExternalizableHelper.getDecoration((Binary)binValueOld, (int)ExternalizableHelper.DECO_VALUE)))) break;
                        fIndex = false;
                        fDispatch = false;
                        fOwned = true;
                        if (!fBackup) break;
                        if (fDecorNew) {
                            Binary[] abinDecor = ExternalizableHelper.getDecorations((Binary)binValueNew);
                            binValueUpd = ExternalizableHelper.decorate((Binary)BINARY_EXISTS, (Binary[])abinDecor);
                            break;
                        }
                        binValueUpd = BINARY_EXISTS;
                        break;
                    }
                    case 3: {
                        fOwned = true;
                        this.getStatsEvictions().increment();
                        break;
                    }
                }
                if (!fOwned) break block18;
                if (fIndex) {
                    this.updateIndex(nEvent, this.instantiateBinaryEntry(binKey, binValueNew, true));
                }
                if (fDispatch) {
                    this.dispatch(nEvent, binKey, binValueOld, binValueNew, true);
                }
                if (!fBackup) break block19;
                if (nEvent == MapEvent.ENTRY_DELETED) {
                    service.sendBackupRemoveRequest(this.getCacheId(), binKey, null);
                } else {
                    service.sendBackupUpdateRequest(this.getCacheId(), binKey, binValueUpd, null);
                }
                break block19;
            }
            Component._trace(String.valueOf("An entry was inserted into the backing map for the partitioned cache \"") + this.getCacheName() + "\" that is not owned by this member; the entry will be removed.\n" + Component.get_StackTrace(), 1);
            try {
                evt.getMap().keySet().remove(binKey);
            }
            catch (Exception e) {}
        }
    }

    public void onInit() {
        DistributedCache service = this.getService();
        if (service.getDaemonPool().isStarted()) {
            this.setThreadLocal(new ThreadLocal());
            this.setResourceControlMap((ConcurrentMap)new WrapperConcurrentMap((Map)NullImplementation.getObservableMap(), false, -1L));
        } else {
            this.setIgnoreMap((Map)new SafeHashMap(3, 1.0f, 2.0f));
        }
        if (service.getBackupCount() > 0) {
            this.setBackupMap((Map)new SafeHashMap());
            this.setBackupLeaseMap((Map)new SafeHashMap());
        }
        this.setConverterUp(service.getBackingMapContext().getValueFromInternalConverter());
        this.setConverterValueDown(service.getBackingMapContext().getValueToInternalConverter());
        this.setStatsInserts(AtomicCounter.newAtomicCounter());
        this.setStatsRemoves(AtomicCounter.newAtomicCounter());
        this.setStatsEvictions(AtomicCounter.newAtomicCounter());
        super.onInit();
    }

    public DistributedCache$Storage$EntryStatus put(Binary binKey, Binary binValue, long cMillis, boolean fBlind) {
        boolean fEvicted;
        Binary binValueOld;
        int nEvent;
        block24: {
            Map map = this.getResourceMap();
            nEvent = EVENT_NONE;
            binValueOld = null;
            fEvicted = false;
            this.registerIgnoreKey(binKey);
            try {
                boolean fPutAll;
                boolean fExpiry = false;
                if (map instanceof CacheMap) {
                    fExpiry = cMillis != CacheMap.EXPIRY_DEFAULT;
                } else if (cMillis > 0L) {
                    throw new UnsupportedOperationException(String.valueOf("Class \"") + map.getClass().getName() + "\" does not implement CacheMap interface");
                }
                if (fExpiry) {
                    BinaryWriteBuffer buf = new BinaryWriteBuffer(8, 8);
                    try {
                        WriteBuffer.BufferOutput out = buf.getBufferOutput();
                        out.writeLong(cMillis < 0L ? CacheMap.EXPIRY_NEVER : this.getService().getClusterTime() + cMillis);
                    }
                    catch (IOException e) {
                        throw new WrapperException((Throwable)e);
                    }
                    binValue = ExternalizableHelper.decorate((Binary)binValue, (int)ExternalizableHelper.DECO_EXPIRY, (Binary)buf.toBinary());
                    binValueOld = (Binary)((CacheMap)map).put((Object)binKey, (Object)binValue, cMillis);
                    nEvent = binValueOld == null ? MapEvent.ENTRY_INSERTED : MapEvent.ENTRY_UPDATED;
                    break block24;
                }
                boolean bl = fPutAll = !fBlind ? false : this.isPreferPutAllPrimary();
                if (fPutAll) {
                    switch (this.getListenerType(binKey)) {
                        case 0: 
                        case 1: {
                            nEvent = map.containsKey(binKey) ? MapEvent.ENTRY_UPDATED : MapEvent.ENTRY_INSERTED;
                            break;
                        }
                        case 2: 
                        case 3: {
                            fPutAll = false;
                            break;
                        }
                        default: {
                            throw new IllegalStateException();
                        }
                    }
                }
                if (fPutAll) {
                    map.putAll(Collections.singletonMap(binKey, binValue));
                    break block24;
                }
                binValueOld = map.put(binKey, binValue);
                nEvent = binValueOld == null ? MapEvent.ENTRY_INSERTED : MapEvent.ENTRY_UPDATED;
            }
            catch (Throwable fExpiry) {
                Object var11_15 = null;
                Binary binUpdate = this.unregisterIgnoreKey(binKey, nEvent);
                if (!(binUpdate != BINARY_EXISTS) ? false : binUpdate != binValue) {
                    if (binUpdate == null) {
                        fEvicted = true;
                    } else {
                        binValue = binUpdate;
                    }
                }
                throw fExpiry;
            }
        }
        Object var11_14 = null;
        Binary binUpdate = this.unregisterIgnoreKey(binKey, nEvent);
        if (!(binUpdate != BINARY_EXISTS) ? false : binUpdate != binValue) {
            if (binUpdate == null) {
                fEvicted = true;
            } else {
                binValue = binUpdate;
            }
        }
        DistributedCache$Storage$EntryStatus status = new DistributedCache$Storage$EntryStatus();
        status.setNewValue(fEvicted ? null : binValue);
        if (nEvent == MapEvent.ENTRY_INSERTED) {
            this.getStatsInserts().increment();
        } else {
            status.setOldValue(binValueOld == null ? BINARY_EXISTS : binValueOld);
        }
        this.dispatch(nEvent, binKey, binValueOld, binValue, false);
        if (fEvicted) {
            this.dispatch(MapEvent.ENTRY_DELETED, binKey, binValue, null, true);
        }
        if (this.isIndexed()) {
            this.updateIndex(nEvent, this.instantiateBinaryEntry(binKey, binValue, true));
        }
        return status;
    }

    public Object[] query(Filter filter, int nQueryType, PartitionSet partMask) {
        Object[] aoResult;
        Filter filterOrig;
        Map mapPrime;
        DistributedCache service;
        block29: {
            service = this.getService();
            mapPrime = this.getResourceMap();
            filterOrig = filter;
            aoResult = null;
            if (filter instanceof IndexAwareFilter) {
                IndexAwareFilter filterIx = (IndexAwareFilter)filter;
                int cAttempts = 4;
                while (true) {
                    Object setKeys = new SubSet(mapPrime.keySet());
                    try {
                        filter = filterIx.applyIndex(this.ensureIndexMap(), (Set)setKeys);
                        aoResult = setKeys.toArray();
                        break block29;
                    }
                    catch (ConcurrentModificationException e) {
                        setKeys = mapPrime.keySet();
                        setKeys.containsAll((Collection<?>)setKeys);
                        if (--cAttempts > 0) continue;
                        throw e;
                    }
                    catch (Throwable e) {
                        Component._trace(String.valueOf("Exception occured during query processing: ") + Component.getStackTrace(e), 1);
                        DistributedCache$Storage.rethrow(e);
                        continue;
                    }
                    break;
                }
            }
            aoResult = mapPrime.keySet().toArray();
        }
        int cResults = 0;
        if (filter == null) {
            if (nQueryType == QUERY_KEYS) {
                int i = 0;
                int c = aoResult.length;
                while (i < c) {
                    Binary binKey = (Binary)aoResult[i];
                    if (partMask.contains(service.getKeyBucket(binKey))) {
                        if (cResults < i) {
                            aoResult[cResults] = binKey;
                        }
                        ++cResults;
                    }
                    ++i;
                }
            } else {
                boolean fInit = nQueryType != QUERY_INVOKE;
                boolean fReadOnly = nQueryType != QUERY_INVOKE;
                int i = 0;
                int c = aoResult.length;
                while (i < c) {
                    Binary binKey = (Binary)aoResult[i];
                    if (partMask.contains(service.getKeyBucket(binKey))) {
                        Binary binValue = null;
                        if (!fInit || !((binValue = (Binary)mapPrime.get(binKey)) == null)) {
                            DistributedCache$Storage$BinaryEntry entry = this.instantiateBinaryEntry(binKey, binValue, fReadOnly);
                            entry.disableKeyConversion();
                            aoResult[cResults++] = entry;
                        }
                    }
                    ++i;
                }
            }
        } else {
            int c;
            int cLimit = 0;
            int cHits = 0;
            if (filterOrig instanceof LimitFilter) {
                LimitFilter filterLimit = (LimitFilter)filterOrig;
                if (nQueryType == QUERY_KEYS ? true : filterLimit.getComparator() == null) {
                    Object oAnchorTop = filterLimit.getTopAnchor();
                    int cPageSize = filterLimit.getPageSize();
                    int cSkip = oAnchorTop instanceof Integer ? (Integer)oAnchorTop : filterLimit.getPage() * cPageSize;
                    cLimit = cSkip + cPageSize;
                }
            }
            if (nQueryType == QUERY_KEYS) {
                DistributedCache$Storage$BinaryEntry entryTest = this.instantiateBinaryEntry(null, null, true);
                entryTest.disableKeyConversion();
                int i = 0;
                c = aoResult.length;
                while (i < c) {
                    Binary binValue;
                    Binary binKey = (Binary)aoResult[i];
                    if (partMask.contains(service.getKeyBucket(binKey)) && (binValue = (Binary)mapPrime.get(binKey)) != null) {
                        entryTest.setBinaryKey(binKey);
                        entryTest.setBinaryValue(binValue);
                        if (InvocableMapHelper.evaluateEntry((Filter)filter, (Map.Entry)entryTest)) {
                            aoResult[cResults++] = binKey;
                            if (!(cLimit > 0) ? false : ++cHits >= cLimit) break;
                        }
                    }
                    ++i;
                }
            } else {
                boolean fReadOnly = nQueryType != QUERY_INVOKE;
                int i = 0;
                c = aoResult.length;
                while (i < c) {
                    Binary binValue;
                    Binary binKey = (Binary)aoResult[i];
                    if (partMask.contains(service.getKeyBucket(binKey)) && (binValue = (Binary)mapPrime.get(binKey)) != null) {
                        DistributedCache$Storage$BinaryEntry entry = this.instantiateBinaryEntry(binKey, binValue, fReadOnly);
                        entry.disableKeyConversion();
                        if (InvocableMapHelper.evaluateEntry((Filter)filter, (Map.Entry)entry)) {
                            aoResult[cResults++] = entry;
                            if (!(cLimit > 0) ? false : ++cHits >= cLimit) break;
                        }
                    }
                    ++i;
                }
            }
        }
        if (cResults < aoResult.length) {
            Object[] ao = new Object[cResults];
            System.arraycopy(aoResult, 0, ao, 0, cResults);
            aoResult = ao;
        }
        if (filterOrig instanceof LimitFilter) {
            LimitFilter filterLimit = (LimitFilter)filterOrig;
            int cAvailable = aoResult.length;
            filterLimit.setCookie((Object)Base.makeInteger((int)cAvailable));
            aoResult = (nQueryType == QUERY_KEYS ? true : filterLimit.getComparator() == null) ? filterLimit.extractPage(aoResult) : this.extractBinaryEntries(aoResult, filterLimit);
        }
        return aoResult;
    }

    protected void registerIgnoreKey(Binary binKey) {
        this.getIgnoreMap().put(binKey, BINARY_EXISTS);
    }

    public void releaseBucket(int iBucket, boolean fPrimary) {
        Map map = fPrimary ? this.getKeyListenerMap() : this.getBackupKeyListenerMap();
        if (!(map != null) ? false : map.isEmpty() ^ true) {
            this.releaseData(iBucket, map, "listeners");
        }
        map = fPrimary ? this.getLeaseMap() : this.getBackupLeaseMap();
        this.releaseData(iBucket, map, "locks");
        if (fPrimary) {
            this.firePendingLocks(iBucket);
        }
        this.releaseResources(iBucket, fPrimary);
    }

    protected void releaseData(int iBucket, Map map, String sDescr) {
        DistributedCache service = this.getService();
        while (true) {
            try {
                Iterator iter = map.keySet().iterator();
                while (iter.hasNext()) {
                    Binary binKey = (Binary)iter.next();
                    if (!(service.getKeyBucket(binKey) == iBucket)) continue;
                    iter.remove();
                }
            }
            catch (ConcurrentModificationException e) {
                Component._trace(String.valueOf("Failed to release ") + sDescr + ": " + e + "; trying again", 2);
                continue;
            }
            break;
        }
    }

    protected void releaseResources(int iBucket, boolean fPrimary) {
        DistributedCache service = this.getService();
        while (true) {
            DistributedCache$Storage$BinaryEntry entryTemp = null;
            if (this.isIndexed()) {
                entryTemp = this.instantiateBinaryEntry(null, null, true);
            }
            int nEvent = MapEvent.ENTRY_DELETED;
            Map map = fPrimary ? this.getResourceMap() : this.getBackupMap();
            try {
                Iterator iter = map.keySet().iterator();
                while (iter.hasNext()) {
                    Binary binKey = (Binary)iter.next();
                    if (!(service.getKeyBucket(binKey) == iBucket)) continue;
                    if (fPrimary) {
                        this.registerIgnoreKey(binKey);
                        try {
                            iter.remove();
                            this.getStatsInserts().decrement();
                        }
                        finally {
                            Object var10_10 = null;
                            this.unregisterIgnoreKey(binKey, nEvent);
                        }
                        if (!(entryTemp != null)) continue;
                        entryTemp.setBinaryKey(binKey);
                        this.updateIndex(nEvent, entryTemp);
                        continue;
                    }
                    iter.remove();
                }
            }
            catch (ConcurrentModificationException e) {
                Component._trace(String.valueOf("Failed to release resources: ") + e + "; trying again", 2);
                continue;
            }
            break;
        }
    }

    public Binary remove(Binary binKey, boolean fBlind) {
        Binary binValueOld;
        Binary binValueReturn;
        Map map = this.getResourceMap();
        int nEvent = EVENT_NONE;
        this.registerIgnoreKey(binKey);
        try {
            boolean fIgnoreOldValue = fBlind;
            if (fBlind) {
                switch (this.getListenerType(binKey)) {
                    case 0: 
                    case 1: {
                        break;
                    }
                    case 2: 
                    case 3: {
                        fIgnoreOldValue = false;
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
            if (fIgnoreOldValue) {
                binValueReturn = map.keySet().remove(binKey) ? BINARY_EXISTS : null;
                binValueOld = null;
            } else {
                binValueReturn = binValueOld = (Binary)map.remove(binKey);
            }
            nEvent = binValueReturn == null ? EVENT_NONE : MapEvent.ENTRY_DELETED;
        }
        finally {
            Object var8_9 = null;
            this.unregisterIgnoreKey(binKey, nEvent);
        }
        if (nEvent != EVENT_NONE) {
            this.getStatsRemoves().increment();
            if (this.isIndexed()) {
                this.updateIndex(nEvent, this.instantiateBinaryEntry(binKey, null, true));
            }
            this.dispatch(nEvent, binKey, binValueOld, null, false);
        }
        return binValueReturn;
    }

    public void removeIndex(ValueExtractor extractor) {
        Map mapIndex = this.getIndexMap();
        if (mapIndex != null) {
            mapIndex.remove(extractor);
        }
    }

    public void removeKeyListener(Member member, Binary binKey, boolean fPrimary) {
        this.removeProxyMember(fPrimary ? this.getKeyListenerMap() : this.getBackupKeyListenerMap(), binKey, member);
    }

    public void removeListener(Member member, Filter filter, long lFilterId) {
        Set setFilterId;
        Map mapMemberFilterId;
        Map mapListeners = this.getListenerMap();
        this.removeProxyMember(mapListeners, filter, member);
        Map mapFilterId = this.getFilterIdMap();
        if (mapFilterId != null && (mapMemberFilterId = (Map)mapFilterId.get(member)) != null && (setFilterId = (Set)mapMemberFilterId.get(filter)) != null) {
            setFilterId.remove(new Long(lFilterId));
            if (setFilterId.isEmpty()) {
                mapMemberFilterId.remove(filter);
                if (mapMemberFilterId.isEmpty()) {
                    mapFilterId.remove(member);
                }
            }
        }
        if (!(mapListeners != null) ? false : this.isListenerHeavy()) {
            boolean fHeavy = false;
            Iterator iterFilter = mapListeners.values().iterator();
            block0: while (iterFilter.hasNext()) {
                Map mapMembers = (Map)iterFilter.next();
                Iterator iter = mapMembers.values().iterator();
                while (iter.hasNext()) {
                    Boolean FLite = (Boolean)iter.next();
                    if (!(FLite ^ true)) continue;
                    fHeavy = true;
                    continue block0;
                }
            }
            this.setListenerHeavy(fHeavy);
        }
    }

    protected void removeProxyMember(Map map, Object anyKey, Member member) {
        Map mapMembers;
        if (map != null && (mapMembers = (Map)map.get(anyKey)) != null) {
            mapMembers.remove(member);
            if (mapMembers.isEmpty()) {
                map.remove(anyKey);
            }
        }
    }

    public String reportIndexes() {
        Map mapIndex = this.getIndexMap();
        return (mapIndex == null ? true : mapIndex.isEmpty()) ? "No indexes" : Base.toDelimitedString(mapIndex.values().iterator(), (String)"\n");
    }

    public String reportKeys(Set setKeys) {
        Converter conv = this.getService().getBackingMapContext().getKeyFromInternalConverter();
        return String.valueOf(ConverterCollections.getSet((Set)setKeys, (Converter)conv, (Converter)NullImplementation.getConverter()));
    }

    public void resetStats() {
        this.setStatsEventsDispatched(0L);
        this.setStatsListenerRegistrations(0L);
    }

    protected static void rethrow(Throwable e) {
        if (e instanceof Error) {
            throw (Error)e;
        }
        throw (RuntimeException)e;
    }

    protected void setBackupKeyListenerMap(Map map) {
        this.__m_BackupKeyListenerMap = map;
    }

    protected void setBackupLeaseMap(Map map) {
        this.__m_BackupLeaseMap = map;
    }

    protected void setBackupMap(Map map) {
        this.__m_BackupMap = map;
    }

    public void setCacheId(long lCacheId) {
        this.__m_CacheId = lCacheId;
    }

    public void setCacheName(String sName) {
        Component._assert(sName != null);
        if (this.is_Constructed()) {
            Registry registry;
            DistributedCache service = this.getService();
            Component._assert(Thread.currentThread() == service.getThread());
            String sNameOld = this.getCacheName();
            if (sNameOld != null) {
                if (sNameOld.equals(sName)) {
                    return;
                }
                throw new IllegalStateException(String.valueOf("Attempt to modify the CacheName: ") + this + " to " + sName);
            }
            this.__m_CacheName = sName;
            this.instantiateResourceMap();
            if (service.getBackupCount() > 0) {
                this.instantiateBackupMap();
            }
            if ((registry = service.getCluster().getManagement()) != null) {
                String sBean = Registry.STORAGE_MANAGER_TYPE + ",service=" + service.getServiceName() + ",cache=" + sName;
                registry.register(registry.ensureGlobalName(sBean), (Object)this);
            }
        }
    }

    protected void setConfiguredBackupListeners(Map map) {
        this.__m_ConfiguredBackupListeners = map;
    }

    protected void setConverterUp(Converter converter) {
        this.__m_ConverterUp = converter;
    }

    protected void setConverterValueDown(Converter converter) {
        this.__m_ConverterValueDown = converter;
    }

    protected void setFilterIdMap(Map map) {
        this.__m_FilterIdMap = map;
    }

    protected void setIgnoreMap(Map map) {
        this.__m_IgnoreMap = map;
    }

    protected void setIndexMap(Map pIndexMap) {
        this.__m_IndexMap = pIndexMap;
    }

    protected void setKeyListenerMap(Map map) {
        this.__m_KeyListenerMap = map;
    }

    protected void setLeaseMap(Map map) {
        this.__m_LeaseMap = map;
    }

    protected void setListenerHeavy(boolean fHeavy) {
        this.__m_ListenerHeavy = fHeavy;
    }

    protected void setListenerMap(Map map) {
        this.__m_ListenerMap = map;
    }

    protected void setPendingLockRequest(List list) {
        this.__m_PendingLockRequest = list;
    }

    protected void setPreferPutAllBackup(boolean fPrefer) {
        this.__m_PreferPutAllBackup = fPrefer;
    }

    protected void setPreferPutAllPrimary(boolean fPrefer) {
        this.__m_PreferPutAllPrimary = fPrefer;
    }

    protected void setPrimaryListener(MapListener listener) {
        this.__m_PrimaryListener = listener;
    }

    protected void setResourceControlMap(ConcurrentMap map) {
        this.__m_ResourceControlMap = map;
    }

    protected void setResourceMap(Map map) {
        this.__m_ResourceMap = map;
    }

    protected void setStatsEventsDispatched(long cEvents) {
        this.__m_StatsEventsDispatched = cEvents;
    }

    protected void setStatsEvictions(AtomicCounter counter) {
        this.__m_StatsEvictions = counter;
    }

    protected void setStatsInserts(AtomicCounter counter) {
        this.__m_StatsInserts = counter;
    }

    protected void setStatsListenerRegistrations(long cRequests) {
        this.__m_StatsListenerRegistrations = cRequests;
    }

    protected void setStatsRemoves(AtomicCounter counter) {
        this.__m_StatsRemoves = counter;
    }

    private void setThreadLocal(ThreadLocal tlo) {
        this.__m_ThreadLocal = tlo;
    }

    protected void setValid(boolean fValid) {
        this.__m_Valid = fValid;
    }

    public String toString() {
        return String.valueOf(this.get_Name()) + " (CacheName=" + this.getCacheName() + ", CacheId=" + this.getCacheId() + ')';
    }

    public boolean unlock(Lease lease) {
        List listPending;
        Object binKey;
        Map mapLease = this.getLeaseMap();
        Lease leaseCurrent = (Lease)mapLease.get(binKey = lease.getResourceKey());
        if (leaseCurrent == null ? true : (!(leaseCurrent.getHolderId() == lease.getHolderId()) ? false : leaseCurrent.getHolderThreadId() == lease.getHolderThreadId())) {
            mapLease.remove(binKey);
            return true;
        }
        List list = listPending = this.getPendingLockRequest();
        synchronized (list) {
            DistributedCache service = this.getService();
            Iterator iter = listPending.iterator();
            while (iter.hasNext()) {
                DistributedCache$LockRequest msgRequest = (DistributedCache$LockRequest)iter.next();
                if (!(!(!msgRequest.getKey().equals(binKey) ? false : msgRequest.getLeaseHolderId() == lease.getHolderId()) ? false : msgRequest.getLeaseThreadId() == lease.getHolderThreadId())) continue;
                iter.remove();
                DistributedCache$Response msgResponse = (DistributedCache$Response)service.instantiateMessage("Response");
                msgResponse.respondTo(msgRequest);
                msgResponse.setResult(DistributedCacheResponse.RESULT_RETRY);
                service.post(msgResponse);
            }
        }
        return false;
    }

    protected Binary unregisterIgnoreKey(Binary binKey, int nEvent) {
        Object oHolder = this.getIgnoreMap().remove(binKey);
        if (oHolder == BINARY_EXISTS ? true : nEvent == EVENT_NONE) {
            return BINARY_EXISTS;
        }
        if (oHolder instanceof MapEvent) {
            MapEvent evt = (MapEvent)oHolder;
            if (!(nEvent != 0) ? false : nEvent != evt.getId()) {
                Component._trace(String.valueOf("Unexpected event during backing map operation: expected=") + MapEvent.getDescription((int)nEvent) + "; actual=" + evt, 2);
            }
            return (Binary)evt.getNewValue();
        }
        List listEvents = (List)oHolder;
        int cEvents = listEvents.size();
        Component._assert(cEvents > 1);
        Binary binValueNew = null;
        int i = 0;
        while (i < cEvents) {
            MapEvent evt = (MapEvent)listEvents.get(i);
            if (evt.getId() == MapEvent.ENTRY_DELETED) {
                this.getStatsEvictions().increment();
            }
            binValueNew = (Binary)evt.getNewValue();
            ++i;
        }
        return binValueNew;
    }

    protected void updateIndex(int nEventType, DistributedCache$Storage$BinaryEntry entry) {
        Map mapIndex = this.getIndexMap();
        if (!(mapIndex != null) ? false : mapIndex.isEmpty() ^ true) {
            Iterator iter = mapIndex.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entryIndex = (Map.Entry)iter.next();
                try {
                    DistributedCache$Storage$MapIndex index = (DistributedCache$Storage$MapIndex)entryIndex.getValue();
                    switch (nEventType) {
                        case 1: {
                            index.insert(entry);
                            break;
                        }
                        case 2: {
                            index.update(entry);
                            break;
                        }
                        case 3: {
                            index.remove(entry);
                            break;
                        }
                    }
                }
                catch (RuntimeException e) {
                    Component._trace(String.valueOf("Exception occured during index update: ") + entry.getKey() + "; removing the index...", 1);
                    Component._trace(e);
                    iter.remove();
                }
            }
        }
    }

    public void validateListeners() {
        DistributedCache service = this.getService();
        ServiceMemberSet setMembers = service.getServiceMemberSet();
        Map[] aMap = new Map[]{this.getListenerMap(), this.getKeyListenerMap(), this.getBackupKeyListenerMap()};
        int i = 0;
        int c = aMap.length;
        while (i < c) {
            Map map = aMap[i];
            while (map != null) {
                try {
                    Iterator iter = map.values().iterator();
                    while (iter.hasNext()) {
                        Map mapMembers = (Map)iter.next();
                        mapMembers.keySet().retainAll(setMembers);
                        if (!mapMembers.isEmpty()) continue;
                        iter.remove();
                    }
                    break;
                }
                catch (ConcurrentModificationException e) {
                    // empty catch block
                }
            }
            ++i;
        }
        Map mapFilterId = this.getFilterIdMap();
        if (mapFilterId != null) {
            mapFilterId.keySet().retainAll(setMembers);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void validateLocks() {
        service = this.getService();
        setMembers = service.getServiceMemberSet();
        setKeys = new LiteSet();
        while (true) {
            try {
                iter = this.getLeaseMap().values().iterator();
                while (iter.hasNext()) {
                    lease = (Lease)iter.next();
                    if (!(setMembers.contains(lease.getHolderId()) ^ true)) continue;
                    setKeys.add(lease.getResourceKey());
                    iter.remove();
                }
                if (true) ** GOTO lbl28
            }
            catch (ConcurrentModificationException e) {
                continue;
            }
            break;
        }
        do {
            try {
                iter = this.getBackupLeaseMap().values().iterator();
                while (iter.hasNext()) {
                    lease = (Lease)iter.next();
                    if (!(setMembers.contains(lease.getHolderId()) ^ true)) continue;
                    iter.remove();
                }
                break;
            }
            catch (ConcurrentModificationException e) {
                // empty catch block
            }
lbl28:
            // 2 sources

        } while (service.getBackupCount() > 0);
        listPending = this.getPendingLockRequest();
        lease = listPending;
        synchronized (lease) {
            if (listPending.isEmpty() ^ true) {
                iter = listPending.iterator();
                while (iter.hasNext()) {
                    msgLock = (DistributedCache$LockRequest)iter.next();
                    if (!(setMembers.contains(msgLock.getFromMember()) ^ true)) continue;
                    iter.remove();
                }
            }
        }
        iter = setKeys.iterator();
        while (iter.hasNext()) {
            this.firePendingLocks((Binary)iter.next());
        }
    }
}

