/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.daemon.queueProcessor.service;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.Util;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.DistributedCache;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.DistributedCache$BinaryMap;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.DistributedCache$Storage;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.DistributedCache$ViewMap$ProxyListener;
import com.tangosol.license.LicenseException;
import com.tangosol.net.CacheService;
import com.tangosol.net.NamedCache;
import com.tangosol.net.RequestTimeoutException;
import com.tangosol.util.Base;
import com.tangosol.util.Binary;
import com.tangosol.util.ConcurrentMap;
import com.tangosol.util.Converter;
import com.tangosol.util.ConverterCollections;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.Filter;
import com.tangosol.util.ImmutableArrayList;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.InvocableMapHelper;
import com.tangosol.util.ListMap;
import com.tangosol.util.MapListener;
import com.tangosol.util.MapListenerSupport;
import com.tangosol.util.NullImplementation;
import com.tangosol.util.ObservableMap;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.WrapperException;
import com.tangosol.util.comparator.EntryComparator;
import com.tangosol.util.comparator.SafeComparator;
import com.tangosol.util.filter.InKeySetFilter;
import com.tangosol.util.filter.KeyAssociatedFilter;
import com.tangosol.util.filter.LimitFilter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DistributedCache$ViewMap
extends Util
implements NamedCache {
    private boolean __m_Active;
    private NamedCache __m_BinaryMap;
    private String __m_CacheName;
    private ClassLoader __m_ClassLoader;
    private transient ConverterCollections.ConverterObservableMap __m_ConverterMap;
    private transient Converter __m_FromBinaryConverter;
    private transient Converter __m_KeyToBinaryConverter;
    private transient Converter __m_ValueToBinaryConverter;
    private static ListMap __mapChildren;
    private static transient long __s_LicenseMsgTimestamp;

    static {
        DistributedCache$ViewMap.__initStatic();
    }

    public DistributedCache$ViewMap() {
        this(null, null, true);
    }

    public DistributedCache$ViewMap(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setActive(true);
        }
        catch (Exception e) {
            throw new WrapperException((Throwable)e);
        }
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    private static void __initStatic() {
        __mapChildren = new ListMap();
        Object object = __mapChildren.put((Object)"ProxyListener", (Object)DistributedCache$ViewMap$ProxyListener.get_CLASS());
    }

    public void addIndex(ValueExtractor extractor, boolean fOrdered, Comparator comparator) {
        this.ensureBinaryMap().addIndex(extractor, fOrdered, comparator);
    }

    public void addMapListener(MapListener listener) {
        this.addMapListener(listener, null, false);
    }

    public void addMapListener(MapListener listener, Filter filter, boolean fLite) {
        this.ensureBinaryMap().addMapListener(this.instantiateProxyListener(listener), filter, fLite);
    }

    public void addMapListener(MapListener listener, Object oKey, boolean fLite) {
        this.ensureBinaryMap().addMapListener(this.instantiateProxyListener(listener), this.getKeyToBinaryConverter().convert(oKey), fLite);
    }

    public Object aggregate(Filter filter, InvocableMap.EntryAggregator agent) {
        if (agent == null) {
            throw new IllegalArgumentException("Processor must be specified");
        }
        Converter convKeyDown = this.getKeyToBinaryConverter();
        Converter convUp = this.getFromBinaryConverter();
        Converter convNotUsed = NullImplementation.getConverter();
        Binary binHostKey = null;
        if (filter instanceof KeyAssociatedFilter) {
            KeyAssociatedFilter filterAssoc = (KeyAssociatedFilter)filter;
            binHostKey = (Binary)convKeyDown.convert(filterAssoc.getHostKey());
            filter = filterAssoc.getFilter();
        }
        if (filter instanceof LimitFilter) {
            throw new UnsupportedOperationException("LimitFilter cannot be used with aggregate");
        }
        this.prepareParallelQuery(filter);
        if (agent instanceof InvocableMap.ParallelAwareAggregator) {
            InvocableMap.ParallelAwareAggregator aggregator = (InvocableMap.ParallelAwareAggregator)agent;
            try {
                DistributedCache$BinaryMap mapBinary = (DistributedCache$BinaryMap)this.ensureBinaryMap();
                List listBinParts = binHostKey == null ? (List)mapBinary.aggregate(filter, aggregator.getParallelAggregator()) : (List)mapBinary.aggregate(filter, aggregator.getParallelAggregator(), binHostKey);
                return aggregator.aggregateResults((Collection)ConverterCollections.getCollection((Collection)listBinParts, (Converter)convUp, (Converter)convNotUsed));
            }
            catch (LicenseException e) {
                DistributedCache$ViewMap.reportMissingLicense("Aggregation", e);
                return agent.aggregate(InvocableMapHelper.makeEntrySet((Collection)this.localEntrySet(filter)));
            }
            catch (RequestTimeoutException e) {
                throw this.processAggregateTimeout(e, aggregator);
            }
        }
        return agent.aggregate(InvocableMapHelper.makeEntrySet((Collection)this.entrySet(filter)));
    }

    public Object aggregate(Collection colKeys, InvocableMap.EntryAggregator agent) {
        if (agent == null) {
            throw new IllegalArgumentException("Processor must be specified");
        }
        Converter convKeyDown = this.getKeyToBinaryConverter();
        Converter convUp = this.getFromBinaryConverter();
        Converter convNotUsed = NullImplementation.getConverter();
        if (agent instanceof InvocableMap.ParallelAwareAggregator) {
            InvocableMap.ParallelAwareAggregator aggregator = (InvocableMap.ParallelAwareAggregator)agent;
            try {
                ConverterCollections.ConverterCollection colBinKeys = colKeys instanceof Set ? ConverterCollections.getSet((Set)((Set)colKeys), (Converter)convKeyDown, (Converter)convUp) : ConverterCollections.getCollection((Collection)colKeys, (Converter)convKeyDown, (Converter)convUp);
                List listBinParts = (List)this.ensureBinaryMap().aggregate((Collection)colBinKeys, aggregator.getParallelAggregator());
                return aggregator.aggregateResults((Collection)ConverterCollections.getCollection((Collection)listBinParts, (Converter)convUp, (Converter)convNotUsed));
            }
            catch (LicenseException e) {
                DistributedCache$ViewMap.reportMissingLicense("Aggregation", e);
            }
            catch (RequestTimeoutException e) {
                throw this.processAggregateTimeout(e, aggregator);
            }
        }
        return agent.aggregate(InvocableMapHelper.makeEntrySet((Map)this.getAll(colKeys), (Collection)colKeys, (boolean)true));
    }

    public void clear() {
        this.ensureBinaryMap().clear();
    }

    public boolean containsKey(Object oKey) {
        return this.ensureConverterMap().containsKey(oKey);
    }

    public boolean containsValue(Object oValue) {
        return this.ensureConverterMap().containsValue(oValue);
    }

    public void destroy() {
        this.getCacheService().destroyCache((NamedCache)this);
    }

    protected NamedCache ensureBinaryMap() {
        NamedCache map = this.getBinaryMap();
        if (map == null) {
            this.onInvalidAccess();
        }
        return map;
    }

    protected ClassLoader ensureClassLoader() {
        ClassLoader loader = this.getClassLoader();
        if (loader == null) {
            this.onInvalidAccess();
        }
        return loader;
    }

    protected ConverterCollections.ConverterObservableMap ensureConverterMap() {
        ConverterCollections.ConverterObservableMap map = this.getConverterMap();
        if (map == null) {
            DistributedCache$ViewMap distributedCache$ViewMap = this;
            synchronized (distributedCache$ViewMap) {
                map = this.getConverterMap();
                if (map == null) {
                    map = ConverterCollections.getObservableMap((ObservableMap)this.ensureBinaryMap(), (Converter)this.getFromBinaryConverter(), (Converter)this.getKeyToBinaryConverter(), (Converter)this.getFromBinaryConverter(), (Converter)this.getValueToBinaryConverter());
                    this.setConverterMap(map);
                }
            }
        }
        return map;
    }

    public Set entrySet() {
        return this.ensureConverterMap().entrySet();
    }

    public Set entrySet(Filter filter) {
        if (filter == null) {
            return this.entrySet();
        }
        Binary binHostKey = null;
        Converter convKeyDown = null;
        if (filter instanceof KeyAssociatedFilter) {
            KeyAssociatedFilter filterAssoc = (KeyAssociatedFilter)filter;
            convKeyDown = this.getKeyToBinaryConverter();
            binHostKey = (Binary)convKeyDown.convert(filterAssoc.getHostKey());
            filter = filterAssoc.getFilter();
        }
        if (filter instanceof LimitFilter) {
            LimitFilter filterLimit = (LimitFilter)filter;
            filterLimit.setComparator(null);
            filterLimit.setTopAnchor(null);
            filterLimit.setBottomAnchor(null);
        }
        this.prepareParallelQuery(filter);
        try {
            if (binHostKey == null) {
                return this.ensureConverterMap().entrySet(filter);
            }
            DistributedCache$BinaryMap mapBinary = (DistributedCache$BinaryMap)this.ensureBinaryMap();
            Converter convUp = this.getFromBinaryConverter();
            Converter convValDown = this.getValueToBinaryConverter();
            return ConverterCollections.getEntrySet((Collection)mapBinary.entrySet(filter, binHostKey), (Converter)convUp, (Converter)convKeyDown, (Converter)convUp, (Converter)convValDown);
        }
        catch (LicenseException e) {
            DistributedCache$ViewMap.reportMissingLicense("Query", e);
            return this.localEntrySet(filter);
        }
        catch (RequestTimeoutException e) {
            throw this.processRequestTimeout(e, DistributedCache$BinaryMap.RESPONSE_SET);
        }
    }

    public Set entrySet(Filter filter, Comparator comparator) {
        Set setEntries;
        if (!(filter == null) ? false : comparator == null) {
            return this.entrySet();
        }
        Binary binHostKey = null;
        Converter convKeyDown = null;
        if (filter instanceof KeyAssociatedFilter) {
            KeyAssociatedFilter filterAssoc = (KeyAssociatedFilter)filter;
            convKeyDown = this.getKeyToBinaryConverter();
            binHostKey = (Binary)convKeyDown.convert(filterAssoc.getHostKey());
            filter = filterAssoc.getFilter();
        }
        LimitFilter filterLimit = null;
        int cPageSize = 0;
        int cSkip = 0;
        if (filter instanceof LimitFilter) {
            filterLimit = (LimitFilter)filter;
            if (comparator == null) {
                comparator = SafeComparator.INSTANCE;
            }
            filterLimit.setComparator(comparator);
            cPageSize = filterLimit.getPageSize();
            int nPage = filterLimit.getPage();
            if (nPage == 0) {
                filterLimit.setTopAnchor(null);
                filterLimit.setBottomAnchor(null);
            } else {
                Object oAnchorTop = filterLimit.getTopAnchor();
                Object oAnchorBottom = filterLimit.getBottomAnchor();
                if (!(oAnchorTop == null) ? false : oAnchorBottom == null) {
                    cSkip = cPageSize * nPage;
                    LimitFilter filterTemp = (LimitFilter)filterLimit.clone();
                    filterTemp.setPage(0);
                    filterTemp.setPageSize(cSkip + cPageSize);
                    filter = filterTemp;
                }
            }
        }
        this.prepareParallelQuery(filter);
        try {
            if (binHostKey == null) {
                setEntries = this.ensureConverterMap().entrySet(filter, comparator);
            } else {
                DistributedCache$BinaryMap mapBinary = (DistributedCache$BinaryMap)this.ensureBinaryMap();
                Converter convUp = this.getFromBinaryConverter();
                Converter convValDown = this.getValueToBinaryConverter();
                setEntries = ConverterCollections.getEntrySet((Collection)mapBinary.entrySet(filter, comparator, binHostKey), (Converter)convUp, (Converter)convKeyDown, (Converter)convUp, (Converter)convValDown);
            }
        }
        catch (LicenseException e) {
            DistributedCache$ViewMap.reportMissingLicense("Query", e);
            return this.localEntrySet(filter, comparator);
        }
        catch (RequestTimeoutException e) {
            throw this.processRequestTimeout(e, DistributedCache$BinaryMap.RESPONSE_VOID);
        }
        Object[] aEntry = setEntries.toArray();
        comparator = new EntryComparator(comparator);
        Arrays.sort(aEntry, comparator);
        if (filterLimit != null) {
            int cEntries;
            if (cSkip > 0) {
                cEntries = Math.min(Math.max(0, aEntry.length - cSkip), cPageSize);
                if (cEntries > 0) {
                    Object[] ao = new Object[cEntries];
                    System.arraycopy(aEntry, cSkip, ao, 0, cEntries);
                    aEntry = ao;
                } else {
                    aEntry = new Object[]{};
                }
            } else {
                filterLimit.setComparator(comparator);
                aEntry = filterLimit.extractPage(aEntry);
                cEntries = aEntry.length;
            }
            if (cEntries > 0) {
                filterLimit.setTopAnchor(((Map.Entry)aEntry[0]).getValue());
                filterLimit.setBottomAnchor(((Map.Entry)aEntry[cEntries - 1]).getValue());
            }
        }
        return new ImmutableArrayList(aEntry);
    }

    public Object get(Object oKey) {
        return this.ensureConverterMap().get(oKey);
    }

    public Map getAll(Collection colKeys) {
        try {
            return this.ensureConverterMap().getAll(colKeys);
        }
        catch (RequestTimeoutException e) {
            throw this.processRequestTimeout(e, DistributedCache$BinaryMap.RESPONSE_MAP);
        }
    }

    public NamedCache getBinaryMap() {
        return this.__m_BinaryMap;
    }

    public String getCacheName() {
        return this.__m_CacheName;
    }

    public CacheService getCacheService() {
        return (DistributedCache)this.get_Module();
    }

    public ClassLoader getClassLoader() {
        return this.__m_ClassLoader;
    }

    protected ConverterCollections.ConverterObservableMap getConverterMap() {
        return this.__m_ConverterMap;
    }

    public Converter getFromBinaryConverter() {
        Converter conv = this.__m_FromBinaryConverter;
        if (conv == null) {
            ClassLoader loader = this.ensureClassLoader();
            conv = loader == NullImplementation.getClassLoader() ? NullImplementation.getConverter() : this.getService().instantiateFromBinaryConverter(loader);
            this.setFromBinaryConverter(conv);
        }
        return conv;
    }

    public Converter getKeyToBinaryConverter() {
        Converter conv = this.__m_KeyToBinaryConverter;
        if (conv == null) {
            ClassLoader loader = this.ensureClassLoader();
            conv = loader == NullImplementation.getClassLoader() ? NullImplementation.getConverter() : this.getService().getBackingMapContext().getKeyToBinaryConverter();
            this.setKeyToBinaryConverter(conv);
        }
        return conv;
    }

    public static long getLicenseMsgTimestamp() {
        return __s_LicenseMsgTimestamp;
    }

    public DistributedCache getService() {
        return (DistributedCache)this.get_Module();
    }

    public Converter getValueToBinaryConverter() {
        Converter conv = this.__m_ValueToBinaryConverter;
        if (conv == null) {
            ClassLoader loader = this.ensureClassLoader();
            conv = loader == NullImplementation.getClassLoader() ? NullImplementation.getConverter() : ExternalizableHelper.CONVERTER_TO_BINARY;
            this.setValueToBinaryConverter(conv);
        }
        return conv;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/daemon/queueProcessor/service/DistributedCache$ViewMap".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    public static Component get_Instance() {
        return new DistributedCache$ViewMap();
    }

    private final Component get_Module() {
        return this.get_Parent();
    }

    protected MapListener instantiateProxyListener(MapListener listener) {
        DistributedCache$ViewMap$ProxyListener listenerProxy = (DistributedCache$ViewMap$ProxyListener)this._newChild("ProxyListener");
        listenerProxy.setListener(listener);
        return listener instanceof MapListenerSupport.SynchronousListener ? new MapListenerSupport.WrapperSynchronousListener((MapListener)listenerProxy) : (MapListener)listenerProxy;
    }

    public synchronized void invalidate() {
        if (this.isActive()) {
            this.setActive(false);
            this.setBinaryMap(null);
            this.setConverterMap(null);
            this.setClassLoader(null);
            this.setFromBinaryConverter(null);
            this.setKeyToBinaryConverter(null);
            this.setValueToBinaryConverter(null);
        }
    }

    public Object invoke(Object oKey, InvocableMap.EntryProcessor agent) {
        if (agent == null) {
            throw new IllegalArgumentException("Processor must be specified");
        }
        Converter convKeyDown = this.getKeyToBinaryConverter();
        Converter convValUp = this.getFromBinaryConverter();
        try {
            return convValUp.convert(this.ensureBinaryMap().invoke(convKeyDown.convert(oKey), agent));
        }
        catch (LicenseException e) {
            DistributedCache$ViewMap.reportMissingLicense("Invocation", e);
            return InvocableMapHelper.invokeLocked((ConcurrentMap)this, (InvocableMap.Entry)InvocableMapHelper.makeEntry((Map)((Object)this), (Object)oKey), (InvocableMap.EntryProcessor)agent);
        }
    }

    public Map invokeAll(Filter filter, InvocableMap.EntryProcessor agent) {
        if (agent == null) {
            throw new IllegalArgumentException("Processor must be specified");
        }
        Converter convKeyDown = this.getKeyToBinaryConverter();
        Converter convUp = this.getFromBinaryConverter();
        Converter convNotUsed = NullImplementation.getConverter();
        Binary binHostKey = null;
        if (filter instanceof KeyAssociatedFilter) {
            KeyAssociatedFilter filterAssoc = (KeyAssociatedFilter)filter;
            binHostKey = (Binary)convKeyDown.convert(filterAssoc.getHostKey());
            filter = filterAssoc.getFilter();
        }
        if (filter instanceof LimitFilter) {
            throw new UnsupportedOperationException("LimitFilter cannot be used with invokeAll");
        }
        this.prepareParallelQuery(filter);
        try {
            DistributedCache$BinaryMap mapBinary = (DistributedCache$BinaryMap)this.ensureBinaryMap();
            Map mapBinaryResult = binHostKey == null ? mapBinary.invokeAll(filter, agent) : mapBinary.invokeAll(filter, agent, binHostKey);
            return ConverterCollections.getMap((Map)mapBinaryResult, (Converter)convUp, (Converter)convKeyDown, (Converter)convUp, (Converter)convNotUsed);
        }
        catch (LicenseException e) {
            DistributedCache$ViewMap.reportMissingLicense("Invocation", e);
            return InvocableMapHelper.invokeAllLocked((ConcurrentMap)this, (Set)InvocableMapHelper.makeEntrySet((Map)((Object)this), (Collection)this.localKeySet(filter), (boolean)false), (InvocableMap.EntryProcessor)agent);
        }
        catch (RequestTimeoutException e) {
            throw this.processRequestTimeout(e, DistributedCache$BinaryMap.RESPONSE_MAP);
        }
    }

    public Map invokeAll(Collection colKeys, InvocableMap.EntryProcessor agent) {
        if (agent == null) {
            throw new IllegalArgumentException("Processor must be specified");
        }
        Converter convKeyDown = this.getKeyToBinaryConverter();
        Converter convUp = this.getFromBinaryConverter();
        Converter convNotUsed = NullImplementation.getConverter();
        ConverterCollections.ConverterCollection colBinKeys = colKeys instanceof Set ? ConverterCollections.getSet((Set)((Set)colKeys), (Converter)convKeyDown, (Converter)convUp) : ConverterCollections.getCollection((Collection)colKeys, (Converter)convKeyDown, (Converter)convUp);
        try {
            Map mapBinaryResult = this.ensureBinaryMap().invokeAll((Collection)colBinKeys, agent);
            return ConverterCollections.getMap((Map)mapBinaryResult, (Converter)convUp, (Converter)convKeyDown, (Converter)convUp, (Converter)convNotUsed);
        }
        catch (LicenseException e) {
            DistributedCache$ViewMap.reportMissingLicense("Invocation", e);
            return InvocableMapHelper.invokeAllLocked((ConcurrentMap)this, (Set)InvocableMapHelper.makeEntrySet((Map)((Object)this), (Collection)colKeys, (boolean)false), (InvocableMap.EntryProcessor)agent);
        }
        catch (RequestTimeoutException e) {
            throw this.processRequestTimeout(e, DistributedCache$BinaryMap.RESPONSE_MAP);
        }
    }

    public boolean isActive() {
        return this.__m_Active;
    }

    public boolean isEmpty() {
        return this.ensureConverterMap().isEmpty();
    }

    public Set keySet() {
        return this.ensureConverterMap().keySet();
    }

    public Set keySet(Filter filter) {
        if (filter == null) {
            return this.keySet();
        }
        Binary binHostKey = null;
        Converter convKeyDown = null;
        if (filter instanceof KeyAssociatedFilter) {
            KeyAssociatedFilter filterAssoc = (KeyAssociatedFilter)filter;
            convKeyDown = this.getKeyToBinaryConverter();
            binHostKey = (Binary)convKeyDown.convert(filterAssoc.getHostKey());
            filter = filterAssoc.getFilter();
        }
        if (filter instanceof LimitFilter) {
            LimitFilter filterLimit = (LimitFilter)filter;
            filterLimit.setComparator(null);
            filterLimit.setTopAnchor(null);
            filterLimit.setBottomAnchor(null);
        }
        this.prepareParallelQuery(filter);
        try {
            if (binHostKey == null) {
                return this.ensureConverterMap().keySet(filter);
            }
            DistributedCache$BinaryMap mapBinary = (DistributedCache$BinaryMap)this.ensureBinaryMap();
            Converter convUp = this.getFromBinaryConverter();
            return ConverterCollections.getSet((Set)mapBinary.keySet(filter, binHostKey), (Converter)convUp, (Converter)convKeyDown);
        }
        catch (LicenseException e) {
            DistributedCache$ViewMap.reportMissingLicense("Query", e);
            return this.localKeySet(filter);
        }
        catch (RequestTimeoutException e) {
            throw this.processRequestTimeout(e, DistributedCache$BinaryMap.RESPONSE_SET);
        }
    }

    protected Set localEntrySet(Filter filter) {
        return InvocableMapHelper.query((Map)((Object)this), (Filter)filter, (boolean)true, (boolean)false, null);
    }

    protected Set localEntrySet(Filter filter, Comparator comparator) {
        return InvocableMapHelper.query((Map)((Object)this), (Filter)filter, (boolean)true, (boolean)true, (Comparator)comparator);
    }

    protected Set localKeySet(Filter filter) {
        return InvocableMapHelper.query((Map)((Object)this), (Filter)filter, (boolean)false, (boolean)false, null);
    }

    public boolean lock(Object oKey) {
        return this.ensureBinaryMap().lock(this.getKeyToBinaryConverter().convert(oKey));
    }

    public boolean lock(Object oKey, long lMillis) {
        return this.ensureBinaryMap().lock(this.getKeyToBinaryConverter().convert(oKey), lMillis);
    }

    protected void onInvalidAccess() {
        throw new IllegalStateException(String.valueOf("The distributed cache reference \"") + this.getCacheName() + "\" has been invalidated; no further operations are allowed.");
    }

    protected void prepareParallelQuery(Filter filter) {
        Filter filterTest;
        Filter filter2 = filterTest = filter instanceof LimitFilter ? ((LimitFilter)filter).getFilter() : filter;
        if (filterTest instanceof InKeySetFilter) {
            ((InKeySetFilter)filterTest).ensureConverted(this.getKeyToBinaryConverter());
        }
    }

    protected RequestTimeoutException processAggregateTimeout(RequestTimeoutException eTimeout, InvocableMap.ParallelAwareAggregator aggregator) {
        Object oResult = eTimeout.getPartialResult();
        if (oResult != null) {
            try {
                oResult = aggregator.aggregateResults((Collection)ConverterCollections.getCollection((Collection)((List)oResult), (Converter)this.getFromBinaryConverter(), (Converter)NullImplementation.getConverter()));
            }
            catch (Throwable e) {
                oResult = null;
            }
        }
        eTimeout.setPartialResult(oResult);
        return eTimeout;
    }

    protected RequestTimeoutException processRequestTimeout(RequestTimeoutException eTimeout, int nResponseType) {
        Object oResult = eTimeout.getPartialResult();
        if (oResult != null) {
            try {
                Converter convKeyDown = this.getKeyToBinaryConverter();
                Converter convUp = this.getFromBinaryConverter();
                Converter convNotUsed = NullImplementation.getConverter();
                switch (nResponseType) {
                    case 2: {
                        oResult = ConverterCollections.getSet((Set)((Set)oResult), (Converter)convUp, (Converter)convNotUsed);
                        break;
                    }
                    case 3: {
                        oResult = ConverterCollections.getMap((Map)((Map)oResult), (Converter)convUp, (Converter)convKeyDown, (Converter)convUp, (Converter)convNotUsed);
                        break;
                    }
                    default: {
                        oResult = null;
                        break;
                    }
                }
            }
            catch (Throwable e) {
                oResult = null;
            }
        }
        eTimeout.setPartialResult(oResult);
        return eTimeout;
    }

    public Object put(Object oKey, Object oValue) {
        return this.ensureConverterMap().put(oKey, oValue);
    }

    public Object put(Object oKey, Object oValue, long cMillis) {
        return this.ensureConverterMap().put(oKey, oValue, cMillis);
    }

    public void putAll(Map map) {
        this.ensureConverterMap().putAll(map);
    }

    public void release() {
        this.getCacheService().releaseCache((NamedCache)this);
    }

    public Object remove(Object oKey) {
        return this.ensureConverterMap().remove(oKey);
    }

    public void removeIndex(ValueExtractor extractor) {
        this.ensureBinaryMap().removeIndex(extractor);
    }

    public void removeMapListener(MapListener listener) {
        this.removeMapListener(listener, null);
    }

    public void removeMapListener(MapListener listener, Filter filter) {
        this.ensureBinaryMap().removeMapListener(this.instantiateProxyListener(listener), filter);
    }

    public void removeMapListener(MapListener listener, Object oKey) {
        this.ensureBinaryMap().removeMapListener(this.instantiateProxyListener(listener), this.getKeyToBinaryConverter().convert(oKey));
    }

    public String reportKey(Object oKey) {
        DistributedCache service = this.getService();
        Binary binKey = (Binary)this.getKeyToBinaryConverter().convert(oKey);
        int iBucket = service.getKeyBucket(binKey);
        return service.reportBucketOwnership(iBucket);
    }

    private static void reportMissingLicense(String sFeature, LicenseException e) {
        long ldtMsg = DistributedCache$ViewMap.getLicenseMsgTimestamp();
        if (ldtMsg == 0L) {
            DistributedCache$ViewMap.setLicenseMsgTimestamp(Base.getSafeTimeMillis());
            String sMsg = String.valueOf("Parallel ") + sFeature + " is a feature of Coherence Edition and Coherence Grid Edition," + " and is not available in this Coherence Edition; selecting the default single-threaded Local " + sFeature + " implementation instead. The single-threaded Local " + sFeature + " implementation uses significantly more resources (CPU, memory and network) than the Parallel " + sFeature + " implementation" + (sFeature.equals("Query") ? ", and should not be used for large queries" : "") + ".";
            Component._trace(sMsg, 2);
        }
    }

    public String reportStorage(boolean fPrimary) {
        DistributedCache service = this.getService();
        DistributedCache$BinaryMap mapBinary = (DistributedCache$BinaryMap)service.getReferencesBinaryMap().get(this.getCacheName());
        long lCacheId = mapBinary.getCacheId();
        DistributedCache$Storage storage = service.getStorage(lCacheId);
        Map map = fPrimary ? storage.getResourceMap() : storage.getBackupMap();
        StringBuffer sb = new StringBuffer();
        sb.append("CacheId=").append(lCacheId).append(", Size=").append(map.size());
        Iterator iter = map.keySet().iterator();
        while (iter.hasNext()) {
            Binary binKey = (Binary)iter.next();
            Binary binValue = (Binary)map.get(binKey);
            sb.append('\n').append(this.getFromBinaryConverter().convert((Object)binKey)).append(" = ").append(this.getFromBinaryConverter().convert((Object)binValue));
            if (!(fPrimary ? service.isPrimaryOwner(binKey) ^ true : service.isBackupOwner(binKey) ^ true)) continue;
            int iBucket = service.getKeyBucket(binKey);
            int[] aiBucketOwner = service.getStorageAssignments()[iBucket];
            int nBucketOwner = fPrimary ? aiBucketOwner[0] : aiBucketOwner[1];
            sb.append(" ! owner=").append(nBucketOwner);
        }
        return sb.toString();
    }

    protected void setActive(boolean fActive) {
        this.__m_Active = fActive;
    }

    public void setBinaryMap(NamedCache map) {
        if (this.isActive()) {
            Component._assert(!(this.getBinaryMap() == null) ? false : map != null);
            this.setCacheName(map.getCacheName());
        } else {
            Component._assert(map == null);
        }
        this.__m_BinaryMap = map;
    }

    protected void setCacheName(String sName) {
        this.__m_CacheName = sName;
    }

    public void setClassLoader(ClassLoader loader) {
        if (this.isActive()) {
            Component._assert(!(this.getClassLoader() == null) ? false : loader != null);
        } else {
            Component._assert(loader == null);
        }
        this.__m_ClassLoader = loader;
    }

    protected void setConverterMap(ConverterCollections.ConverterObservableMap map) {
        if (this.isActive()) {
            Component._assert(!(this.getConverterMap() == null) ? false : map != null);
        } else {
            Component._assert(map == null);
        }
        this.__m_ConverterMap = map;
    }

    protected void setFromBinaryConverter(Converter conv) {
        this.__m_FromBinaryConverter = conv;
    }

    protected void setKeyToBinaryConverter(Converter conv) {
        this.__m_KeyToBinaryConverter = conv;
    }

    private static void setLicenseMsgTimestamp(long ldt) {
        __s_LicenseMsgTimestamp = ldt;
    }

    protected void setValueToBinaryConverter(Converter conv) {
        this.__m_ValueToBinaryConverter = conv;
    }

    public int size() {
        return this.ensureConverterMap().size();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.get_Name()).append("{Name=").append(this.getCacheName()).append(", ClassLoader=").append(this.getClassLoader()).append(", ServiceName=").append(this.getService().getServiceName()).append('}');
        return sb.toString();
    }

    public boolean unlock(Object oKey) {
        return this.ensureBinaryMap().unlock(this.getKeyToBinaryConverter().convert(oKey));
    }

    public Collection values() {
        return this.ensureConverterMap().values();
    }
}

