/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.daemon.queueProcessor.service;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.Data;
import com.tangosol.coherence.component.net.Lease;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.run.xml.XmlSerializable;
import com.tangosol.util.WrapperException;

public class ReplicatedCache$CacheConfig
extends Data
implements XmlSerializable {
    private int __m_GraveyardSize;
    private int __m_LeaseGranularity;
    private boolean __m_MobileIssues;
    private long __m_StandardLeaseMillis;

    public ReplicatedCache$CacheConfig() {
        this(null, null, true);
    }

    public ReplicatedCache$CacheConfig(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setGraveyardSize(256);
            this.setLeaseGranularity(0);
            this.setMobileIssues(false);
            this.setStandardLeaseMillis(20000L);
        }
        catch (Exception e) {
            throw new WrapperException((Throwable)e);
        }
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    public void fromXml(XmlElement xml) {
        long lLeaseMillis = xml.getSafeElement("standard-lease-milliseconds").getLong(this.getStandardLeaseMillis());
        this.setStandardLeaseMillis(Math.max((long)0, lLeaseMillis));
        this.setMobileIssues(xml.getSafeElement("mobile-issues").getBoolean(this.isMobileIssues()));
        this.setGraveyardSize(xml.getSafeElement("graveyard-size").getInt(this.getGraveyardSize()));
        String sLeaseGranularity = xml.getSafeElement("lease-granularity").getString("thread");
        this.setLeaseGranularity(sLeaseGranularity.equals("member") ? Lease.BY_MEMBER : Lease.BY_THREAD);
    }

    public int getGraveyardSize() {
        return this.__m_GraveyardSize;
    }

    public int getLeaseGranularity() {
        return this.__m_LeaseGranularity;
    }

    public long getStandardLeaseMillis() {
        return this.__m_StandardLeaseMillis;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/daemon/queueProcessor/service/ReplicatedCache$CacheConfig".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    public static Component get_Instance() {
        return new ReplicatedCache$CacheConfig();
    }

    private final Component get_Module() {
        return this.get_Parent();
    }

    public boolean isMobileIssues() {
        return this.__m_MobileIssues;
    }

    public void setGraveyardSize(int nSize) {
        this.__m_GraveyardSize = nSize;
    }

    protected void setLeaseGranularity(int nHeldBy) {
        this.__m_LeaseGranularity = nHeldBy;
    }

    protected void setMobileIssues(boolean fMobile) {
        this.__m_MobileIssues = fMobile;
    }

    protected void setStandardLeaseMillis(long lMillis) {
        this.__m_StandardLeaseMillis = lMillis;
    }

    public XmlElement toXml() {
        return null;
    }
}

