/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.deltaMap;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.util.DeltaMap;
import com.tangosol.util.Base;
import com.tangosol.util.ConcurrentMap;
import com.tangosol.util.LiteSet;
import com.tangosol.util.TransactionMap;
import com.tangosol.util.WrapperConcurrentMap;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class TransactionMap
extends DeltaMap
implements com.tangosol.util.TransactionMap {
    public static final int CONCUR_EXTERNAL = 3;
    public static final int CONCUR_OPTIMISTIC = 2;
    public static final int CONCUR_PESSIMISTIC = 1;
    public static final int TRANSACTION_GET_COMMITTED = 1;
    public static final int TRANSACTION_REPEATABLE_GET = 2;
    public static final int TRANSACTION_SERIALIZABLE = 3;
    private transient LiteSet __m_BaseLockSet;
    private transient ConcurrentMap __m_BaseMap;
    private int __m_Concurrency;
    private long __m_LockWaitMillis;
    private int __m_TransactionIsolation;
    private transient long __m_TransactionStart;
    private int __m_TransactionTimeout;
    private TransactionMap.Validator __m_Validator;

    public TransactionMap(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    public void begin() {
        Component._assert(!(this.getOriginalMap() != null) ? false : this.getUpdateMap() != null);
        this.setTransactionStart(Base.getSafeTimeMillis());
    }

    protected void checkTimeout() {
        int nTimeout = this.getTransactionTimeout();
        if (nTimeout > 0) {
            long lStart = this.getTransactionStart();
            long lTime = Base.getSafeTimeMillis();
            if ((int)((lTime - lStart) / (long)1000) > nTimeout) {
                this.rollback();
                throw new RuntimeException(String.valueOf("Transaction timed-out: ") + " elapsed=" + (int)((lTime - lStart) / (long)1000) + ", timeout=" + nTimeout);
            }
        }
    }

    public void clear() {
        this.enlistAll(true);
        super.clear();
    }

    public void commit() {
        this.resolve((Map)this.getBaseMap());
        this.reset();
    }

    public boolean containsKey(Object oKey) {
        this.enlist(oKey, false);
        return super.containsKey(oKey);
    }

    public boolean containsValue(Object oValue) {
        this.enlistAll(false);
        return super.containsValue(oValue);
    }

    protected void enlist(Object oKey, boolean fWrite) {
    }

    protected void enlistAll(boolean fWrite) {
    }

    public Set entrySet() {
        this.enlistAll(false);
        return super.entrySet();
    }

    public Object get(Object oKey) {
        this.enlist(oKey, false);
        return super.get(oKey);
    }

    public Map getAll(Collection colKeys) {
        Iterator iter = colKeys.iterator();
        while (iter.hasNext()) {
            Object oKey = iter.next();
            this.enlist(oKey, false);
        }
        return super.getAll(colKeys);
    }

    public LiteSet getBaseLockSet() {
        return this.__m_BaseLockSet;
    }

    public ConcurrentMap getBaseMap() {
        return this.__m_BaseMap;
    }

    public int getConcurrency() {
        return this.__m_Concurrency;
    }

    public long getLockWaitMillis() {
        long lWaitMillis = this.__m_LockWaitMillis;
        int nTimeout = this.getTransactionTimeout();
        if (!(lWaitMillis < (long)0) ? false : nTimeout > 0) {
            long lElapsed = Base.getSafeTimeMillis() - this.getTransactionStart();
            lWaitMillis = Math.max((long)0, (long)(nTimeout * 1000) - lElapsed);
        }
        return lWaitMillis;
    }

    public int getTransactionIsolation() {
        return this.__m_TransactionIsolation;
    }

    public long getTransactionStart() {
        return this.__m_TransactionStart;
    }

    public int getTransactionTimeout() {
        return this.__m_TransactionTimeout;
    }

    public TransactionMap.Validator getValidator() {
        return this.__m_Validator;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/deltaMap/TransactionMap".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    private final Component get_Module() {
        return this;
    }

    public void initialize(Map mapOrig, Map mapInsert, Map mapUpdate, Map mapDelete, Map mapRead) {
        if (this.getBaseMap() == null) {
            this.setBaseMap((ConcurrentMap)(mapOrig instanceof ConcurrentMap ? (ConcurrentMap)mapOrig : new WrapperConcurrentMap(mapOrig, false, -1L)));
        }
        super.initialize(mapOrig, mapInsert, mapUpdate, mapDelete, mapRead);
    }

    public boolean isEmpty() {
        this.enlistAll(false);
        return super.isEmpty();
    }

    public boolean isValuesImmutable() {
        return false;
    }

    public Set keySet() {
        this.enlistAll(false);
        return super.keySet();
    }

    public boolean lock(Object oKey) {
        return this.getBaseMap().lock(oKey);
    }

    public boolean lock(Object oKey, long cWait) {
        return this.getBaseMap().lock(oKey, cWait);
    }

    public void prepare() {
        this.checkTimeout();
    }

    public Object put(Object oKey, Object oValue) {
        this.enlist(oKey, true);
        return super.put(oKey, oValue);
    }

    public Object remove(Object oKey) {
        this.enlist(oKey, true);
        return super.remove(oKey);
    }

    public void reset() {
        LiteSet setLock = this.getBaseLockSet();
        if (setLock.isEmpty() ^ true) {
            ConcurrentMap mapBase = this.getBaseMap();
            Iterator iter = setLock.iterator();
            while (iter.hasNext()) {
                mapBase.unlock(iter.next());
            }
            setLock.clear();
        }
        super.reset();
    }

    public void rollback() {
        this.reset();
    }

    protected void setBaseLockSet(LiteSet setLock) {
        this.__m_BaseLockSet = setLock;
    }

    protected void setBaseMap(ConcurrentMap map) {
        this.__m_BaseMap = map;
    }

    public void setConcurrency(int nConcurrency) {
        if (this.is_Constructed()) {
            throw new IllegalStateException();
        }
        this.__m_Concurrency = nConcurrency;
    }

    public void setLockWaitMillis(long cWaitMillis) {
        this.__m_LockWaitMillis = cWaitMillis;
    }

    public void setTransactionIsolation(int iLevel) {
        if (this.is_Constructed()) {
            throw new IllegalStateException();
        }
        this.__m_TransactionIsolation = iLevel;
    }

    public void setTransactionStart(long pTransactionStart) {
        this.__m_TransactionStart = pTransactionStart;
    }

    public void setTransactionTimeout(int nTimeout) {
        this.__m_TransactionTimeout = nTimeout;
    }

    public void setValidator(TransactionMap.Validator validator) {
        this.__m_Validator = validator;
    }

    public void setValuesImmutable(boolean fImmutable) {
    }

    public int size() {
        this.enlistAll(false);
        return super.size();
    }

    public boolean unlock(Object oKey) {
        return this.getBaseMap().unlock(oKey);
    }

    public Collection values() {
        this.enlistAll(false);
        return super.values();
    }
}

