/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.pool.simplePool;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.util.Queue;
import com.tangosol.coherence.component.util.pool.SimplePool;

public abstract class GrowablePool
extends SimplePool {
    private int __m_Capacity;
    private int __m_Size;

    public GrowablePool(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    public Object acquire() {
        Object oElement = this.getStorage().removeNoWait();
        if (oElement == null) {
            boolean fNew = false;
            GrowablePool growablePool = this;
            synchronized (growablePool) {
                int cSize = this.getSize();
                int cCapacity = this.getCapacity();
                if (cSize < cCapacity ? true : cCapacity <= 0) {
                    this.setSize(cSize + 1);
                    fNew = true;
                }
            }
            if (fNew) {
                return this.instantiateResource();
            }
            return this.getStorage().remove();
        }
        return oElement;
    }

    public int getCapacity() {
        return this.__m_Capacity;
    }

    public int getSize() {
        return this.__m_Size;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/pool/simplePool/GrowablePool".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    private final Component get_Module() {
        return this;
    }

    public synchronized void grow(int cResources) {
        int iSize = this.getSize();
        Component._assert(iSize + cResources <= this.getCapacity(), "growth cannot exceed capacity");
        Queue queue = this.getStorage();
        int i = iSize;
        while (i < cResources) {
            queue.add(this.instantiateResource());
            ++i;
        }
        this.setSize(iSize + cResources);
    }

    public void setCapacity(int cElements) {
        if (this.getCapacity() != 0) {
            throw new UnsupportedOperationException("GrowablePool maximum capacity cannot be changed.");
        }
        this.__m_Capacity = cElements;
    }

    protected void setSize(int cElements) {
        this.__m_Size = cElements;
    }
}

