/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.queue;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.util.Queue;
import com.tangosol.coherence.component.util.Queue$Iterator;
import com.tangosol.util.ListMap;
import com.tangosol.util.WrapperException;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;

public abstract class PriorityQueue
extends Queue {
    private Comparator __m_Comparator;
    private volatile int __m_Size;
    private SortedSet __m_SortedElementSet;
    private static ListMap __mapChildren;

    static {
        PriorityQueue.__initStatic();
    }

    public PriorityQueue(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    private static void __initStatic() {
        __mapChildren = new ListMap();
        Object object = __mapChildren.put((Object)"Iterator", (Object)Queue$Iterator.get_CLASS());
    }

    public synchronized boolean add(Object oElement) {
        SortedSet setSorted = this.getSortedElementSet();
        if (setSorted.add(oElement)) {
            this.setSize(setSorted.size());
            this.notify();
            return true;
        }
        return false;
    }

    public synchronized boolean addHead(Object oElement) {
        return this.add(oElement);
    }

    public Comparator getComparator() {
        return this.__m_Comparator;
    }

    protected List getElementList() {
        throw new UnsupportedOperationException();
    }

    protected int getSize() {
        return this.__m_Size;
    }

    protected SortedSet getSortedElementSet() {
        TreeSet set = this.__m_SortedElementSet;
        if (set == null) {
            set = new TreeSet(this.getComparator());
            this.setSortedElementSet(set);
        }
        return set;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/queue/PriorityQueue".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    private final Component get_Module() {
        return this;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Iterator iterator() {
        return this.getSortedElementSet().iterator();
    }

    public synchronized Object peekNoWait() {
        SortedSet set = this.getSortedElementSet();
        return set.isEmpty() ? null : set.first();
    }

    public synchronized Object remove() {
        SortedSet setSorted = this.getSortedElementSet();
        while (setSorted.isEmpty()) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new WrapperException((Throwable)e);
            }
        }
        Object o = setSorted.first();
        setSorted.remove(o);
        this.setSize(setSorted.size());
        return o;
    }

    public synchronized Object removeNoWait() {
        SortedSet setSorted = this.getSortedElementSet();
        if (setSorted.isEmpty()) {
            return null;
        }
        Object o = setSorted.first();
        setSorted.remove(o);
        this.setSize(setSorted.size());
        return o;
    }

    public synchronized void setComparator(Comparator comparator) {
        SortedSet setOld = this.getSortedElementSet();
        this.setSortedElementSet(null);
        this.__m_Comparator = comparator;
        this.getSortedElementSet().addAll(setOld);
        setOld.clear();
    }

    protected void setSize(int cEntries) {
        this.__m_Size = cEntries;
    }

    protected void setSortedElementSet(SortedSet set) {
        this.__m_SortedElementSet = set;
    }

    public int size() {
        return this.getSize();
    }
}

