/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.queue.concurrentQueue;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.util.Queue$Iterator;
import com.tangosol.coherence.component.util.queue.ConcurrentQueue;
import com.tangosol.coherence.component.util.queue.concurrentQueue.MultiQueue$WindowedArray;
import com.tangosol.util.AtomicCounter;
import com.tangosol.util.Base;
import com.tangosol.util.ListMap;
import java.util.Map;

public abstract class MultiQueue
extends ConcurrentQueue {
    private AtomicCounter __m_NextRemoveableIndex;
    private MultiQueue$WindowedArray __m_WindowedArray;
    private static ListMap __mapChildren;

    static {
        MultiQueue.__initStatic();
    }

    public MultiQueue(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    private static void __initStatic() {
        __mapChildren = new ListMap();
        Object object = __mapChildren.put((Object)"Iterator", (Object)Queue$Iterator.get_CLASS());
    }

    public boolean add(Object oElement) {
        if (oElement == null) {
            throw new IllegalArgumentException("The MultiQueue does not support null values.");
        }
        this.getWindowedArray().add(oElement);
        this.onAddElement();
        return true;
    }

    public boolean addHead(Object oElement) {
        throw new UnsupportedOperationException();
    }

    protected void checkFlush(int cElements) {
        if (cElements == 0) {
            this.onEmpty();
        } else {
            super.checkFlush(cElements);
        }
    }

    public AtomicCounter getNextRemoveableIndex() {
        return this.__m_NextRemoveableIndex;
    }

    protected MultiQueue$WindowedArray getWindowedArray() {
        return this.__m_WindowedArray;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/queue/concurrentQueue/MultiQueue".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    private final Component get_Module() {
        return this;
    }

    public void onInit() {
        super.onInit();
        MultiQueue$WindowedArray wa = (MultiQueue$WindowedArray)this._findChild("WindowedArray");
        this.setWindowedArray(wa);
        this.setNextRemoveableIndex(AtomicCounter.newAtomicCounter((long)wa.getFirstIndex()));
    }

    public Object peekNoWait() {
        AtomicCounter atomicNext;
        long lNext;
        MultiQueue$WindowedArray wa = this.getWindowedArray();
        Object oPeek = wa.optimisticGet(lNext = (atomicNext = this.getNextRemoveableIndex()).getCount());
        return (!(oPeek == null) ? false : lNext <= wa.getLastIndex()) ? wa.get(atomicNext.getCount()) : oPeek;
    }

    public Object remove() {
        return this.getNotifier() == null ? this.removeMulti() : super.remove();
    }

    protected Object removeMulti() {
        MultiQueue$WindowedArray wa = this.getWindowedArray();
        Object oRemoved = null;
        boolean fRollback = true;
        do {
            Object var7_5;
            long lNext = this.getNextRemoveableIndex().postIncrement();
            try {
                try {
                    oRemoved = wa.safeRemove(lNext, 1000L);
                    fRollback = !(oRemoved == null) ? false : wa.isRemoved(lNext) ^ true;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw Base.ensureRuntimeException((Throwable)e);
                }
                var7_5 = null;
                if (!fRollback) continue;
                this.rollbackNextIndex(lNext);
            }
            catch (Throwable throwable) {
                var7_5 = null;
                if (fRollback) {
                    this.rollbackNextIndex(lNext);
                }
                throw throwable;
            }
        } while (oRemoved == null);
        if (this.getElementCounter().decrement() == 0L) {
            this.onEmpty();
        }
        return oRemoved;
    }

    public Object removeNoWait() {
        return this.getNotifier() == null ? this.removeNoWaitMulti() : this.removeNoWaitSingle();
    }

    protected Object removeNoWaitMulti() {
        MultiQueue$WindowedArray wa = this.getWindowedArray();
        AtomicCounter atomicNext = this.getNextRemoveableIndex();
        Object oRemoved = null;
        boolean fRollback = true;
        do {
            Object var8_6;
            long lNext = atomicNext.postIncrement();
            try {
                try {
                    oRemoved = wa.safeRemove(lNext);
                    if (oRemoved == null) {
                        if (lNext <= wa.getLastIndex()) {
                            oRemoved = wa.safeRemove(lNext, -1L);
                        } else {
                            Object var7_7 = null;
                            var8_6 = null;
                            if (fRollback) {
                                this.rollbackNextIndex(lNext);
                            }
                            return var7_7;
                        }
                    }
                    fRollback = false;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw Base.ensureRuntimeException((Throwable)e);
                }
            }
            catch (Throwable throwable) {
                var8_6 = null;
                if (fRollback) {
                    this.rollbackNextIndex(lNext);
                }
                throw throwable;
            }
            var8_6 = null;
            if (!fRollback) continue;
            this.rollbackNextIndex(lNext);
        } while (oRemoved == null);
        if (this.getElementCounter().decrement() == 0L) {
            this.onEmpty();
        }
        return oRemoved;
    }

    protected Object removeNoWaitSingle() {
        MultiQueue$WindowedArray wa = this.getWindowedArray();
        AtomicCounter atomicNext = this.getNextRemoveableIndex();
        Object oRemoved = wa.safeRemove(atomicNext.getCount());
        try {
            while (oRemoved == null) {
                long lFirst = atomicNext.getCount();
                if (lFirst > wa.getLastIndex()) {
                    return null;
                }
                oRemoved = wa.safeRemove(lFirst, -1L);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw Base.ensureRuntimeException((Throwable)e);
        }
        atomicNext.increment();
        if (this.getElementCounter().decrement() == 0L) {
            this.onEmpty();
        }
        return oRemoved;
    }

    protected void rollbackNextIndex(long iVirtual) {
        long lCur;
        AtomicCounter atomicNext = this.getNextRemoveableIndex();
        while (!((lCur = atomicNext.getCount()) <= iVirtual ? true : atomicNext.setCount(lCur, iVirtual))) {
        }
    }

    public void setNextRemoveableIndex(AtomicCounter pNextRemoveableIndex) {
        this.__m_NextRemoveableIndex = pNextRemoveableIndex;
    }

    protected void setWindowedArray(MultiQueue$WindowedArray waElements) {
        this.__m_WindowedArray = waElements;
    }

    public int size() {
        return Math.max(0, super.size());
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(super.toString());
        sb.append(", next=").append(this.getNextRemoveableIndex().getCount()).append(", storage array={").append(this.getWindowedArray()).append('}');
        return sb.toString();
    }

    public void waitForEntry(long cMillis) {
        try {
            this.getWindowedArray().get(this.getNextRemoveableIndex().getCount(), cMillis == 0L ? -1L : cMillis);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw Base.ensureRuntimeException((Throwable)e);
        }
    }
}

