/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.queue.concurrentQueue.balancedQueue;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.util.queue.concurrentQueue.BalancedQueue$TargetQueue;
import com.tangosol.coherence.component.util.queue.concurrentQueue.BalancedQueue$TargetQueue$Iterator;
import com.tangosol.coherence.component.util.queue.concurrentQueue.balancedQueue.BundlingQueue;
import com.tangosol.util.AtomicCounter;
import com.tangosol.util.ListMap;
import com.tangosol.util.stats.MovingAverage;
import java.util.Map;

public abstract class BundlingQueue$TargetQueue
extends BalancedQueue$TargetQueue {
    private transient long __m_DeferralReadStamp;
    private transient long __m_DeferralTimeStamp;
    private int __m_HeadBundles;
    private static ListMap __mapChildren;

    static {
        BundlingQueue$TargetQueue.__initStatic();
    }

    public BundlingQueue$TargetQueue(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    private static void __initStatic() {
        __mapChildren = new ListMap();
        Object object = __mapChildren.put((Object)"Iterator", (Object)BalancedQueue$TargetQueue$Iterator.get_CLASS());
    }

    protected boolean bundle(Object oSrc, Object oDst) {
        return false;
    }

    public AtomicCounter getAtomicFlushState() {
        return super.getAtomicFlushState();
    }

    public long getDeferralReadStamp() {
        return this.__m_DeferralReadStamp;
    }

    public long getDeferralTimeStamp() {
        return this.__m_DeferralTimeStamp;
    }

    public int getHeadBundles() {
        return this.__m_HeadBundles;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/queue/concurrentQueue/balancedQueue/BundlingQueue$TargetQueue".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    private final Component get_Module() {
        return this.get_Parent();
    }

    public boolean isBundleDeferrable(Object oBundle) {
        if (this.isDeferralTimeout()) {
            return false;
        }
        BundlingQueue queueParent = (BundlingQueue)this.get_Parent();
        MovingAverage average = queueParent.getBundleAverage();
        double dAggression = queueParent.getBundlingAggression();
        int nAverage = average.getAverage();
        double d = this.getHeadBundles();
        double d2 = dAggression == 0.0 ? (double)nAverage : (double)nAverage + dAggression * average.getStandardDeviation();
        return d < d2;
    }

    public boolean isDeferralTimeout() {
        BundlingQueue queueParent = (BundlingQueue)this.get_Parent();
        long cNanosThreshold = queueParent.getDeferralThresholdNanos();
        long ldtDeferral = this.getDeferralTimeStamp();
        if (cNanosThreshold == 0L) {
            return true;
        }
        if (ldtDeferral == 0L) {
            return false;
        }
        long MILLI = 1000000L;
        long cNanos = Math.abs(System.currentTimeMillis() - this.getDeferralTimeStamp()) * MILLI;
        long cReadAttempts = queueParent.getReadAttemptCount();
        long cReads = Math.abs(cReadAttempts - this.getDeferralReadStamp());
        long nReadThreshold = queueParent.getDeferralThresholdReads();
        if (cNanos >= cNanosThreshold + MILLI) {
            long cReadsOptimal = cReads * cNanosThreshold / cNanos;
            if (cReadsOptimal > nReadThreshold) {
                queueParent.setDeferralThresholdReads(cReadsOptimal);
            }
            return true;
        }
        if (!(nReadThreshold > (long)0) ? false : cReads > nReadThreshold) {
            if (cReadAttempts % 8192L == 0L) {
                queueParent.setDeferralThresholdReads(0L);
            }
            return true;
        }
        return false;
    }

    public Object removeNoWait() {
        Object oHead;
        BundlingQueue queueParent = (BundlingQueue)this.get_Parent();
        long lReadCount = queueParent.getReadAttemptCount() + 1L;
        queueParent.setReadAttemptCount(lReadCount);
        int cPassBundles = 0;
        Object object = this.getHeadLock();
        synchronized (object) {
            Object oNext;
            oHead = super.removeNoWait();
            if (oHead == null) {
                Object var7_6 = null;
                Object var8_8 = null;
                return var7_6;
            }
            int cHeadBundles = this.getHeadBundles();
            if (queueParent.getBundleAverage().getAverage() > cHeadBundles + 3) {
                oNext = super.removeNoWait();
                while (!(oNext != null) ? false : this.bundle(oNext, oHead)) {
                    ++cPassBundles;
                    oNext = super.removeNoWait();
                }
                if (oNext != null) {
                    this.addHead(oNext);
                }
            } else {
                oNext = this.peekNoWait();
                while (!(oNext != null) ? false : this.bundle(oNext, oHead)) {
                    super.removeNoWait();
                    ++cPassBundles;
                    oNext = this.peekNoWait();
                }
            }
            cHeadBundles += cPassBundles;
            if (!(oNext == null) ? false : this.isBundleDeferrable(oHead)) {
                if (this.getDeferralTimeStamp() == 0L) {
                    this.setDeferralTimeStamp(System.currentTimeMillis());
                    this.setDeferralReadStamp(lReadCount);
                }
                this.setHeadBundles(cHeadBundles);
                this.addHead(oHead);
                oHead = null;
            } else {
                this.setDeferralTimeStamp(0L);
                this.setDeferralReadStamp(0L);
                this.setHeadBundles(0);
                queueParent.getBundleAverage().addSample(cHeadBundles);
            }
        }
        if (cPassBundles > 0) {
            queueParent.getElementCounter().decrement((long)cPassBundles);
            queueParent.setStatsBundled(queueParent.getStatsBundled() + (long)cPassBundles);
        }
        return oHead;
    }

    public void setDeferralReadStamp(long lReadStamp) {
        this.__m_DeferralReadStamp = lReadStamp;
    }

    protected void setDeferralTimeStamp(long ldtAddLast) {
        this.__m_DeferralTimeStamp = ldtAddLast;
    }

    public void setHeadBundles(int pHeadBundles) {
        this.__m_HeadBundles = pHeadBundles;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(super.toString());
        sb.append(", head bundles=").append(this.getHeadBundles());
        long ldtDef = this.getDeferralTimeStamp();
        if (ldtDef != 0L) {
            sb.append(", deferred=").append(System.currentTimeMillis() - ldtDef).append("ms");
        }
        return sb.toString();
    }
}

