/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.safeService;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.Security;
import com.tangosol.coherence.component.util.SafeNamedCache;
import com.tangosol.coherence.component.util.SafeService;
import com.tangosol.net.BackingMapManager;
import com.tangosol.net.CacheService;
import com.tangosol.net.NamedCache;
import com.tangosol.net.Service;
import com.tangosol.util.LiteMap;
import com.tangosol.util.SafeHashMap;
import com.tangosol.util.WrapperException;
import java.util.Enumeration;
import java.util.Map;

public class SafeCacheService
extends SafeService
implements CacheService {
    private transient BackingMapManager __m_BackingMapManager;
    private transient Map __m_NamedCacheMap;

    public SafeCacheService() {
        this(null, null, true);
    }

    public SafeCacheService(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setNamedCacheMap((Map)new SafeHashMap());
            this.setSafeServiceState(0);
        }
        catch (Exception e) {
            throw new WrapperException((Throwable)e);
        }
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    protected void cleanup() {
        super.cleanup();
        this.getNamedCacheMap().clear();
    }

    public void destroyCache(NamedCache cache) {
        block3: {
            Security.checkPermission(this.getSafeCluster().getCluster(), this.getServiceName(), cache.getCacheName(), "destroy");
            SafeNamedCache cacheSafe = (SafeNamedCache)cache;
            this.removeCacheReference(cacheSafe);
            CacheService service = this.getCacheService();
            try {
                NamedCache cacheWrapped = cacheSafe.getNamedCache();
                if (cacheWrapped == null) {
                    throw new IllegalStateException("Cache is already released");
                }
                service.destroyCache(cacheWrapped);
            }
            catch (RuntimeException e) {
                if (!(!(service != null) ? false : service.isRunning())) break block3;
                throw e;
            }
        }
    }

    private NamedCache ensureCache$Router(String sName, ClassLoader loader) {
        return this.getRunningCacheService().ensureCache(sName, loader);
    }

    public NamedCache ensureCache(String sName, ClassLoader loader) {
        SafeNamedCache cacheSafe;
        this.checkClientThread("ensureCache");
        if (sName == null ? true : sName.length() == 0) {
            sName = "Default";
        }
        if (loader == null) {
            loader = this.getContextClassLoader();
        }
        Security.checkPermission(this.getSafeCluster().getCluster(), this.getServiceName(), sName, "join");
        Map mapByName = this.getNamedCacheMap();
        Map mapByLoader = (Map)mapByName.get(sName);
        if (mapByLoader == null) {
            Map map = mapByName;
            synchronized (map) {
                mapByLoader = (Map)mapByName.get(sName);
                if (mapByLoader == null) {
                    mapByLoader = new LiteMap();
                    mapByName.put(sName, mapByLoader);
                }
            }
        }
        if ((cacheSafe = (SafeNamedCache)mapByLoader.get(loader)) == null) {
            Map map = mapByLoader;
            synchronized (map) {
                cacheSafe = (SafeNamedCache)mapByLoader.get(loader);
                if (cacheSafe == null) {
                    NamedCache cache = this.ensureCache$Router(sName, loader);
                    cacheSafe = new SafeNamedCache();
                    cacheSafe.setSafeCacheService(this);
                    cacheSafe.setCacheName(sName);
                    cacheSafe.setClassLoader(loader);
                    cacheSafe.setNamedCache(cache);
                    mapByLoader.put(loader, cacheSafe);
                }
            }
        }
        return cacheSafe;
    }

    public CacheService ensureRunningCacheService(boolean fDrain) {
        return (CacheService)this.ensureRunningService(fDrain);
    }

    public BackingMapManager getBackingMapManager() {
        return this.__m_BackingMapManager;
    }

    public Enumeration getCacheNames() {
        return this.getRunningCacheService().getCacheNames();
    }

    public CacheService getCacheService() {
        return (CacheService)this.getService();
    }

    public Map getNamedCacheMap() {
        return this.__m_NamedCacheMap;
    }

    protected CacheService getRunningCacheService() {
        return this.ensureRunningCacheService(true);
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/safeService/SafeCacheService".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    public static Component get_Instance() {
        return new SafeCacheService();
    }

    private final Component get_Module() {
        return this;
    }

    public void releaseCache(NamedCache cache) {
        block3: {
            SafeNamedCache cacheSafe = (SafeNamedCache)cache;
            this.removeCacheReference(cacheSafe);
            CacheService service = this.getCacheService();
            try {
                NamedCache cacheWrapped = cacheSafe.getNamedCache();
                if (cacheWrapped != null) {
                    service.releaseCache(cacheWrapped);
                }
            }
            catch (RuntimeException e) {
                if (!(!(service != null) ? false : service.isRunning())) break block3;
                throw e;
            }
        }
    }

    protected void removeCacheReference(SafeNamedCache cacheSafe) {
        cacheSafe.setReleased(true);
        String sName = cacheSafe.getCacheName();
        Map mapByName = this.getNamedCacheMap();
        Map mapByLoader = (Map)mapByName.get(sName);
        if (mapByLoader != null) {
            Map map = mapByLoader;
            synchronized (map) {
                mapByLoader.remove(cacheSafe.getClassLoader());
                if (mapByLoader.isEmpty()) {
                    mapByName.remove(sName);
                }
            }
        }
    }

    public void setBackingMapManager(BackingMapManager manager) {
        this.__m_BackingMapManager = manager;
    }

    protected void setNamedCacheMap(Map map) {
        this.__m_NamedCacheMap = map;
    }

    protected void startService(Service service) {
        ((CacheService)service).setBackingMapManager(this.getBackingMapManager());
        super.startService(service);
    }
}

