/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.admin.actions;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.pages.AttachmentUtils;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.setup.settings.Settings;
import com.atlassian.core.util.PairType;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpURL;
import org.apache.commons.httpclient.HttpsURL;
import org.apache.commons.httpclient.URIException;
import org.apache.webdav.lib.WebdavResource;

public class AttachmentStorageSetupAction
extends ConfluenceActionSupport {
    protected List attachmentStorageTypes;
    protected String attachmentStorageType;
    protected String originalAttachmentStorageType;
    protected String webdavServerUrl;
    protected String webdavUsername;
    protected String webdavPassword;

    public String doDefault() throws Exception {
        this.attachmentStorageType = this.getAttachmentDataStoreOrDefault();
        if ("webdav.based.attachments.storage".equals(this.attachmentStorageType)) {
            Settings globalSettings = this.settingsManager.getGlobalSettings();
            this.webdavServerUrl = globalSettings.getWebdavServerUrl();
            this.webdavUsername = globalSettings.getWebdavUsername();
            this.webdavPassword = globalSettings.getWebdavPassword();
        }
        this.originalAttachmentStorageType = this.attachmentStorageType;
        return super.doDefault();
    }

    public String execute() throws Exception {
        if ("webdav.based.attachments.storage".equals(this.attachmentStorageType)) {
            this.checkWebDavConnection();
        }
        if (this.hasErrors()) {
            return "error";
        }
        if (!this.getAttachmentDataStoreOrDefault().equals(this.attachmentStorageType)) {
            return "migrate";
        }
        return "success";
    }

    private String getAttachmentDataStoreOrDefault() {
        String setting = this.settingsManager.getGlobalSettings().getAttachmentDataStore();
        String currentWebdavServerUrl = this.settingsManager.getGlobalSettings().getWebdavServerUrl();
        if (currentWebdavServerUrl != null && setting == null) {
            return "webdav.based.attachments.storage";
        }
        if (setting == null) {
            return "file.system.based.attachments.storage";
        }
        return setting;
    }

    public String getLocalAttachmentDirectory() {
        return AttachmentUtils.getConfluenceAttachmentDirectory();
    }

    private void checkWebDavConnection() {
        try {
            HttpURL httpURL = AttachmentStorageSetupAction.uriToHttpURL(this.webdavServerUrl);
            httpURL.setUserinfo(this.webdavUsername, this.webdavPassword);
            WebdavResource webdavResource = new WebdavResource(httpURL);
        }
        catch (Exception ex) {
            this.addActionError(this.handleException(ex));
            Object webdavResource = null;
            Object httpURL = null;
        }
    }

    private static HttpURL uriToHttpURL(String uri) throws URIException {
        return uri.startsWith("https") ? new HttpsURL(uri.toCharArray()) : new HttpURL(uri.toCharArray());
    }

    private String handleException(Exception ex) {
        if (ex instanceof HttpException) {
            if (((HttpException)ex).getReasonCode() == 405) {
                return "Warning: Not WebDAV-enabled?";
            }
            if (((HttpException)ex).getReasonCode() == 401) {
                return "Could not connect to WebDav server: Incorrect username and password";
            }
            return "Warning: " + ex.getMessage();
        }
        if (ex instanceof IOException) {
            return "Error: " + ex.getMessage();
        }
        return "FATAL error";
    }

    private File setupDirectory(String dirName, String fieldName, String failureMessageKey) {
        File dir;
        if (dirName == null || dirName.trim().equals("")) {
            return null;
        }
        if (dirName.startsWith("${confluenceHome}")) {
            dirName = this.getBootstrapManager().getConfluenceHome() + dirName.substring("${confluenceHome}".length());
        }
        if (!(dir = new File(dirName)).isDirectory() && !dir.mkdirs()) {
            this.addFieldError(fieldName, this.getText(failureMessageKey));
            return null;
        }
        return dir;
    }

    public boolean isWebDavConfigured() {
        return "webdav.based.attachments.storage".equals(this.attachmentStorageType);
    }

    public boolean isFileSystemConfigured() {
        return "file.system.based.attachments.storage".equals(this.attachmentStorageType);
    }

    public boolean isDatabaseConfigured() {
        return "database.based.attachments.storage".equals(this.attachmentStorageType);
    }

    public List getAttachmentStorageTypes() {
        if (this.attachmentStorageTypes == null) {
            this.attachmentStorageTypes = new ArrayList();
            this.attachmentStorageTypes.add(new PairType((Serializable)((Object)this.getText("file.system.based.attachments.storage")), (Serializable)((Object)"file.system.based.attachments.storage")));
            this.attachmentStorageTypes.add(new PairType((Serializable)((Object)this.getText("database.based.attachments.storage")), (Serializable)((Object)"database.based.attachments.storage")));
            this.attachmentStorageTypes.add(new PairType((Serializable)((Object)this.getText("webdav.based.attachments.storage")), (Serializable)((Object)"webdav.based.attachments.storage")));
        }
        return this.attachmentStorageTypes;
    }

    public void setAttachmentStorageTypes(List attachmentStorageTypes) {
        this.attachmentStorageTypes = attachmentStorageTypes;
    }

    public String getAttachmentStorageType() {
        return this.attachmentStorageType;
    }

    public void setAttachmentStorageType(String attachmentStorageType) {
        this.attachmentStorageType = attachmentStorageType;
    }

    public String getOriginalAttachmentStorageType() {
        return this.originalAttachmentStorageType;
    }

    public String getWebdavServerUrl() {
        return this.webdavServerUrl;
    }

    public void setWebdavServerUrl(String webdavServerUrl) {
        this.webdavServerUrl = webdavServerUrl;
    }

    public String getWebdavUsername() {
        return this.webdavUsername;
    }

    public void setWebdavUsername(String webdavUsername) {
        this.webdavUsername = webdavUsername;
    }

    public String getWebdavPassword() {
        return this.webdavPassword;
    }

    public void setWebdavPassword(String webdavPassword) {
        this.webdavPassword = webdavPassword;
    }

    public boolean isPermitted() {
        return this.permissionManager.hasPermission(this.getRemoteUser(), Permission.ADMINISTER, PermissionManager.TARGET_SYSTEM);
    }
}

