/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.admin.actions;

import com.atlassian.confluence.cache.CacheStatistics;
import com.atlassian.confluence.cache.tangosol.ExpiryCountingLocalCache;
import com.atlassian.confluence.cluster.tangosol.TangosolClusterManager;
import com.atlassian.confluence.core.Administrative;
import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.tangosol.net.CacheService;
import com.tangosol.net.DefaultConfigurableCacheFactory;
import com.tangosol.net.cache.LocalCache;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class CoherenceCacheStatisticsAction
extends ConfluenceActionSupport
implements Administrative {
    private Map cacheStatistics = new HashMap();
    private boolean showDistributions;
    private static final String CACHE_NAME_PREFIX = "cache.name.";

    public boolean isShowDistributions() {
        return this.showDistributions;
    }

    public void setShowDistributions(boolean showDistributions) {
        this.showDistributions = showDistributions;
    }

    public Map getCacheStatistics() {
        return this.cacheStatistics;
    }

    public String execute() {
        Iterator cacheServices = TangosolClusterManager.enumerateCacheServices().iterator();
        this.cacheStatistics = new TreeMap();
        while (cacheServices.hasNext()) {
            CacheService service = (CacheService)cacheServices.next();
            Collection serviceStats = this.getServiceStatistics(service);
            this.cacheStatistics.put(service.getInfo().getServiceName(), serviceStats);
        }
        return "success";
    }

    private Collection getServiceStatistics(CacheService service) {
        Enumeration cacheNames = service.getCacheNames();
        TreeMap<String, CoherenceCacheStatistics> cacheStatistics = new TreeMap<String, CoherenceCacheStatistics>();
        while (cacheNames.hasMoreElements()) {
            String cacheName = (String)cacheNames.nextElement();
            Map mapLocal = ((DefaultConfigurableCacheFactory.Manager)service.getBackingMapManager()).getBackingMap(cacheName);
            if (!(mapLocal instanceof LocalCache)) continue;
            LocalCache cacheLocal = (LocalCache)mapLocal;
            CoherenceCacheStatistics coherenceCacheStatistics = new CoherenceCacheStatistics(cacheName, cacheLocal, this.getText(CACHE_NAME_PREFIX + cacheName, cacheName));
            cacheStatistics.put(coherenceCacheStatistics.getNiceName(), coherenceCacheStatistics);
        }
        return cacheStatistics.values();
    }

    private static class CoherenceCacheStatistics
    implements CacheStatistics {
        private com.tangosol.net.cache.CacheStatistics stats;
        private String name;
        private long highUnits;
        private long size;
        private long expiryCount;
        private String niceName;

        public CoherenceCacheStatistics(String name, LocalCache cache, String niceCacheName) {
            this.stats = cache.getCacheStatistics();
            this.highUnits = cache.getHighUnits();
            this.name = name;
            this.niceName = niceCacheName;
            this.size = cache.getUnits();
            if (cache instanceof ExpiryCountingLocalCache) {
                ExpiryCountingLocalCache trackingCache = (ExpiryCountingLocalCache)cache;
                this.expiryCount = trackingCache.getExpiryCount();
            }
        }

        public String getNiceName() {
            return this.niceName;
        }

        public boolean hasContents() {
            return this.size > 0L;
        }

        public long getHitCount() {
            return this.stats.getCacheHits();
        }

        public long getNotFoundCount() {
            return this.stats.getCacheMisses();
        }

        public long getExpiredCount() {
            return this.expiryCount;
        }

        public long getAccessCount() {
            return this.stats.getTotalGets();
        }

        public long getMissCount() {
            return this.stats.getCacheMisses();
        }

        public int getHitPercent() {
            if (this.getAccessCount() == 0L) {
                return 0;
            }
            return (int)((float)this.getHitCount() / (float)this.getAccessCount() * 100.0f);
        }

        public int getUsagePercent() {
            if (this.getAccessCount() == 0L) {
                return 0;
            }
            return (int)((float)this.getSize() / (float)this.getMaxSize() * 100.0f);
        }

        public long getSize() {
            return this.size;
        }

        public long getMaxSize() {
            return this.highUnits;
        }

        public String getName() {
            return this.name;
        }
    }
}

