/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.admin.actions;

import com.atlassian.confluence.core.Administrative;
import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.velocity.htmlsafe.HtmlSafe;
import com.opensymphony.webwork.ServletActionContext;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class EditDefaultSpaceContentAction
extends ConfluenceActionSupport
implements Administrative {
    private SettingsManager settingsManager;
    private String content;
    private boolean personal;
    public static final String DEFAULT_HOMEPAGE_CONTENT = "This is the home page for the {0} space.";
    private String posted;
    private static final String LINK_SELECTED_STYLE = "paddedGreyDisabled";
    private static final String LINK_UNSELECTED_STYLE = "grey";
    private String actionPerformed;

    public String doDefault() throws Exception {
        this.content = this.personal ? this.settingsManager.getGlobalSettings().getDefaultPersonalSpaceHomepageContent() : this.settingsManager.getGlobalSettings().getDefaultSpaceHomepageContent();
        if (StringUtils.isEmpty((String)this.content)) {
            this.content = DEFAULT_HOMEPAGE_CONTENT;
        }
        return super.doDefault();
    }

    public String execute() throws Exception {
        String contentToSave = this.getText("save.word").equals(this.getActionPerformed()) && this.isContentChanged() ? this.getContent() : null;
        if (this.isPersonal()) {
            this.settingsManager.getGlobalSettings().setDefaultPersonalSpaceHomepageContent(contentToSave);
        } else {
            this.settingsManager.getGlobalSettings().setDefaultSpaceHomepageContent(contentToSave);
        }
        this.settingsManager.updateGlobalSettings(this.settingsManager.getGlobalSettings());
        return super.execute();
    }

    public List getHomePageLinks() {
        ArrayList<Link> result = new ArrayList<Link>();
        String contextPath = ServletActionContext.getRequest().getContextPath();
        Link editSpaceHome = new Link(this.isPersonal() ? LINK_UNSELECTED_STYLE : LINK_SELECTED_STYLE, contextPath + "/admin/editdefaultspacecontent.action", this.getText("edit.default.space.home"));
        Link editPersonalSpaceHome = new Link(this.isPersonal() ? LINK_SELECTED_STYLE : LINK_UNSELECTED_STYLE, contextPath + "/admin/editdefaultspacecontent.action?personal=true", this.getText("edit.default.personal.space.home"));
        result.add(editSpaceHome);
        result.add(editPersonalSpaceHome);
        return result;
    }

    private boolean isContentChanged() {
        String trimmed = StringUtils.trim((String)this.getContent());
        return !DEFAULT_HOMEPAGE_CONTENT.equals(trimmed);
    }

    public String getActionPerformed() {
        return this.actionPerformed;
    }

    public void setActionPerformed(String actionPerformed) {
        this.actionPerformed = actionPerformed;
    }

    public void setSettingsManager(SettingsManager settingsManager) {
        this.settingsManager = settingsManager;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public boolean isPersonal() {
        return this.personal;
    }

    public void setPersonal(boolean personal) {
        this.personal = personal;
    }

    public String getPosted() {
        return this.posted;
    }

    public void setPosted(String posted) {
        this.posted = posted;
    }

    public static class Link {
        private String clazz;
        private String href;
        private String label;

        public Link(String clazz, String href, String label) {
            this.clazz = clazz;
            this.href = href;
            this.label = label;
        }

        public String getClazz() {
            return this.clazz;
        }

        public String getHref() {
            return this.href;
        }

        @HtmlSafe
        public String getLabel() {
            return this.label;
        }
    }
}

