/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.admin.actions;

import com.atlassian.config.util.BootstrapUtils;
import com.atlassian.confluence.cluster.ClusterInformation;
import com.atlassian.confluence.cluster.ClusterManager;
import com.atlassian.confluence.status.service.SystemInformationService;
import com.atlassian.confluence.status.service.systeminfo.DatabaseInfo;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginInformation;
import com.atlassian.spring.container.ContainerManager;
import com.tangosol.util.UUID;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class SystemErrorInformationLogger {
    private final ServletContext servletContext;
    private final HttpServletRequest request;
    private final UUID uniqueID;
    private static final Logger log = Logger.getLogger(SystemErrorInformationLogger.class);

    public SystemErrorInformationLogger(UUID uuid, ServletContext servletContext, HttpServletRequest request) {
        this.servletContext = servletContext;
        this.request = request;
        this.uniqueID = uuid;
    }

    public void writeToLog() {
        StringBuffer output = new StringBuffer("Build Information\n");
        SystemInformationService sysInfoService = (SystemInformationService)ContainerManager.getInstance().getContainerContext().getComponent((Object)"systemInformationService");
        if (sysInfoService == null) {
            log.warn((Object)"No SystemInformationService could be retrieved from the Container.");
            output.append("Can't retrieve build information - no SystemInformationService available.\n");
        } else {
            Map buildStatsMap = GeneralUtil.convertBeanToMap(sysInfoService.getConfluenceInfo());
            buildStatsMap.remove("enabledPlugins");
            buildStatsMap.remove("startTime");
            this.writeMapToStringBuffer(buildStatsMap, output);
            output.append("Request Unique ID : " + this.uniqueID.toString() + "\n");
            output.append("Server Information:\n");
            this.appendParameter(output, "Application Server: ", this.servletContext.getServerInfo());
            output.append("Servlet Version:: " + this.servletContext.getMajorVersion() + "." + this.servletContext.getMinorVersion() + "\n");
            DatabaseInfo dbInfo = sysInfoService.getDatabaseInfo();
            this.appendParameter(output, "Database Dialect: ", dbInfo.getDialect());
            this.appendParameter(output, "Database Driver Name: ", dbInfo.getDriverName());
            this.appendParameter(output, "Database Driver Version: ", dbInfo.getDriverVersion());
            this.appendParameter(output, "Database Name: ", dbInfo.getName());
            this.appendParameter(output, "Database  Version: ", dbInfo.getVersion());
            this.appendParameter(output, "Database Latency:", dbInfo.getExampleLatency().toString());
            output.append("System Info\n");
            Map props = GeneralUtil.convertBeanToMap(sysInfoService.getSystemProperties());
            props.remove("enabledPlugins");
            props.remove("startTime");
            this.writeMapToStringBuffer(props, output);
            output.append("JVM Stats\n");
            Map jvmStats = GeneralUtil.convertBeanToMap(sysInfoService.getMemoryInfo());
            this.writeMapToStringBuffer(jvmStats, output);
        }
        if (BootstrapUtils.getBootstrapManager().getHibernateConfig().isHibernateSetup()) {
            output.append("Cluster Information:\n");
            try {
                ClusterManager clusterManager = (ClusterManager)ContainerManager.getComponent((String)"clusterManager");
                if (!clusterManager.isClustered()) {
                    output.append("Not clustered.\n");
                } else {
                    ClusterInformation clusterInformation = clusterManager.getClusterInformation();
                    this.appendParameter(output, "Name: ", clusterInformation.getName());
                    this.appendParameter(output, "Description: ", clusterInformation.getDescription());
                    output.append("Members: \n");
                    for (Object o : clusterInformation.getMembers()) {
                        output.append(o);
                    }
                }
            }
            catch (Throwable t) {
                output.append("Couldn't report cluster information:" + t);
            }
        }
        output.append("Enabled Plugins:\n");
        if (sysInfoService == null) {
            output.append("Can't retrieve plugin information - no SystemInformationService available.\n");
        } else {
            try {
                List<Plugin> enabledPlugins = sysInfoService.getConfluenceInfo().getEnabledPlugins();
                for (Plugin plugin : enabledPlugins) {
                    String pluginVersion;
                    PluginInformation pluginInfo = plugin.getPluginInformation();
                    String pluginName = plugin.getName();
                    String pluginKey = plugin.getKey();
                    if (pluginInfo == null) {
                        pluginVersion = "N/A";
                    } else {
                        pluginVersion = pluginInfo.getVersion();
                        if (pluginVersion == null) {
                            pluginVersion = "N/A";
                        }
                    }
                    output.append(pluginName + " (" + pluginKey + ", Version: " + pluginVersion + ")\n");
                }
            }
            catch (Exception e) {
                output.append("Couldn't report plugins:" + e);
            }
        }
        output.append("Request Information:\n");
        this.appendParameter(output, "URL: ", this.request.getRequestURL());
        this.appendParameter(output, "Scheme: ", this.request.getScheme());
        this.appendParameter(output, "Server: ", this.request.getServerName());
        this.appendParameter(output, "Port: ", this.request.getServerPort());
        this.appendParameter(output, "URI: ", this.request.getRequestURI());
        this.appendParameter(output, "Context Path: ", this.request.getContextPath());
        this.appendParameter(output, "Servlet Path: ", this.request.getServletPath());
        this.appendParameter(output, "Path Info: ", this.request.getPathInfo());
        this.appendParameter(output, "Query String: ", this.request.getQueryString());
        output.append("Attributes:\n");
        Enumeration attributeNames = this.request.getAttributeNames();
        while (attributeNames.hasMoreElements()) {
            String name = (String)attributeNames.nextElement();
            this.appendParameter(output, name + ": ", this.request.getAttribute(name));
        }
        output.append("Parameters:\n");
        Enumeration paramNames = this.request.getParameterNames();
        while (paramNames.hasMoreElements()) {
            String paramName = (String)paramNames.nextElement();
            String[] paramValues = this.request.getParameterValues(paramName);
            output.append(GeneralUtil.htmlEncode(paramName) + " : ");
            for (int i = 0; i < paramValues.length; ++i) {
                String paramValue = paramValues[i];
                output.append(GeneralUtil.htmlEncode(paramValue));
                if (i >= paramValues.length - 1) continue;
                output.append(", ");
            }
            output.append("\n");
        }
        log.info((Object)output);
    }

    private void appendParameter(StringBuffer output, String desc, Object value) {
        output.append(desc).append(value).append("\n");
    }

    private void appendParameter(StringBuffer output, String desc, int value) {
        output.append(desc).append(value).append("\n");
    }

    private void appendParameter(StringBuffer output, String paramDescription, String param) {
        output.append(paramDescription).append(param).append("\n");
    }

    private void writeMapToStringBuffer(Map buildStatsMap, StringBuffer output) {
        for (Map.Entry o : buildStatsMap.entrySet()) {
            this.appendParameter(output, o.getKey() + " = ", o.getValue());
        }
    }
}

