/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.admin.actions;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.buffer.CircularFifoBuffer;
import org.apache.log4j.Logger;
import org.apache.log4j.WriterAppender;
import org.apache.log4j.spi.LoggingEvent;

public class TestAppender
extends WriterAppender {
    private static final Logger log = Logger.getLogger(TestAppender.class);
    private Set enabledLoggers = new HashSet();
    private Map messagesByLogger = new HashMap();
    private static final int BUFFER_MAX_ITEMS = 100;

    public void enableLogger(String className) {
        this.enabledLoggers.add(className);
    }

    public void disableLogger(String className) {
        this.enabledLoggers.remove(className);
        this.messagesByLogger.remove(className);
    }

    public void append(LoggingEvent loggingEvent) {
        String logger = loggingEvent.getLoggerName();
        if (!this.enabledLoggers.contains(logger)) {
            return;
        }
        if (!this.messagesByLogger.containsKey(logger)) {
            this.messagesByLogger.put(logger, new CircularFifoBuffer(100));
        }
        CircularFifoBuffer buffer = (CircularFifoBuffer)this.messagesByLogger.get(logger);
        buffer.add((Object)this.layout.format(loggingEvent));
    }

    public String getLeastRecentMessageForLogger(String loggerName) {
        CircularFifoBuffer buffer = (CircularFifoBuffer)this.messagesByLogger.get(loggerName);
        if (buffer == null) {
            return null;
        }
        if (buffer.isEmpty()) {
            return null;
        }
        Object o = buffer.get();
        String s = o.toString();
        buffer.remove();
        return s;
    }
}

