/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.admin.actions;

import com.atlassian.config.ConfigurationException;
import com.atlassian.confluence.admin.actions.AbstractUpdateLicenseAction;
import com.atlassian.confluence.cluster.ClusterManager;
import com.atlassian.confluence.core.Administrative;
import com.atlassian.confluence.core.ConfluenceSidManager;
import com.atlassian.core.util.DateUtils;
import java.util.ResourceBundle;

public class ViewOrUpdateLicenseAction
extends AbstractUpdateLicenseAction
implements Administrative {
    private boolean restartReminder = false;
    private ClusterManager clusterManager;
    private ConfluenceSidManager sidManager;

    public String getServerId() throws ConfigurationException {
        return this.sidManager.getSid();
    }

    public String getExpiryTime() {
        if (this.getLicense() != null && this.getLicense().getExpiryDate() != null) {
            return DateUtils.dateDifference((long)System.currentTimeMillis(), (long)this.getLicense().getExpiryDate().getTime(), (long)2L, (ResourceBundle)this.getI18n().getResourceBundle());
        }
        return null;
    }

    public boolean isClusterLicense() {
        return this.getLicense().getPermittedClusteredNodes() > 0;
    }

    public boolean isClusterRunning() {
        return this.clusterManager.getClusterInformation().isRunning();
    }

    public int getActiveClusterNodeCount() {
        return this.clusterManager.getClusterInformation().getMemberCount();
    }

    public boolean isEvaluationLicense() {
        return this.getLicense() != null && this.getLicense().getExpiryDate() != null;
    }

    public boolean isRestartReminder() {
        return this.restartReminder;
    }

    public void setRestartReminder(boolean restartReminder) {
        this.restartReminder = restartReminder;
    }

    public void setClusterManager(ClusterManager clusterManager) {
        this.clusterManager = clusterManager;
    }

    public void setSidManager(ConfluenceSidManager sidManager) {
        this.sidManager = sidManager;
    }
}

