/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.admin.actions.cluster;

import com.atlassian.confluence.admin.actions.cluster.StartClusterTask;
import com.atlassian.confluence.cluster.ClusterConfigurationHelper;
import com.atlassian.confluence.cluster.ClusterManager;
import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.util.longrunning.LongRunningTaskUtils;
import com.atlassian.core.task.longrunning.LongRunningTask;
import com.atlassian.johnson.JohnsonEventContainer;
import com.atlassian.johnson.config.JohnsonConfig;
import com.atlassian.johnson.event.Event;
import com.opensymphony.webwork.ServletActionContext;
import javax.servlet.ServletContext;

public class StartClusterAction
extends ConfluenceActionSupport {
    private ClusterManager clusterManager;
    private String clusterName;
    private String networkInterface;
    private ClusterConfigurationHelper clusterConfigurationHelper;

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public void setClusterConfigurationHelper(ClusterConfigurationHelper clusterConfigurationHelper) {
        this.clusterConfigurationHelper = clusterConfigurationHelper;
    }

    public void setNetworkInterface(String networkInterface) {
        this.networkInterface = networkInterface;
    }

    public LongRunningTask getTask() {
        return LongRunningTaskUtils.retrieveTask();
    }

    public String execute() throws Exception {
        if (this.clusterManager.isClustered()) {
            this.addActionError("cluster.error.already.clustered", new String[]{this.clusterManager.getClusterInformation().getName()});
            return "error";
        }
        JohnsonEventContainer eventContainer = this.getJohnsonEventContainer();
        Event clusterMigrationEvent = new Event(JohnsonConfig.getInstance().getEventType("cluster-migration"), "Cluster migration in progress", JohnsonConfig.getInstance().getEventLevel("warning"));
        eventContainer.addEvent(clusterMigrationEvent);
        StartClusterTask task = new StartClusterTask(eventContainer, clusterMigrationEvent, this.clusterName, this.networkInterface, this.clusterConfigurationHelper, this.getI18n());
        LongRunningTaskUtils.startTask((LongRunningTask)task);
        return "success";
    }

    private JohnsonEventContainer getJohnsonEventContainer() {
        JohnsonEventContainer eventContainer = JohnsonEventContainer.get((ServletContext)ServletActionContext.getServletContext());
        if (eventContainer == null) {
            throw new RuntimeException("There was a problem retrieving the Johnson Event Container!");
        }
        return eventContainer;
    }

    public void setClusterManager(ClusterManager clusterManager) {
        this.clusterManager = clusterManager;
    }
}

