/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.admin.actions.debug;

import com.atlassian.confluence.core.Administrative;
import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.pages.CommentManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.spaces.SpaceType;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.hibernate.HibernateException;

public class BrowseCommentsAction
extends ConfluenceActionSupport
implements Administrative {
    CommentManager commentManager;
    SpaceManager spaceManager;
    List comments;
    List deleteCommentsList;

    public String execute() throws HibernateException, SQLException {
        int maxItems = 50;
        if (this.deleteCommentsList != null && this.deleteCommentsList.size() != 0) {
            for (int i = 0; i < this.deleteCommentsList.size(); ++i) {
                String commentString = (String)this.deleteCommentsList.get(i);
                this.commentManager.removeCommentFromPage(new Long(commentString));
            }
        }
        List spaces = this.spaceManager.getSpacesByType(SpaceType.GLOBAL);
        ArrayList<Comment> commentsList = new ArrayList<Comment>();
        for (int i = 0; i < spaces.size(); ++i) {
            Space space = (Space)spaces.get(i);
            if (space == null) continue;
            Iterator recentComments = this.commentManager.getRecentlyUpdatedComments(space, maxItems);
            while (recentComments.hasNext()) {
                Comment comment = (Comment)recentComments.next();
                commentsList.add(comment);
            }
            this.comments = commentsList;
        }
        return "success";
    }

    public void setCommentManager(CommentManager commentManager) {
        this.commentManager = commentManager;
    }

    public void setSpaceManager(SpaceManager spaceManager) {
        this.spaceManager = spaceManager;
    }

    public List getComments() {
        return this.comments;
    }

    public void setComments(List comments) {
        this.comments = comments;
    }

    public List getDeleteCommentsList() {
        return this.deleteCommentsList;
    }

    public void setDeleteCommentsList(List deleteCommentsList) {
        this.deleteCommentsList = deleteCommentsList;
    }
}

