/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.admin.actions.debug;

import com.atlassian.config.ApplicationConfiguration;
import com.atlassian.confluence.core.Administrative;
import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.util.FileNameEncodingTester;
import com.atlassian.confluence.util.SQLUtils;
import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;
import org.springframework.orm.hibernate.SessionFactoryUtils;

public class EncodingTestAction
extends ConfluenceActionSupport
implements Administrative {
    public static final String TEST_STRING = "I\u00f1t\u00ebrn\u00e2ti\u00f4n\u00e0liz\u00e6ti\u00f8n";
    public static final String TEST_STRING_CHANGED = "I\u00f1t\u00ebrn\u00e2ti\u00f4n\u00e0liz\u00e6ti\u00f9n";
    private String submittedTestString;
    private String databasedTestString;
    private String databasedLowercaseTestString;
    private String fileNameTestString;
    private SessionFactory sessionFactory;
    private FileNameEncodingTester fileNameEncodingTester;
    private ApplicationConfiguration applicationConfig;

    public boolean isFileCreatedSuccessfully() {
        return this.fileNameEncodingTester.isFileCreationSuccessful();
    }

    public Throwable getFileCreationException() {
        return this.fileNameEncodingTester.getFileCreationException();
    }

    public boolean isFileNameMangled() {
        return this.fileNameEncodingTester.isFileNameMangled();
    }

    public String getFileNameTestString() {
        return this.fileNameTestString;
    }

    public String getRawTestString() {
        return TEST_STRING;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String execute() throws HibernateException, SQLException {
        Session session = SessionFactoryUtils.getSession((SessionFactory)this.sessionFactory, (boolean)true);
        Connection conn = session.connection();
        long contentId = this.getUseableContentId(conn);
        long bodyContentId = this.getUseableBodyContentId(conn);
        try {
            this.createPage(conn, contentId, bodyContentId, this.submittedTestString.trim());
            this.databasedTestString = this.retrieveLowerDatabaseTestString(conn, contentId);
        }
        finally {
            this.deleteTestData(conn, contentId);
        }
        long contentTwoId = this.getUseableContentId(conn);
        long bodyContentTwoId = this.getUseableBodyContentId(conn);
        try {
            this.createPage(conn, contentTwoId, bodyContentTwoId, this.submittedTestString.trim());
            this.databasedLowercaseTestString = this.retrieveUpperDatabaseTestString(conn, contentTwoId);
        }
        finally {
            this.deleteTestData(conn, contentId);
        }
        File confluenceTemp = new File(this.getBootstrapManager().getFilePathProperty("webwork.multipart.saveDir"));
        this.fileNameEncodingTester = new FileNameEncodingTester(confluenceTemp);
        return "success";
    }

    public String getDefaultEncoding() {
        return this.getGlobalSettings().getDefaultEncoding();
    }

    private boolean isSqlServer() {
        return ((String)this.applicationConfig.getProperty((Object)"hibernate.dialect")).indexOf("SQLServer") != -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String retrieveLowerDatabaseTestString(Connection conn, long id) throws SQLException {
        String string;
        Statement ps = null;
        ResultSet rs = null;
        try {
            ps = conn.createStatement();
            rs = this.isSqlServer() ? ps.executeQuery("select LOWER(SUBSTRING(bc.BODY,1,DATALENGTH(bc.BODY))) from CONTENT c inner join BODYCONTENT bc on bc.CONTENTID = c.CONTENTID where c.CONTENTID = " + id) : ps.executeQuery("select LOWER(bc.BODY) from CONTENT c inner join BODYCONTENT bc on bc.CONTENTID = c.CONTENTID where c.CONTENTID = " + id);
            rs.next();
            string = rs.getString(1);
        }
        catch (Throwable throwable) {
            SQLUtils.closeResultSetQuietly(rs);
            throw throwable;
        }
        SQLUtils.closeResultSetQuietly(rs);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String retrieveUpperDatabaseTestString(Connection conn, long id) throws SQLException {
        String string;
        Statement ps = null;
        ResultSet rs = null;
        try {
            ps = conn.createStatement();
            rs = this.isSqlServer() ? ps.executeQuery("select UPPER(SUBSTRING(bc.BODY,1,DATALENGTH(bc.BODY))) from CONTENT c inner join BODYCONTENT bc on bc.CONTENTID = c.CONTENTID where c.CONTENTID = " + id) : ps.executeQuery("select UPPER(bc.BODY) from CONTENT c inner join BODYCONTENT bc on bc.CONTENTID = c.CONTENTID where c.CONTENTID = " + id);
            rs.next();
            string = rs.getString(1);
        }
        catch (Throwable throwable) {
            SQLUtils.closeResultSetQuietly(rs);
            throw throwable;
        }
        SQLUtils.closeResultSetQuietly(rs);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createPage(Connection conn, long id, long bodyId, String content) throws SQLException {
        PreparedStatement contentPs = null;
        PreparedStatement bodyContentPs = null;
        try {
            contentPs = conn.prepareStatement("insert into CONTENT (CONTENTID, CONTENTTYPE) values (?, ?)");
            contentPs.setLong(1, id);
            contentPs.setString(2, "CHEESE");
            contentPs.execute();
            bodyContentPs = conn.prepareStatement("insert into BODYCONTENT (BODYCONTENTID, BODY, CONTENTID) values (?, ?, ?)");
            bodyContentPs.setLong(1, bodyId);
            bodyContentPs.setString(2, content);
            bodyContentPs.setLong(3, id);
            bodyContentPs.execute();
            conn.commit();
        }
        catch (Throwable throwable) {
            SQLUtils.closeStatementQuietly(contentPs);
            SQLUtils.closeStatementQuietly(bodyContentPs);
            throw throwable;
        }
        SQLUtils.closeStatementQuietly(contentPs);
        SQLUtils.closeStatementQuietly(bodyContentPs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getUseableContentId(Connection conn) throws SQLException {
        long l;
        Statement statement = null;
        ResultSet rs = null;
        try {
            statement = conn.createStatement();
            rs = statement.executeQuery("select max(CONTENTID) from CONTENT");
            rs.next();
            l = rs.getLong(1) + 1000L;
        }
        catch (Throwable throwable) {
            SQLUtils.closeResultSetQuietly(rs);
            SQLUtils.closeStatementQuietly(statement);
            throw throwable;
        }
        SQLUtils.closeResultSetQuietly(rs);
        SQLUtils.closeStatementQuietly(statement);
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getUseableBodyContentId(Connection conn) throws SQLException {
        long l;
        Statement statement = null;
        ResultSet rs = null;
        try {
            statement = conn.createStatement();
            rs = statement.executeQuery("select max(BODYCONTENTID) from BODYCONTENT");
            rs.next();
            l = rs.getLong(1) + 1000L;
        }
        catch (Throwable throwable) {
            SQLUtils.closeStatementQuietly(statement);
            SQLUtils.closeResultSetQuietly(rs);
            throw throwable;
        }
        SQLUtils.closeStatementQuietly(statement);
        SQLUtils.closeResultSetQuietly(rs);
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteTestData(Connection conn, long contentId) throws SQLException {
        Statement statement = null;
        try {
            statement = conn.createStatement();
            statement.execute("delete from BODYCONTENT where CONTENTID = " + contentId);
            statement.execute("delete from CONTENT where CONTENTID = " + contentId);
        }
        finally {
            SQLUtils.closeStatementQuietly(statement);
        }
    }

    public String getSubmittedTestString() {
        return this.submittedTestString;
    }

    public void setSubmittedTestString(String submittedTestString) {
        this.submittedTestString = submittedTestString;
    }

    public String getDatabasedTestString() {
        return this.databasedTestString;
    }

    public void setDatabasedTestString(String databasedTestString) {
        this.databasedTestString = databasedTestString;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public String getDatabasedLowercaseTestString() {
        return this.databasedLowercaseTestString;
    }

    public void setApplicationConfig(ApplicationConfiguration applicationConfig) {
        this.applicationConfig = applicationConfig;
    }
}

