/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.admin.actions.languages;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.event.events.admin.GlobalSettingsChangedEvent;
import com.atlassian.confluence.languages.Language;
import com.atlassian.confluence.setup.settings.Settings;
import com.atlassian.event.Event;
import com.opensymphony.util.TextUtils;

public class ConfigureLanguageAction
extends ConfluenceActionSupport {
    private String globalDefaultLocale;

    public void validate() {
        Language language;
        if (TextUtils.stringSet((String)this.getGlobalDefaultLocale()) && (language = this.languageManager.getLanguage(this.getGlobalDefaultLocale())) != null && !language.isLicensed()) {
            this.addActionError(this.getText("language.not.licensed"));
        }
    }

    public String execute() throws Exception {
        Settings settings = this.settingsManager.getGlobalSettings();
        if (this.globalDefaultLocale == null) {
            this.globalDefaultLocale = settings.getGlobalDefaultLocale();
            boolean localeExists = false;
            for (Language language : this.getInstalledLanguages()) {
                if (!this.globalDefaultLocale.equals(language.getName())) continue;
                localeExists = true;
                break;
            }
            if (!localeExists) {
                this.globalDefaultLocale = "en_GB";
                this.updateLocale(settings, this.globalDefaultLocale);
            }
        } else if (!this.globalDefaultLocale.equals(settings.getGlobalDefaultLocale())) {
            this.updateLocale(settings, this.globalDefaultLocale);
        }
        return super.execute();
    }

    private void updateLocale(Settings settings, String newLocale) {
        Settings originalSettings = this.settingsManager.getGlobalSettings();
        settings.setGlobalDefaultLocale(newLocale);
        this.settingsManager.updateGlobalSettings(settings);
        GlobalSettingsChangedEvent event = new GlobalSettingsChangedEvent(this, originalSettings, this.settingsManager.getGlobalSettings(), this.settingsManager.getGlobalSettings().getBaseUrl(), this.settingsManager.getGlobalSettings().getBaseUrl());
        this.eventManager.publishEvent((Event)event);
    }

    public String getGlobalDefaultLocale() {
        return this.globalDefaultLocale;
    }

    public void setGlobalDefaultLocale(String globalDefaultLocale) {
        this.globalDefaultLocale = globalDefaultLocale;
    }

    public String getGlobalDefaultLocaleUserFriendly() {
        return this.getLanguageUserFriendly(this.globalDefaultLocale);
    }

    public boolean isCurrentGlobalLocale(String locale) {
        if (this.globalDefaultLocale == null) {
            return false;
        }
        return this.globalDefaultLocale.equals(locale);
    }
}

