/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.admin.actions.lookandfeel;

import com.atlassian.confluence.admin.actions.lookandfeel.AbstractLookAndFeelAction;
import com.atlassian.confluence.plugin.descriptor.ThemeModuleDescriptor;
import com.atlassian.confluence.util.LayoutHelper;
import com.opensymphony.util.TextUtils;
import java.util.List;

public abstract class AbstractThemeAction
extends AbstractLookAndFeelAction {
    protected String themeKey;

    public void setThemeKey(String themeKey) {
        this.themeKey = themeKey;
    }

    public String getThemeKey() {
        return this.themeKey;
    }

    public List getAvailableThemeDescriptors() {
        return this.themeManager.getAvailableThemeDescriptors();
    }

    public void validate() {
        super.validate();
        if (TextUtils.stringSet((String)this.themeKey) && this.layoutHelper.findThemeDescriptor(this.themeKey) == null) {
            this.addActionError(this.getText("theme.not.found", new String[]{this.themeKey}));
        }
    }

    public String execute() {
        if (this.themeKey != null) {
            this.setTheme(this.themeKey);
            LayoutHelper.flushThemeComponents(this.getSpaceKey());
        }
        return "success";
    }

    protected abstract void setTheme(String var1);

    public ThemeModuleDescriptor getCurrentThemeDescriptor() {
        if (TextUtils.stringSet((String)this.getCurrentThemeKey())) {
            return this.layoutHelper.findThemeDescriptor(this.getCurrentThemeKey());
        }
        return null;
    }

    public boolean hasIcon(ThemeModuleDescriptor descriptor) {
        return this.layoutHelper.hasIcon(descriptor);
    }

    protected abstract String getCurrentThemeKey();

    protected abstract String getConfigPath(ThemeModuleDescriptor var1);
}

