/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.admin.actions.lookandfeel;

import com.atlassian.confluence.admin.actions.LookAndFeel;
import com.atlassian.confluence.admin.actions.lookandfeel.AbstractDecoratorAction;
import com.opensymphony.util.TextUtils;
import java.io.BufferedReader;
import java.io.StringReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ViewDefaultDecoratorAction
extends AbstractDecoratorAction
implements LookAndFeel {
    private static final String HTML_QUOTE = "&quot;";

    public String execute() throws Exception {
        String s;
        String template = this.readDefaultTemplate();
        if (template == null) {
            this.addActionError(this.getText("template.not.found", new String[]{this.decoratorName}));
            return "success";
        }
        BufferedReader br = new BufferedReader(new StringReader(template));
        String decoratorSource = "";
        while ((s = br.readLine()) != null) {
            decoratorSource = decoratorSource + this.getIndent(s) + TextUtils.htmlEncode((String)s) + "<br/>";
        }
        this.setContent(this.linkIncludes(decoratorSource));
        return "success";
    }

    private String getIndent(String s) {
        String indent = "";
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) != ' ') {
                return indent;
            }
            indent = indent + "&nbsp;";
        }
        return indent;
    }

    private String linkIncludes(String source) {
        Pattern p = Pattern.compile("#parse \\(.*?\\)");
        Matcher m = p.matcher(source);
        StringBuffer sb = new StringBuffer();
        boolean result = m.find();
        while (result) {
            String includePath;
            String match = m.group();
            int includePathStart = match.indexOf(HTML_QUOTE) + HTML_QUOTE.length();
            int includePathEnd = match.lastIndexOf(HTML_QUOTE);
            String shortIncludePath = includePath = match.substring(includePathStart, includePathEnd);
            m.appendReplacement(sb, "#parse (&quot;<a href='viewdefaultdecorator.action?decoratorName=" + shortIncludePath + (this.key == null ? "" : "&key=" + this.key) + "'>" + includePath + "</a>&quot;)");
            result = m.find();
        }
        m.appendTail(sb);
        return sb.toString();
    }

    public String getFileName() {
        int i = this.decoratorName.lastIndexOf("/");
        if (i != -1) {
            return this.decoratorName.substring(i + 1);
        }
        return this.decoratorName;
    }
}

