/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.admin.actions.macros;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.util.JiraIconMappingManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class RemoveJiraIssuesMacroIconMappingsAction
extends ConfluenceActionSupport {
    private static final Logger log = Logger.getLogger(RemoveJiraIssuesMacroIconMappingsAction.class);
    private JiraIconMappingManager jiraIconMappingManager;
    private List entitiesToRemove = new ArrayList();

    public String execute() {
        for (String entity : this.entitiesToRemove) {
            log.info((Object)("Removing " + entity));
            this.jiraIconMappingManager.removeIconMapping(entity);
        }
        return "success";
    }

    public void validate() {
        super.validate();
        if (this.entitiesToRemove.isEmpty()) {
            this.addActionError(this.getText("icon.mappings.none.selected"));
        }
    }

    public Map getIconMappings() {
        return this.jiraIconMappingManager.getIconMappings();
    }

    public void setJiraIconMappingManager(JiraIconMappingManager jiraIconMappingManager) {
        this.jiraIconMappingManager = jiraIconMappingManager;
    }

    public void setEntitiesToRemove(List entitiesToRemove) {
        this.entitiesToRemove.clear();
        this.entitiesToRemove.addAll(entitiesToRemove);
    }
}

