/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.admin.actions.macros;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.renderer.UserMacroConfig;
import com.atlassian.confluence.renderer.UserMacroLibrary;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.core.util.PairType;
import com.opensymphony.util.TextUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class UserMacroAction
extends ConfluenceActionSupport {
    private List outputTypes;
    private List bodyTypes;
    private UserMacroConfig userMacro;
    private UserMacroLibrary userMacroLibrary;
    private String originalName;
    private String macro;

    public UserMacroConfig getUserMacro() {
        return this.userMacro;
    }

    public String getOriginalName() {
        return this.originalName;
    }

    public void setOriginalName(String originalName) {
        this.originalName = originalName;
    }

    public void setUserMacro(UserMacroConfig userMacro) {
        this.userMacro = userMacro;
    }

    public UserMacroLibrary getUserMacros() {
        return this.userMacroLibrary;
    }

    public String doAdd() {
        this.userMacroLibrary.addUpdateMacro(this.userMacro);
        return "success";
    }

    public String doUpdate() {
        if (TextUtils.stringSet((String)this.originalName)) {
            this.userMacroLibrary.removeMacro(this.originalName);
        }
        this.userMacroLibrary.addUpdateMacro(this.userMacro);
        return "success";
    }

    public String doRemove() {
        this.userMacroLibrary.removeMacro(this.macro);
        return "success";
    }

    public String doDefault() throws Exception {
        if (TextUtils.stringSet((String)this.macro)) {
            this.originalName = this.macro;
            this.userMacro = this.userMacroLibrary.getMacro(this.macro);
        } else {
            this.userMacro = new UserMacroConfig();
            this.userMacro.setHasBody(true);
        }
        return super.doDefault();
    }

    public void setUserMacroLibrary(UserMacroLibrary userMacroLibrary) {
        this.userMacroLibrary = userMacroLibrary;
    }

    public void setMacro(String macro) {
        this.macro = macro;
    }

    public List getOutputTypes() {
        if (this.outputTypes == null) {
            ArrayList<PairType> myOutputTypes = new ArrayList<PairType>();
            myOutputTypes.add(new PairType((Serializable)((Object)"html"), (Serializable)((Object)this.getText("user.macro.output.type.html"))));
            myOutputTypes.add(new PairType((Serializable)((Object)"wiki"), (Serializable)((Object)this.getText("user.macro.output.type.wiki"))));
            this.outputTypes = Collections.unmodifiableList(myOutputTypes);
        }
        return this.outputTypes;
    }

    public List getBodyTypes() {
        if (this.bodyTypes == null) {
            ArrayList<PairType> myOutputTypes = new ArrayList<PairType>();
            myOutputTypes.add(new PairType((Serializable)((Object)"raw"), (Serializable)((Object)this.getText("user.macro.body.type.raw"))));
            myOutputTypes.add(new PairType((Serializable)((Object)"escapehtml"), (Serializable)((Object)this.getText("user.macro.body.type.htmlescape"))));
            myOutputTypes.add(new PairType((Serializable)((Object)"rendered"), (Serializable)((Object)this.getText("user.macro.body.type.rendered"))));
            this.bodyTypes = Collections.unmodifiableList(myOutputTypes);
        }
        return this.bodyTypes;
    }

    public boolean isPermitted() {
        return this.permissionManager.hasPermission(this.getRemoteUser(), Permission.ADMINISTER, PermissionManager.TARGET_SYSTEM);
    }
}

