/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.admin.actions.mail;

import com.atlassian.confluence.event.events.admin.MailServerEditEvent;
import com.atlassian.confluence.setup.actions.AbstractSetupEmailAction;
import com.atlassian.event.Event;
import com.atlassian.mail.server.MailServer;
import com.atlassian.mail.server.SMTPMailServer;
import com.opensymphony.util.TextUtils;
import org.apache.commons.lang.StringUtils;

public class EditSmtpMailServerAction
extends AbstractSetupEmailAction {
    public String doDefault() throws Exception {
        SMTPMailServer smtpMailServer = (SMTPMailServer)this.getMailServerManager().getMailServer(this.getId());
        this.setName(smtpMailServer.getName());
        this.setFrom(smtpMailServer.getDefaultFrom());
        this.setPrefix(smtpMailServer.getPrefix());
        this.setHostname(smtpMailServer.getHostname() + ":" + smtpMailServer.getSmtpPort());
        this.setUserName(smtpMailServer.getUsername());
        this.setPassword(smtpMailServer.getPassword());
        this.setJndiName(smtpMailServer.getJndiLocation());
        return "input";
    }

    public String execute() throws Exception {
        SMTPMailServer smtpMailServer = (SMTPMailServer)this.getMailServerManager().getMailServer(this.getId());
        String originalName = smtpMailServer.getName();
        smtpMailServer.setName(this.getName());
        smtpMailServer.setDefaultFrom(this.getFrom());
        smtpMailServer.setPrefix(this.getPrefix());
        if (TextUtils.stringSet((String)this.getJndiName())) {
            smtpMailServer.setJndiLocation(this.getJndiName());
            smtpMailServer.setSessionServer(true);
            smtpMailServer.setHostname(null);
        } else if (StringUtils.isNotBlank((String)this.getHostname())) {
            String[] hostNameParts = this.getHostnameAndPort();
            smtpMailServer.setHostname(hostNameParts[0]);
            smtpMailServer.setSmtpPort(hostNameParts.length > 1 ? hostNameParts[1] : "25");
            smtpMailServer.setSessionServer(false);
            smtpMailServer.setJndiLocation(null);
        }
        smtpMailServer.setUsername(this.getUserName());
        smtpMailServer.setPassword(this.getPassword());
        this.getMailServerManager().update((MailServer)smtpMailServer);
        this.eventManager.publishEvent((Event)new MailServerEditEvent(this, (MailServer)smtpMailServer, originalName));
        return "success";
    }
}

