/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.admin.actions.plugins;

import com.atlassian.confluence.admin.actions.plugins.ManagePluginsAction;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.xwork.FileUploadUtils;
import com.opensymphony.webwork.ServletActionContext;
import com.opensymphony.webwork.dispatcher.multipart.MultiPartRequestWrapper;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class UploadPluginAction
extends ManagePluginsAction {
    private static final Logger log = Logger.getLogger(UploadPluginAction.class);

    public void validate() {
        HttpServletRequest request = ServletActionContext.getRequest();
        if (request == null || !(request instanceof MultiPartRequestWrapper)) {
            this.addActionError(this.getText("error.could.not.identify.plugin"));
            return;
        }
        this.updateSelectedPlugin();
    }

    public String execute() throws Exception {
        if (log.isInfoEnabled()) {
            log.info((Object)("Upload Plugin operation attempted by " + this.getRemoteUser() + "."));
        }
        if (ServletActionContext.getRequest() instanceof MultiPartRequestWrapper) {
            return this.handleUploadedFile((MultiPartRequestWrapper)ServletActionContext.getRequest());
        }
        return "input";
    }

    private String handleUploadedFile(MultiPartRequestWrapper multiWrapper) {
        FileUploadUtils.UploadedFile uploadedPlugin;
        try {
            uploadedPlugin = this.getUploadedPlugin(multiWrapper);
        }
        catch (FileUploadUtils.FileUploadException e) {
            String[] errors = e.getErrors();
            for (int j = 0; j < errors.length; ++j) {
                this.addActionError(GeneralUtil.getUploadFileTooLargeMessage(e.getErrors()[j]));
            }
            return "error";
        }
        if (uploadedPlugin == null) {
            this.addActionError(this.getText("error.could.not.identify.plugin"));
            return "error";
        }
        try {
            this.setPluginKey(this.installPlugin(uploadedPlugin.getFile(), uploadedPlugin.getFileName()));
        }
        catch (PluginParseException e) {
            log.warn((Object)"Error occurred installing plugin", (Throwable)e);
            this.addActionError(this.getText("error.uploading.plugin") + " " + (Object)((Object)e));
            return "error";
        }
        return "success";
    }

    private FileUploadUtils.UploadedFile getUploadedPlugin(MultiPartRequestWrapper multiWrapper) throws FileUploadUtils.FileUploadException {
        FileUploadUtils.UploadedFile[] uploadedFiles = FileUploadUtils.handleFileUpload((MultiPartRequestWrapper)multiWrapper, (boolean)true);
        FileUploadUtils.UploadedFile uploadedPlugin = null;
        if (uploadedFiles.length > 0) {
            uploadedPlugin = uploadedFiles[0];
        }
        return uploadedPlugin;
    }

    public long getUploadLimit() {
        return this.settingsManager.getGlobalSettings().getAttachmentMaxSize() / 1000000L;
    }

    public boolean isPermitted() {
        return this.permissionManager.hasPermission(this.getRemoteUser(), Permission.ADMINISTER, PermissionManager.TARGET_SYSTEM);
    }
}

