/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.cache.jcaptcha;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheFactory;
import com.octo.captcha.Captcha;
import com.octo.captcha.service.CaptchaServiceException;
import com.octo.captcha.service.captchastore.CaptchaAndLocale;
import com.octo.captcha.service.captchastore.CaptchaStore;
import java.util.Collection;
import java.util.Locale;
import org.apache.log4j.Category;

public class ConfluenceCachingCaptchaStore
implements CaptchaStore {
    private static final Category log = Category.getInstance(ConfluenceCachingCaptchaStore.class);
    private static final String CACHE_NAME = "com.atlassian.confluence.cache.jcaptcha.ConfluenceCachingCaptchaStore";
    protected CacheFactory cacheFactory;

    public void setCacheFactory(CacheFactory cacheFactory) {
        this.cacheFactory = cacheFactory;
    }

    public boolean hasCaptcha(String id) {
        return this.getCache().get((Object)id) != null;
    }

    public void storeCaptcha(String id, Captcha captcha) throws CaptchaServiceException {
        this.storeCaptcha(id, captcha, Locale.getDefault());
    }

    public void storeCaptcha(String id, Captcha captcha, Locale locale) throws CaptchaServiceException {
        if (this.hasCaptcha(id)) {
            throw new CaptchaServiceException("Captcha already exists for id: " + id);
        }
        try {
            this.getCache().put((Object)id, (Object)new CaptchaAndLocale(captcha, locale));
        }
        catch (Exception e) {
            throw new CaptchaServiceException("Error storing captcha against id: " + id, (Throwable)e);
        }
    }

    public Captcha getCaptcha(String id) throws CaptchaServiceException {
        CaptchaAndLocale captchaAndLocale;
        try {
            captchaAndLocale = (CaptchaAndLocale)this.getCache().get((Object)id);
        }
        catch (Exception e) {
            throw new CaptchaServiceException("Error retrieving captcha for id: " + id, (Throwable)e);
        }
        if (captchaAndLocale == null) {
            return null;
        }
        return captchaAndLocale.getCaptcha();
    }

    public Locale getLocale(String id) throws CaptchaServiceException {
        CaptchaAndLocale captchaAndLocale;
        try {
            captchaAndLocale = (CaptchaAndLocale)this.getCache().get((Object)id);
        }
        catch (Exception e) {
            throw new CaptchaServiceException("Error retrieving locale for id: " + id, (Throwable)e);
        }
        if (captchaAndLocale == null) {
            return null;
        }
        return captchaAndLocale.getLocale();
    }

    public boolean removeCaptcha(String id) {
        if (!this.hasCaptcha(id)) {
            return false;
        }
        try {
            this.getCache().remove((Object)id);
            return true;
        }
        catch (Exception e) {
            throw new CaptchaServiceException("Error removing captcha for id: " + id, (Throwable)e);
        }
    }

    public int getSize() {
        return this.getCache().getKeys().size();
    }

    public Collection getKeys() {
        return this.getCache().getKeys();
    }

    public void empty() {
        try {
            this.getCache().removeAll();
        }
        catch (Exception e) {
            log.error((Object)"Error clearing cache", (Throwable)e);
        }
    }

    protected Cache getCache() {
        return this.cacheFactory.getCache(CACHE_NAME);
    }
}

