/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.cache.tangosol;

import com.atlassian.confluence.cache.CacheConfigurationLoader;
import com.atlassian.confluence.util.io.IOUtils;
import com.atlassian.core.util.ClassLoaderUtils;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.ConfigurableCacheFactory;
import com.tangosol.net.DefaultConfigurableCacheFactory;
import com.tangosol.run.xml.XmlDocument;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.run.xml.XmlHelper;
import java.io.InputStream;
import java.net.URL;
import org.apache.log4j.Category;

public class TangosolCacheConfigurationLoader
implements CacheConfigurationLoader {
    private static Category log = Category.getInstance(TangosolCacheConfigurationLoader.class);
    public static final String CONFIG_BASE = "confluence-coherence-cache-config";
    public static final String CONFIG_CLUSTERED = "confluence-coherence-cache-config-clustered";
    protected String standardConfig = "confluence-coherence-cache-config.xml";
    protected String clusteredConfig = "confluence-coherence-cache-config-clustered.xml";

    public void loadConfiguration(boolean clustered) {
        ConfigurableCacheFactory cacheFactory = CacheFactory.getConfigurableCacheFactory();
        String configFile = clustered ? this.clusteredConfig : this.standardConfig;
        this.loadConfigurationFile(configFile, cacheFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadConfigurationFile(String configFile, ConfigurableCacheFactory cacheFactory) {
        if (log.isDebugEnabled()) {
            URL cacheConfigUrl = ClassLoaderUtils.getResource((String)configFile, TangosolCacheConfigurationLoader.class);
            log.debug((Object)("Using cache configuration: " + cacheConfigUrl));
        }
        InputStream is = null;
        try {
            is = ClassLoaderUtils.getResourceAsStream((String)configFile, TangosolCacheConfigurationLoader.class);
            if (is == null) {
                throw new RuntimeException("Couldn't find '" + configFile + "' in classpath");
            }
            XmlDocument cacheConfig = XmlHelper.loadXml((InputStream)is);
            cacheFactory = new DefaultConfigurableCacheFactory((XmlElement)cacheConfig);
            CacheFactory.setConfigurableCacheFactory((ConfigurableCacheFactory)cacheFactory);
        }
        finally {
            IOUtils.close(is);
        }
    }

    public void setStandardConfig(String standardConfig) {
        this.standardConfig = standardConfig;
    }

    public void setClusteredConfig(String clusteredConfig) {
        this.clusteredConfig = clusteredConfig;
    }
}

