/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.cache.tangosol;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheManager;
import com.atlassian.confluence.cache.tangosol.TangosolCache;
import com.atlassian.confluence.cache.tangosol.TangosolCacheFactory;
import com.atlassian.confluence.cluster.tangosol.TangosolClusterManager;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.CacheService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class TangosolCacheManager
implements CacheManager {
    public static final String LOCAL_PREFIX = "local.";
    public static final String LOCAL_EVICTED_PREFIX = "local.evicted.";
    private Set nonFlushableCaches = Collections.EMPTY_SET;
    private ClassLoader classLoader = ClassLoader.getSystemClassLoader();
    private TangosolCacheFactory tangosolCacheFactory;

    public Cache getCache(String cacheName) {
        return new TangosolCache(this.tangosolCacheFactory.getCache(cacheName, this.classLoader));
    }

    public Collection getCaches() {
        ArrayList caches = new ArrayList();
        Iterator cacheServices = TangosolClusterManager.enumerateCacheServices().iterator();
        while (cacheServices.hasNext()) {
            caches.addAll(this.getCaches((CacheService)cacheServices.next()));
        }
        return caches;
    }

    private Collection getCaches(CacheService cacheService) {
        ArrayList<Cache> caches = new ArrayList<Cache>();
        Enumeration cacheNames = cacheService.getCacheNames();
        while (cacheNames.hasMoreElements()) {
            caches.add(this.getCache((String)cacheNames.nextElement()));
        }
        return caches;
    }

    public void flushCaches() {
        Collection cacheServices = TangosolClusterManager.enumerateCacheServices();
        Iterator serviceIter = cacheServices.iterator();
        while (serviceIter.hasNext()) {
            this.flushCacheService((CacheService)serviceIter.next());
        }
    }

    public void flushCacheService(CacheService service) {
        Enumeration cacheNames = service.getCacheNames();
        while (cacheNames.hasMoreElements()) {
            String cacheName = (String)cacheNames.nextElement();
            if (this.nonFlushableCaches.contains(cacheName)) continue;
            CacheFactory.getCache((String)cacheName).clear();
        }
    }

    public void setNonFlushableCaches(List list) {
        this.nonFlushableCaches = new HashSet(list);
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void setTangosolCacheFactory(TangosolCacheFactory tangosolCacheFactory) {
        this.tangosolCacheFactory = tangosolCacheFactory;
    }
}

