/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.cluster;

import com.atlassian.config.ApplicationConfig;
import com.atlassian.config.ApplicationConfiguration;
import com.atlassian.config.ConfigurationException;
import com.atlassian.confluence.cache.CacheConfigurationLoader;
import com.atlassian.confluence.cluster.AlreadyClusteredException;
import com.atlassian.confluence.cluster.ClusterAlreadyExistsException;
import com.atlassian.confluence.cluster.ClusterConfig;
import com.atlassian.confluence.cluster.ClusterConfigurationHelper;
import com.atlassian.confluence.cluster.ClusterException;
import com.atlassian.confluence.cluster.ClusterInvariants;
import com.atlassian.confluence.cluster.ClusterLicenseExceededException;
import com.atlassian.confluence.cluster.ClusterManager;
import com.atlassian.confluence.cluster.ClusterNotPermittedException;
import com.atlassian.confluence.cluster.InvalidClusterAddressException;
import com.atlassian.confluence.cluster.NoSuchClusterException;
import com.atlassian.confluence.cluster.tangosol.invocations.GetClusterInvariants;
import com.atlassian.confluence.setup.SharedConfigurationMap;
import com.atlassian.confluence.util.ClusterUtils;
import com.atlassian.confluence.util.MulticastRouteTester;
import com.atlassian.license.LicenseManager;
import com.tangosol.net.Invocable;
import com.tangosol.net.InvocationService;
import com.tangosol.net.Member;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.IteratorUtils;
import org.apache.log4j.Category;

public class DefaultClusterConfigurationHelper
implements ClusterConfigurationHelper {
    private static final Category log = Category.getInstance(DefaultClusterConfigurationHelper.class);
    public static final String CLUSTER = "confluence.cluster";
    public static final String CLUSTER_NAME = "confluence.cluster.name";
    public static final String CLUSTER_ADDRESS = "confluence.cluster.address";
    public static final String CLUSTER_INTERFACE = "confluence.cluster.interface";
    public static final String CLUSTER_TTL = "confluence.cluster.ttl";
    private ClusterManager clusterManager;
    private ApplicationConfig applicationConfig;
    private CacheConfigurationLoader cacheConfigLoader;
    private static final int MULTICAST_TEST_PORT = 33333;

    public boolean isClusteredInstance() {
        return this.clusterManager.isClustered();
    }

    public boolean isLicensedClusterNodesExceeded() {
        return this.clusterManager.getClusterInformation().getMemberCount() > this.getPermittedClusterNodes();
    }

    public void joinCluster(String clusterName) throws ClusterException {
        this.joinCluster(clusterName, null);
    }

    public void joinCluster(String clusterName, String networkInterfaceName) throws ClusterException {
        if (this.getPermittedClusterNodes() <= 0) {
            throw new ClusterNotPermittedException();
        }
        NetworkInterface networkInterface = this.getNetworkInterfaceByName(networkInterfaceName);
        InetAddress addr = this.clusterManager.resolveName(clusterName);
        this.checkInterfaceMulticastRouting(addr, networkInterface);
        try {
            ClusterConfig config = new ClusterConfig(addr, clusterName, 1, networkInterface);
            this.joinCluster(config);
        }
        catch (ClusterException e) {
            this.clusterManager.stopCluster();
            throw e;
        }
        this.performClusterSanityCheck();
    }

    private void checkInterfaceMulticastRouting(InetAddress addr, NetworkInterface networkInterface) {
        MulticastRouteTester tester = new MulticastRouteTester(addr, networkInterface, 33333);
        tester.run();
    }

    private void joinCluster(ClusterConfig config) throws ClusterException {
        if (log.isInfoEnabled()) {
            log.info((Object)("Joining cluster with configuration" + config));
        }
        this.clusterManager.reconfigure(config);
        if (this.clusterManager.getClusterInformation().getMemberCount() < 2) {
            throw new NoSuchClusterException(config.getClusterName(), config.getAddress());
        }
        if (this.isLicensedClusterNodesExceeded()) {
            throw new ClusterLicenseExceededException(config.getClusterName(), config.getAddress(), this.getPermittedClusterNodes());
        }
        this.setClusterConfig(config);
        this.cacheConfigLoader.loadConfiguration(this.isClusteredInstance());
    }

    public void createCluster(String clusterName) throws ClusterException {
        this.createCluster(clusterName, null);
    }

    public void createCluster(String clusterName, String networkInterfaceName) throws ClusterException {
        if (this.isClusteredInstance()) {
            throw new AlreadyClusteredException(this.clusterManager.getClusterInformation());
        }
        if (this.getPermittedClusterNodes() <= 0) {
            throw new ClusterNotPermittedException();
        }
        NetworkInterface networkInterface = this.getNetworkInterfaceByName(networkInterfaceName);
        InetAddress addr = this.clusterManager.resolveName(clusterName);
        this.checkInterfaceMulticastRouting(addr, networkInterface);
        try {
            ClusterConfig config = new ClusterConfig(addr, clusterName, 1, networkInterface);
            this.createCluster(config);
        }
        catch (ClusterException e) {
            this.clusterManager.stopCluster();
            throw e;
        }
    }

    private void createCluster(ClusterConfig config) throws ClusterException {
        if (log.isInfoEnabled()) {
            log.info((Object)("Creating new cluster with configuration " + config));
        }
        this.clusterManager.reconfigure(config);
        if (this.clusterManager.getClusterInformation().getMemberCount() >= 2) {
            throw new ClusterAlreadyExistsException(config.getClusterName(), config.getAddress());
        }
        this.setClusterConfig(config);
        this.cacheConfigLoader.loadConfiguration(this.isClusteredInstance());
    }

    private NetworkInterface getNetworkInterfaceByName(String networkInterfaceName) {
        NetworkInterface networkInterface = null;
        if (networkInterfaceName != null) {
            try {
                networkInterface = NetworkInterface.getByName(networkInterfaceName);
            }
            catch (SocketException e) {
                throw new RuntimeException("Could not get network interface '" + networkInterfaceName + "'", e);
            }
        }
        return networkInterface;
    }

    public void bootstrapCluster() throws ClusterException {
        if (this.isClusteredInstance()) {
            this.clusterManager.reconfigure(this.getClusterConfig());
        } else {
            this.clusterManager.configure(this.getPrivateClusterConfig());
        }
        this.cacheConfigLoader.loadConfiguration(this.isClusteredInstance());
        if (this.isClusteredInstance() && this.isLicensedClusterNodesExceeded()) {
            String message = "This licence only allows " + this.getPermittedClusterNodes() + " nodes in the cluster. This would be exceeded if this node joined.";
            throw new ClusterException(message);
        }
        if (this.isClusteredInstance()) {
            this.performClusterSanityCheck();
        }
    }

    private void performClusterSanityCheck() throws ClusterException {
        ClusterInvariants ourInvariants = new ClusterInvariants();
        ClusterInvariants clusterInvariants = this.getClusterInvariants();
        if (clusterInvariants != null && !ourInvariants.equals(clusterInvariants)) {
            throw new ClusterException(ourInvariants.getDifferenceExplanation(clusterInvariants));
        }
    }

    private ClusterInvariants getClusterInvariants() throws ClusterException {
        InvocationService service = this.clusterManager.getInvocationService();
        Member memberThis = service.getCluster().getLocalMember();
        Set setMembers = service.getInfo().getServiceMembers();
        setMembers.remove(memberThis);
        if (setMembers.size() == 0) {
            return null;
        }
        Map mapResult = service.query((Invocable)new GetClusterInvariants(), setMembers);
        Iterator iter = mapResult.keySet().iterator();
        if (iter.hasNext()) {
            Member member = (Member)iter.next();
            ClusterInvariants result = (ClusterInvariants)mapResult.get(member);
            return result;
        }
        throw new ClusterException("Failed to get build number from cluster.");
    }

    public int getPermittedClusterNodes() {
        int nodesAllowed = LicenseManager.getInstance().getLicense("CONF").getPermittedClusteredNodes();
        if (nodesAllowed == 0) {
            nodesAllowed = 1;
        }
        return nodesAllowed;
    }

    public void publishConfiguration() {
        this.clusterManager.publishObject("sharedConfig", new SharedConfigurationMap((ApplicationConfiguration)this.applicationConfig));
    }

    public List getClusterableInterfaces() {
        List interfaces = null;
        try {
            interfaces = IteratorUtils.toList((Iterator)ClusterUtils.getClusterableInterfaces());
        }
        catch (SocketException e) {
            throw new RuntimeException("Exception while enumerating network interfaces", e);
        }
        Collections.sort(interfaces, new AlphabeticalInterfacesWithLoopbackLast());
        return interfaces;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setClusterConfig(ClusterConfig config) throws ClusterException {
        ApplicationConfig applicationConfig = this.applicationConfig;
        synchronized (applicationConfig) {
            this.applicationConfig.setProperty((Object)CLUSTER, (Object)"true");
            this.applicationConfig.setProperty((Object)CLUSTER_NAME, (Object)config.getClusterName());
            this.applicationConfig.setProperty((Object)CLUSTER_ADDRESS, (Object)config.getAddress().getHostAddress());
            this.applicationConfig.setProperty((Object)CLUSTER_TTL, (Object)new Integer(config.getTimeToLive()));
            if (config.getNetworkInterface() != null) {
                this.applicationConfig.setProperty((Object)CLUSTER_INTERFACE, (Object)config.getNetworkInterface().getName());
            }
            try {
                this.applicationConfig.save();
            }
            catch (ConfigurationException e) {
                throw new ClusterException("Could not save new cluster settings: " + e.getMessage(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClusterConfig getClusterConfig() throws InvalidClusterAddressException {
        String clusterName;
        String ttl;
        String address;
        String clusterInterfaceName = null;
        ApplicationConfig applicationConfig = this.applicationConfig;
        synchronized (applicationConfig) {
            address = (String)this.applicationConfig.getProperty((Object)CLUSTER_ADDRESS);
            ttl = (String)this.applicationConfig.getProperty((Object)CLUSTER_TTL);
            clusterName = (String)this.applicationConfig.getProperty((Object)CLUSTER_NAME);
            clusterInterfaceName = (String)this.applicationConfig.getProperty((Object)CLUSTER_INTERFACE);
        }
        NetworkInterface clusterInterface = null;
        if (clusterInterfaceName != null) {
            try {
                clusterInterface = NetworkInterface.getByName(clusterInterfaceName);
            }
            catch (SocketException e) {
                log.error((Object)("Could not find network interface '" + clusterInterfaceName + "'"), (Throwable)e);
            }
        }
        try {
            return new ClusterConfig(InetAddress.getByName(address), clusterName, Integer.parseInt(ttl), clusterInterface);
        }
        catch (UnknownHostException ex) {
            throw new InvalidClusterAddressException("The address '" + address + "' is not a valid network address", ex);
        }
    }

    private ClusterConfig getPrivateClusterConfig() throws InvalidClusterAddressException {
        long runtimeHash = System.currentTimeMillis();
        String hashString = String.valueOf(runtimeHash);
        return new ClusterConfig(ClusterUtils.hashNameToMulticastAddress(hashString), hashString, 0);
    }

    public void setClusterManager(ClusterManager clusterManager) {
        this.clusterManager = clusterManager;
    }

    public void setApplicationConfig(ApplicationConfig applicationConfig) {
        this.applicationConfig = applicationConfig;
    }

    public void setCacheConfigLoader(CacheConfigurationLoader cacheConfigLoader) {
        this.cacheConfigLoader = cacheConfigLoader;
    }

    private static class AlphabeticalInterfacesWithLoopbackLast
    implements Comparator {
        private AlphabeticalInterfacesWithLoopbackLast() {
        }

        public int compare(Object o1, Object o2) {
            boolean iface2Loopback;
            boolean bothInterfacesSameClass;
            NetworkInterface iface1 = (NetworkInterface)o1;
            NetworkInterface iface2 = (NetworkInterface)o2;
            boolean iface1Loopback = ClusterUtils.isLoopbackInterface(iface1);
            boolean bl = bothInterfacesSameClass = iface1Loopback == (iface2Loopback = ClusterUtils.isLoopbackInterface(iface2));
            if (bothInterfacesSameClass) {
                return iface1.getName().compareTo(iface2.getName());
            }
            return iface1Loopback ? -1 : 1;
        }
    }
}

