/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.cluster.safety;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheFactory;
import com.atlassian.confluence.cluster.safety.ClusterPanicEvent;
import com.atlassian.confluence.cluster.safety.ClusterSafetyDao;
import com.atlassian.confluence.cluster.safety.ClusterSafetyManager;
import com.atlassian.event.Event;
import com.atlassian.event.EventManager;
import java.util.Random;
import org.apache.log4j.Category;

public class DefaultClusterSafetyManager
implements ClusterSafetyManager {
    private static final Category log = Category.getInstance(DefaultClusterSafetyManager.class);
    static final String SAFETY_NUMBER = "safety-number";
    private static final String SAFETY_NUMBER_CACHE = "com.atlassian.confluence.cluster.safety.DefaultClusterSafetyManager.safetyNumber";
    private final Random random = new Random();
    private CacheFactory cacheFactory;
    private ClusterSafetyDao clusterSafetyDao;
    private EventManager eventManager;

    public void verify() {
        int databaseNumber;
        int nextValue = this.getNextValue();
        if (this.clusterSafetyDao.safetyNumberExists() && this.cacheSafetyNumberExists() && (databaseNumber = this.clusterSafetyDao.getSafetyNumber()) != this.getCacheSafetyNumber()) {
            this.clusterSafetyDao.setSafetyNumber(nextValue);
            this.panic();
            return;
        }
        this.clusterSafetyDao.setSafetyNumber(nextValue);
        this.storeCacheNumber(nextValue);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Cached number exists: " + this.cacheSafetyNumberExists()));
            log.debug((Object)("Database number exists: " + this.clusterSafetyDao.safetyNumberExists()));
            if (this.clusterSafetyDao.safetyNumberExists() && this.cacheSafetyNumberExists()) {
                log.debug((Object)("Database number: " + this.clusterSafetyDao.getSafetyNumber() + " should equal cached number: " + this.getCacheSafetyNumber()));
            }
        }
    }

    public void panic() {
        this.eventManager.publishEvent((Event)new ClusterPanicEvent(this, "Database is being updated by an instance which is not part of the current cluster. You should check network connections between cluster nodes, especially multicast traffic."));
    }

    private int getNextValue() {
        return this.random.nextInt();
    }

    private boolean cacheSafetyNumberExists() {
        return this.getCache().get((Object)SAFETY_NUMBER) != null;
    }

    private int getCacheSafetyNumber() {
        Integer cachedValue = (Integer)this.getCache().get((Object)SAFETY_NUMBER);
        if (cachedValue == null) {
            throw new RuntimeException("No cached safety number");
        }
        return cachedValue;
    }

    private void storeCacheNumber(int value) {
        this.getCache().put((Object)SAFETY_NUMBER, (Object)new Integer(value));
    }

    private Cache getCache() {
        return this.cacheFactory.getCache(SAFETY_NUMBER_CACHE);
    }

    public void setCacheFactory(CacheFactory cacheFactory) {
        this.cacheFactory = cacheFactory;
    }

    public void setClusterSafetyDao(ClusterSafetyDao clusterSafetyDao) {
        this.clusterSafetyDao = clusterSafetyDao;
    }

    public void setEventManager(EventManager eventManager) {
        this.eventManager = eventManager;
    }
}

