/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.cluster.tangosol;

import com.atlassian.confluence.cluster.ClusterInformation;
import com.tangosol.net.Cluster;
import com.tangosol.run.xml.XmlElement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class TangosolClusterInformation
implements ClusterInformation {
    private Cluster cluster;
    private static final Logger log = Logger.getLogger(TangosolClusterInformation.class);
    private XmlElement xmlConfig;

    public TangosolClusterInformation(Cluster cluster, XmlElement xmlConfig) {
        this.cluster = cluster;
        this.xmlConfig = xmlConfig;
    }

    public boolean isRunning() {
        return this.cluster.isRunning();
    }

    public String getName() {
        String result = null;
        try {
            XmlElement identityElement = this.xmlConfig.getElement("member-identity");
            if (identityElement == null) {
                log.warn((Object)"No member-identity element found in the Confluence programmatic Coherence configuration.");
            } else {
                result = identityElement.getElement("cluster-name").getString();
            }
        }
        catch (Exception e) {
            log.warn((Object)("Failed to retrieve cluster name: " + e));
        }
        if (StringUtils.isBlank((String)result)) {
            result = "[unnamed]";
        }
        return result;
    }

    public String getDescription() {
        return "TangosolClusterInformation: " + this.getName() + ", listening on " + this.getMulticastAddress() + ":" + this.getMulticastPort();
    }

    public List getMembers() {
        ArrayList<String> c = new ArrayList<String>();
        Iterator i = this.cluster.getMemberSet().iterator();
        while (i.hasNext()) {
            c.add(i.next().toString());
        }
        return c;
    }

    public int getMemberCount() {
        return this.cluster.getMemberSet().size();
    }

    public String getMulticastAddress() {
        return this.xmlConfig.getElement("multicast-listener").getElement("address").getString();
    }

    public String getMulticastPort() {
        return this.xmlConfig.getElement("multicast-listener").getElement("port").getString();
    }

    public String toString() {
        return this.getDescription();
    }
}

