/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.cluster.tangosol;

import com.atlassian.core.task.FifoBuffer;
import com.tangosol.net.NamedCache;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Category;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TangosolClusteredFifoBuffer
implements FifoBuffer {
    private static final String POINTERS = "com.atlassian.confluence.cluster.tangosol.TangosolClusteredFifoBuffer.POINTERS";
    private static final Category log = Category.getInstance(TangosolClusteredFifoBuffer.class);
    private NamedCache cache;

    public TangosolClusteredFifoBuffer(NamedCache cache) {
        this.cache = cache;
    }

    public int size() {
        int size = this.getCache().size();
        if (this.getCache().get((Object)POINTERS) != null) {
            --size;
        }
        return size;
    }

    public Collection<Object> getItems() {
        ArrayList<Object> c = new ArrayList<Object>(this.getCache().size());
        Set entrySet = this.getCache().entrySet();
        for (Map.Entry entry : entrySet) {
            if (entry.getKey().equals(POINTERS)) continue;
            c.add(entry.getValue());
        }
        return c;
    }

    public void clear() {
        this.getCache().clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Object oValue) {
        if (oValue == null) {
            return;
        }
        try {
            this.getCache().lock((Object)POINTERS, -1L);
            QueuePointers queuePointers = this.getPointers();
            Long lKey = queuePointers.getNextAdd();
            this.getCache().put((Object)lKey, oValue);
            queuePointers.incNextAdd();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Added item " + oValue + " to FifoBuffer for lkey" + lKey));
            }
            this.getCache().put((Object)POINTERS, (Object)queuePointers);
        }
        finally {
            this.getCache().unlock((Object)POINTERS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove() {
        Object retVal = null;
        try {
            this.getCache().lock((Object)POINTERS, -1L);
            QueuePointers queuePointers = this.getPointers();
            if (queuePointers.isEmpty()) {
                Object var3_3 = null;
                return var3_3;
            }
            retVal = this.getItemFromCache(queuePointers);
            if (retVal != null) {
                this.incrementAndStorePointers(queuePointers);
            } else {
                log.warn((Object)("No item could be retrieved using QueuePointers :  " + queuePointers + ", item may have been evicted from the cache"));
                List<Long> keysLeftInBuffer = this.getKeys();
                QueuePointers newQueuePointers = new QueuePointers(keysLeftInBuffer);
                if (newQueuePointers.isEmpty()) {
                    this.getCache().put((Object)POINTERS, (Object)newQueuePointers);
                    Object var5_6 = null;
                    return var5_6;
                }
                retVal = this.getItemFromCache(newQueuePointers);
                this.incrementAndStorePointers(newQueuePointers);
            }
        }
        finally {
            this.getCache().unlock((Object)POINTERS);
        }
        return retVal;
    }

    private void incrementAndStorePointers(QueuePointers queuePointers) {
        queuePointers.incNextRemove();
        this.getCache().put((Object)POINTERS, (Object)queuePointers);
    }

    private Object getItemFromCache(QueuePointers queuePointers) {
        Long lKey = queuePointers.getNextRemove();
        return this.getCache().remove((Object)lKey);
    }

    private List<Long> getKeys() {
        ArrayList<Long> c = new ArrayList<Long>(this.getCache().size());
        Set entrySet = this.getCache().entrySet();
        for (Map.Entry entry : entrySet) {
            if (entry.getKey().equals(POINTERS)) continue;
            c.add((Long)entry.getKey());
        }
        return c;
    }

    private QueuePointers getPointers() {
        QueuePointers retVal = (QueuePointers)this.getCache().get((Object)POINTERS);
        if (retVal == null) {
            retVal = new QueuePointers();
            this.getCache().put((Object)POINTERS, (Object)retVal);
        }
        return retVal;
    }

    private NamedCache getCache() {
        return this.cache;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class QueuePointers
    implements Serializable {
        long m_lNextAdd = 0L;
        long m_lNextRemove = 0L;
        private long numberItems = 0L;

        QueuePointers() {
        }

        QueuePointers(List<Long> keys) {
            Collections.sort(keys);
            this.numberItems = keys.size();
            if (keys.size() > 0) {
                long smallestKey = keys.get(0);
                long largestKey = keys.get(keys.size() - 1);
                this.m_lNextRemove = smallestKey;
                this.m_lNextAdd = largestKey + 1L;
            }
        }

        public long getNextAdd() {
            return this.m_lNextAdd;
        }

        public void incNextAdd() {
            ++this.m_lNextAdd;
            ++this.numberItems;
        }

        public long getNextRemove() {
            return this.m_lNextRemove;
        }

        public void incNextRemove() {
            ++this.m_lNextRemove;
            --this.numberItems;
        }

        public String toString() {
            return "QeuePointers : nextAdd = " + this.m_lNextAdd + " nextRemove = " + this.m_lNextRemove + " size = " + this.numberItems;
        }

        public boolean isEmpty() {
            return this.numberItems == 0L;
        }
    }
}

