/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.cluster.tangosol;

import com.atlassian.confluence.cluster.ClusteredLock;
import com.atlassian.confluence.cluster.tangosol.TangosolClusterManager;
import com.tangosol.net.NamedCache;
import java.io.Serializable;

public class TangosolClusteredLock
implements ClusteredLock {
    private NamedCache cache;
    private String key;
    public static final long WAIT_UNTIL_ACQUIRED = -1L;

    public TangosolClusteredLock(NamedCache cache, String key) {
        this.cache = cache;
        this.key = key;
    }

    public boolean tryLock() {
        return (Boolean)new CacheOp(){

            public Object op() {
                return new Boolean(TangosolClusteredLock.this.getCache().lock((Object)TangosolClusteredLock.this.key));
            }
        }.doOp();
    }

    public void lock() {
        new CacheOp(){

            public Object op() {
                return new Boolean(TangosolClusteredLock.this.getCache().lock((Object)TangosolClusteredLock.this.key, -1L));
            }
        }.doOp();
    }

    public void unlock() {
        new CacheOp(){

            public Object op() {
                TangosolClusteredLock.this.getCache().unlock((Object)TangosolClusteredLock.this.key);
                return null;
            }
        }.doOp();
    }

    public Serializable getValue() {
        return (Serializable)new CacheOp(){

            public Object op() {
                return TangosolClusteredLock.this.getCache().get((Object)TangosolClusteredLock.this.key);
            }
        }.doOp();
    }

    public void setValue(final Serializable value) {
        new CacheOp(){

            public Object op() {
                TangosolClusteredLock.this.getCache().put((Object)TangosolClusteredLock.this.key, (Object)value);
                return null;
            }
        }.doOp();
    }

    private NamedCache getCache() {
        return this.cache;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TangosolClusteredLock that = (TangosolClusteredLock)o;
        if (!this.cache.equals(that.cache)) {
            return false;
        }
        return this.key.equals(that.key);
    }

    public int hashCode() {
        int result = this.cache.hashCode();
        result = 29 * result + this.key.hashCode();
        return result;
    }

    private abstract class CacheOp
    extends TangosolClusterManager.RetryOperation {
        private CacheOp() {
        }

        public abstract Object op();

        public void reInit() {
            TangosolClusteredLock.this.cache = TangosolClusteredLock.this.cache.getCacheService().ensureCache(TangosolClusteredLock.this.cache.getCacheName(), null);
        }
    }
}

