/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.content.service;

import com.atlassian.confluence.content.service.IdContentLocator;
import com.atlassian.confluence.content.service.RenderContentCommand;
import com.atlassian.confluence.content.service.RenderContentCommandImpl;
import com.atlassian.confluence.content.service.RenderingService;
import com.atlassian.confluence.content.service.space.SpaceLocator;
import com.atlassian.confluence.core.ContentEntityManager;
import com.atlassian.confluence.pages.wysiwyg.ConfluenceWysiwygConverter;
import com.atlassian.confluence.security.PermissionManager;

public class DefaultRenderingService
implements RenderingService {
    private ContentEntityManager contentEntityManager;
    private PermissionManager permissionManager;
    private ConfluenceWysiwygConverter confluenceWysiwygConverter;

    public RenderContentCommand newRenderXHtmlContentCommand(IdContentLocator contentLocator, SpaceLocator spaceLocator, String contentType, String content) {
        return new RenderContentCommandImpl(this.permissionManager, this.confluenceWysiwygConverter, contentLocator, spaceLocator, contentType, content, RenderMode.RICHTEXT);
    }

    public RenderContentCommand newRenderWikiMarkupContentCommand(IdContentLocator contentLocator, SpaceLocator spaceLocator, String contentType, String content) {
        return new RenderContentCommandImpl(this.permissionManager, this.confluenceWysiwygConverter, contentLocator, spaceLocator, contentType, content, RenderMode.MARKUP);
    }

    public IdContentLocator getContentLocator(long contentId) {
        return new IdContentLocator(this.contentEntityManager, contentId);
    }

    public void setPermissionManager(PermissionManager permissionManager) {
        this.permissionManager = permissionManager;
    }

    public void setConfluenceWysiwygConverter(ConfluenceWysiwygConverter confluenceWysiwygConverter) {
        this.confluenceWysiwygConverter = confluenceWysiwygConverter;
    }

    public void setContentEntityManager(ContentEntityManager contentEntityManager) {
        this.contentEntityManager = contentEntityManager;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RenderMode {
        RICHTEXT("richtext"),
        MARKUP("markup");

        private final String value;

        private RenderMode(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

