/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.content.service;

import com.atlassian.confluence.content.service.DefaultRenderingService;
import com.atlassian.confluence.content.service.IdContentLocator;
import com.atlassian.confluence.content.service.RenderContentCommand;
import com.atlassian.confluence.content.service.space.SpaceLocator;
import com.atlassian.confluence.core.ConfluenceEntityObject;
import com.atlassian.confluence.core.service.AbstractServiceCommand;
import com.atlassian.confluence.core.service.ServiceCommandValidator;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.wysiwyg.ConfluenceWysiwygConverter;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.Space;

public class RenderContentCommandImpl
extends AbstractServiceCommand
implements RenderContentCommand {
    private final PermissionManager permissionManager;
    private final ConfluenceWysiwygConverter confluenceWysiwygConverter;
    private final SpaceLocator spaceLocator;
    private final IdContentLocator contentLocator;
    private final String content;
    private final DefaultRenderingService.RenderMode mode;
    private final String contentType;
    private Space space;
    private ConfluenceEntityObject entity;
    private String renderedContent;

    public RenderContentCommandImpl(PermissionManager permissionManager, ConfluenceWysiwygConverter confluenceWysiwygConverter, IdContentLocator entityLocator, SpaceLocator spaceLocator, String contentType, String content, DefaultRenderingService.RenderMode mode) {
        this.permissionManager = permissionManager;
        this.confluenceWysiwygConverter = confluenceWysiwygConverter;
        this.contentLocator = entityLocator;
        this.spaceLocator = spaceLocator;
        this.contentType = contentType;
        this.content = content;
        this.mode = mode;
    }

    protected void validateInternal(ServiceCommandValidator validator) {
        if (this.contentLocator.getContentId() != 0L && this.getEntity() == null) {
            validator.addValidationError("content.doesnt.exist", new Object[0]);
        }
        if (this.getSpace() == null) {
            validator.addValidationError("space.doesnt.exist", new Object[0]);
        }
        try {
            this.getContentType();
        }
        catch (IllegalArgumentException e) {
            validator.addValidationError("render.unknown.content.type", this.contentType);
        }
    }

    protected boolean isAuthorizedInternal() {
        if (this.contentLocator.getContentId() == 0L) {
            return this.permissionManager.hasCreatePermission(this.getCurrentUser(), this.getSpace(), this.getContentType().getContentClass());
        }
        return this.permissionManager.hasPermission(this.getCurrentUser(), Permission.EDIT, this.getEntity());
    }

    protected void executeInternal() {
        this.renderedContent = this.confluenceWysiwygConverter.convertToPreview(this.content, String.valueOf(this.contentLocator.getContentId()), this.getSpace().getKey(), this.mode.getValue());
    }

    public String getRenderedContent() {
        return this.renderedContent;
    }

    private ContentType getContentType() {
        return ContentType.valueOf(this.contentType.toUpperCase());
    }

    private ConfluenceEntityObject getEntity() {
        if (this.entity == null) {
            this.entity = this.contentLocator.getEntity();
        }
        return this.entity;
    }

    private Space getSpace() {
        if (this.space == null) {
            this.space = this.spaceLocator.getSpace();
        }
        return this.space;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ContentType {
        PAGE("page"),
        BLOGPOST("blogpost"),
        COMMENT("comment");

        private final String value;

        private ContentType(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public Class getContentClass() {
            if (PAGE.equals((Object)this)) {
                return Page.class;
            }
            if (BLOGPOST.equals((Object)this)) {
                return BlogPost.class;
            }
            if (COMMENT.equals((Object)this)) {
                return Comment.class;
            }
            return null;
        }
    }
}

