/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.content.service.comment;

import com.atlassian.confluence.content.service.comment.CreateCommentCommand;
import com.atlassian.confluence.core.service.AbstractServiceCommand;
import com.atlassian.confluence.core.service.ServiceCommandValidator;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.pages.CommentManager;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.security.PermissionManager;

public class CreateCommentCommandImpl
extends AbstractServiceCommand
implements CreateCommentCommand {
    private final PermissionManager permissionManager;
    private final PageManager pageManager;
    private final CommentManager commentManager;
    private final long pageId;
    private final Long parentCommentId;
    private final String commentBody;
    private Comment parentComment;
    private Comment comment;

    public CreateCommentCommandImpl(PermissionManager permissionManager, PageManager pageManager, CommentManager commentManager, long pageId, String commentBody) {
        this.pageManager = pageManager;
        this.permissionManager = permissionManager;
        this.commentManager = commentManager;
        this.parentCommentId = null;
        this.pageId = pageId;
        this.commentBody = commentBody;
    }

    public CreateCommentCommandImpl(PermissionManager permissionManager, PageManager pageManager, CommentManager commentManager, long pageId, long parentCommentId, String commentBody) {
        this.pageManager = pageManager;
        this.permissionManager = permissionManager;
        this.commentManager = commentManager;
        this.pageId = pageId;
        this.parentCommentId = parentCommentId;
        this.commentBody = commentBody;
    }

    protected void validateInternal(ServiceCommandValidator validator) {
        if (this.getPage() == null) {
            validator.addFieldValidationError("pageId", "page.doesnt.exist", this.pageId);
        }
        if (this.commentBody == null || this.commentBody.matches("\\s*")) {
            validator.addFieldValidationError("content", "content.empty");
        }
        if (this.parentCommentId != null && this.parentCommentId > 0L && this.getParentComment() == null) {
            validator.addFieldValidationError("parentCommentId", "parent.comment.does.not.exist", this.parentCommentId);
        }
        if (this.getParentComment() != null && this.getPage() != null && !this.getParentComment().getPage().equals(this.getPage())) {
            validator.addFieldValidationError("parentCommentId", "parent.in.other.page", this.getPage(), this.getParentComment());
        }
    }

    protected boolean isAuthorizedInternal() {
        return this.getPage() == null || this.permissionManager.hasCreatePermission(this.getCurrentUser(), this.getPage(), Comment.class);
    }

    protected void executeInternal() {
        this.comment = this.commentManager.addCommentToPage(this.getPage(), this.getParentComment(), this.commentBody);
    }

    private Comment getParentComment() {
        if (this.parentComment == null && this.parentCommentId != null) {
            this.parentComment = this.commentManager.getComment(this.parentCommentId);
        }
        return this.parentComment;
    }

    private AbstractPage getPage() {
        return this.pageManager.getAbstractPage(this.pageId);
    }

    public Comment getComment() {
        return this.comment;
    }
}

