/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.content.service.page;

import com.atlassian.confluence.content.service.page.MovePageCommand;
import com.atlassian.confluence.content.service.page.PageLocator;
import com.atlassian.confluence.core.service.AbstractServiceCommand;
import com.atlassian.confluence.core.service.ServiceCommandValidator;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MovePageCommandImpl
extends AbstractServiceCommand
implements MovePageCommand {
    private static final Log log = LogFactory.getLog(MovePageCommandImpl.class);
    private final PageManager pageManager;
    private final PermissionManager permissionManager;
    private final PageLocator sourcePageLocator;
    private final PageLocator targetPageLocator;
    private String movePoint;

    public MovePageCommandImpl(PageManager pageManager, PermissionManager permissionManager, PageLocator sourcePageLocator, PageLocator targetPageLocator, String movePoint) {
        this.pageManager = pageManager;
        this.permissionManager = permissionManager;
        this.sourcePageLocator = sourcePageLocator;
        this.targetPageLocator = targetPageLocator;
        this.movePoint = movePoint;
    }

    protected void validateInternal(ServiceCommandValidator validator) {
        if (this.getSourcePage() == null) {
            validator.addValidationError("movepage.source.notfound", new Object[0]);
        }
        if (this.getTargetPage() == null) {
            validator.addValidationError("movepage.target.notfound", new Object[0]);
        }
        if (!(this.movePoint.equals("append") || this.movePoint.equals("above") || this.movePoint.equals("below"))) {
            validator.addValidationError("movepage.point.invalid", this.movePoint);
        }
        if ("append".equals(this.movePoint)) {
            if (this.getTargetPage().getAncestors().contains(this.getSourcePage())) {
                validator.addValidationError("movepage.target.invalid", new Object[0]);
            }
        } else if (this.getTargetPage().getParent() != null && this.getTargetPage().getParent().getAncestors().contains(this.getSourcePage())) {
            validator.addValidationError("movepage.target.invalid", new Object[0]);
        }
    }

    private Page getSourcePage() {
        return this.sourcePageLocator.getPage();
    }

    private Page getTargetPage() {
        return this.targetPageLocator.getPage();
    }

    protected boolean isAuthorizedInternal() {
        if (this.getSourcePage() == null || this.getTargetPage() == null) {
            return false;
        }
        boolean canEditSourcePage = this.permissionManager.hasPermission(this.getCurrentUser(), Permission.EDIT, this.getSourcePage());
        if ("below".equals(this.movePoint) || "above".equals(this.movePoint)) {
            if (this.getTargetPage().getParent() != null) {
                return canEditSourcePage && this.permissionManager.hasPermission(this.getCurrentUser(), Permission.VIEW, this.getTargetPage().getParent());
            }
            return canEditSourcePage && this.permissionManager.hasCreatePermission(this.getCurrentUser(), this.getTargetPage().getSpace(), Page.class);
        }
        if ("append".equals(this.movePoint)) {
            return canEditSourcePage && this.permissionManager.hasPermission(this.getCurrentUser(), Permission.VIEW, this.getTargetPage());
        }
        return false;
    }

    protected void executeInternal() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("move [ " + this.getSourcePage().getTitle() + " ] to [ " + this.getTargetPage().getTitle() + " ] at [ " + this.movePoint + " ]"));
        }
        if ("below".equals(this.movePoint)) {
            this.pageManager.movePageAfter(this.getSourcePage(), this.getTargetPage());
        } else if ("above".equals(this.movePoint)) {
            this.pageManager.movePageBefore(this.getSourcePage(), this.getTargetPage());
        } else if ("append".equals(this.movePoint)) {
            this.pageManager.movePageAsChild(this.getSourcePage(), this.getTargetPage());
        }
    }
}

