/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.content.service.page;

import com.atlassian.confluence.content.service.page.MovePageCommand;
import com.atlassian.confluence.content.service.page.PageLocator;
import com.atlassian.confluence.content.service.space.SpaceLocator;
import com.atlassian.confluence.core.service.AbstractServiceCommand;
import com.atlassian.confluence.core.service.ServiceCommandValidator;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.Space;
import org.apache.log4j.Logger;

public class MovePageToTopOfSpaceCommand
extends AbstractServiceCommand
implements MovePageCommand {
    private static final Logger log = Logger.getLogger(MovePageToTopOfSpaceCommand.class);
    private final PageManager pageManager;
    private final PermissionManager permissionManager;
    private Page sourcePage;
    private Space targetSpace;

    public MovePageToTopOfSpaceCommand(PageManager pageManager, PermissionManager permissionManager, PageLocator sourcePageLocator, SpaceLocator targetSpaceLocator) {
        this.pageManager = pageManager;
        this.permissionManager = permissionManager;
        this.sourcePage = sourcePageLocator.getPage();
        this.targetSpace = targetSpaceLocator.getSpace();
    }

    protected void executeInternal() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("move [ " + this.sourcePage + " ] to the top level of space: [ " + this.targetSpace.getKey() + " ]"));
        }
        this.pageManager.movePage(this.sourcePage, this.targetSpace);
    }

    protected boolean isAuthorizedInternal() {
        if (this.sourcePage == null || this.targetSpace == null) {
            return false;
        }
        boolean canEditSourcePage = this.permissionManager.hasPermission(this.getCurrentUser(), Permission.EDIT, this.sourcePage);
        boolean canCreatePagesInTargetSpace = this.permissionManager.hasCreatePermission(this.getCurrentUser(), this.targetSpace, Page.class);
        return canEditSourcePage && canCreatePagesInTargetSpace;
    }

    protected void validateInternal(ServiceCommandValidator validator) {
        if (this.sourcePage == null) {
            validator.addValidationError("movepage.source.notfound", new Object[0]);
        }
        if (this.targetSpace == null) {
            validator.addValidationError("movepage.target.space.notfound", new Object[0]);
        }
    }
}

