/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.core;

import com.atlassian.config.util.BootstrapUtils;
import com.atlassian.confluence.core.Administrative;
import com.atlassian.confluence.core.ConfluenceSystemProperties;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.DateFormatter;
import com.atlassian.confluence.core.FormatSettingsManager;
import com.atlassian.confluence.core.TimeZone;
import com.atlassian.confluence.core.datetime.FriendlyDateFormatter;
import com.atlassian.confluence.core.datetime.RequestTimeThreadLocal;
import com.atlassian.confluence.labels.LabelManager;
import com.atlassian.confluence.labels.Labelable;
import com.atlassian.confluence.languages.LanguageManager;
import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.mail.Mail;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.actions.PageAware;
import com.atlassian.confluence.plugin.descriptor.web.DefaultWebInterfaceContext;
import com.atlassian.confluence.plugin.descriptor.web.WebInterface;
import com.atlassian.confluence.plugin.descriptor.web.WebInterfaceContext;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.setup.settings.Settings;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.actions.Spaced;
import com.atlassian.confluence.themes.GlobalHelper;
import com.atlassian.confluence.themes.ThemeHelper;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.user.UserInterfaceState;
import com.atlassian.confluence.user.history.UserHistory;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.confluence.util.i18n.DefaultI18NBeanFactory;
import com.atlassian.confluence.util.i18n.I18NBean;
import com.atlassian.confluence.util.i18n.I18NBeanFactory;
import com.atlassian.confluence.util.i18n.Message;
import com.atlassian.confluence.velocity.htmlsafe.HtmlSafe;
import com.atlassian.event.EventManager;
import com.atlassian.plugin.web.WebInterfaceManager;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.user.User;
import com.opensymphony.util.TextUtils;
import com.opensymphony.webwork.ServletActionContext;
import com.opensymphony.xwork.ActionContext;
import com.opensymphony.xwork.ActionSupport;
import com.opensymphony.xwork.LocaleProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfluenceActionSupport
extends ActionSupport
implements LocaleProvider,
WebInterface {
    protected Logger log = Logger.getLogger(this.getClass());
    private static final Logger log2 = Logger.getLogger(ConfluenceActionSupport.class);
    public static final String CANCEL = "cancel";
    public static final String PREVIEW = "preview";
    public static final String LICENSE_EXPIRED = "licenseexpired";
    public static final String LICENSE_USERS_EXCEEDED = "licenseusersexceeded";
    public static final String DEVMODE = "confluence.devmode";
    private Locale userLocale = null;
    protected UserAccessor userAccessor;
    protected EventManager eventManager;
    protected SpacePermissionManager spacePermissionManager;
    protected PermissionManager permissionManager;
    protected SettingsManager settingsManager;
    protected LabelManager labelManager;
    protected LanguageManager languageManager;
    private LocaleManager localeManager;
    private I18NBean i18NBean;
    protected I18NBeanFactory i18NBeanFactory;
    protected WebInterfaceManager webInterfaceManager;
    private FormatSettingsManager formatSettingsManager;
    protected boolean permitted = false;
    private boolean permissionCheck = false;
    private String cancel;
    private BootstrapManager bootstrapManager;
    private User remoteUser;
    private Date previousLoginDate;
    private UserInterfaceState userInterfaceState;
    private GlobalHelper globalHelper;
    private DateFormatter dateFormatter;
    private FriendlyDateFormatter friendlyDateFormatter;
    private static final String HIBERNATE_DIALECT = "hibernate.dialect";
    private static final String HSQL_DIALECT = "net.sf.hibernate.dialect.HSQLDialect";

    public void setCancel(String cancel) {
        this.cancel = cancel;
    }

    public boolean isCanceled() {
        return StringUtils.isNotBlank((String)this.cancel);
    }

    public int getRandom() {
        return (int)(Math.random() * 2.147483647E9);
    }

    public String doDefault() throws Exception {
        return "input";
    }

    @HtmlSafe
    public String getText(String key) {
        return this.getText(key, Collections.EMPTY_LIST);
    }

    @HtmlSafe
    public String getText(String key, String defaultValue) {
        if (key == null) {
            return defaultValue;
        }
        String i18nValue = this.getText(key);
        return GeneralUtil.stringSet(i18nValue) ? i18nValue : defaultValue;
    }

    @HtmlSafe
    public String getText(String key, Object[] args) {
        try {
            return this.getI18n().getText(key, args);
        }
        catch (RuntimeException e) {
            log2.error((Object)("Error retrieving i18n text with key: " + key + " and arguments: " + ArrayUtils.toString((Object)args)), (Throwable)e);
            return "Error retrieving text key: " + key;
        }
    }

    @HtmlSafe
    public String getText(String key, List list) {
        try {
            return this.getI18n().getText(key, list);
        }
        catch (RuntimeException e) {
            log2.error((Object)("Error retrieving i18n text with key: " + key + " and arguments: " + list), (Throwable)e);
            return "Error retrieving text key: " + key;
        }
    }

    public String getActionName(String fullClassName) {
        String key = fullClassName + ".action.name";
        return this.getText(key);
    }

    @HtmlSafe
    public String getTextStrict(String key) {
        return this.getI18n().getTextStrict(key);
    }

    public boolean isPrintableVersion() {
        if (ServletActionContext.getRequest() == null) {
            return false;
        }
        return TextUtils.noNull((String)ServletActionContext.getRequest().getParameter("decorator")).equalsIgnoreCase("printable");
    }

    public String isPermittedAsString() {
        return this.isPermitted() ? "true" : "false";
    }

    public boolean isPermitted() {
        if (!this.getBootstrapManager().isSetupComplete()) {
            return true;
        }
        if (GeneralUtil.isSuperUser(this.getRemoteUser())) {
            return true;
        }
        if (this instanceof Administrative) {
            return this.permissionManager.hasPermission(this.getRemoteUser(), Permission.ADMINISTER, PermissionManager.TARGET_APPLICATION);
        }
        return this.spacePermissionManager.hasPermission(this.getPermissionTypes(), null, this.getRemoteUser());
    }

    protected List<String> getPermissionTypes() {
        ArrayList<String> permissions = new ArrayList<String>();
        this.addPermissionTypeTo("USECONFLUENCE", permissions);
        return permissions;
    }

    public boolean isPermissionCheck() {
        return this.permissionCheck;
    }

    public void setPermissionCheck(boolean permissionCheck) {
        this.permissionCheck = permissionCheck;
    }

    public User getRemoteUser() {
        if (this.remoteUser == null) {
            HttpServletRequest request = ServletActionContext.getRequest();
            if (request != null) {
                String remoteUserName = request.getRemoteUser();
                if (remoteUserName != null) {
                    this.remoteUser = this.getUser(remoteUserName);
                }
            } else {
                this.remoteUser = AuthenticatedUserThreadLocal.getUser();
            }
        }
        return this.remoteUser;
    }

    public User getUser(String username) {
        return this.getUserAccessor().getUser(username);
    }

    public String getUserFullName(String username) {
        if (!TextUtils.stringSet((String)username)) {
            return null;
        }
        User user = this.getUser(username);
        return user != null ? user.getFullName() : null;
    }

    protected void addPermissionTypeTo(String permissionType, List<String> permissionTypes) {
        if (permissionTypes.indexOf(permissionType) == -1) {
            permissionTypes.add(permissionType);
        }
    }

    protected List getPermittedEntitiesOf(List entities) {
        return this.permissionManager.getPermittedEntities(this.getRemoteUser(), Permission.VIEW, entities);
    }

    protected List getPermittedEntitiesOf(Iterator entities, int maxCount, List criteria) {
        return this.permissionManager.getPermittedEntities(this.getRemoteUser(), Permission.VIEW, entities, maxCount, criteria);
    }

    protected List getPermittedEntitiesOf(Iterator entities, int maxCount) {
        return this.permissionManager.getPermittedEntities(this.getRemoteUser(), Permission.VIEW, entities, maxCount);
    }

    public void setPreviousLoginDate(Date previousLoginDate) {
        this.previousLoginDate = previousLoginDate;
    }

    public Date getPreviousLoginDate() {
        if (this.previousLoginDate == null && this.getRemoteUser() != null) {
            try {
                this.previousLoginDate = this.getUserAccessor().getPropertySet(this.getRemoteUser()).getDate("confluence.user.previous.login.date");
            }
            catch (Exception e) {
                log2.info((Object)"Problem retrieving previousLoginDate", (Throwable)e);
                return null;
            }
        }
        return this.previousLoginDate;
    }

    public boolean isExternalUserManagementEnabled() {
        return this.settingsManager.getGlobalSettings().isExternalUserManagement();
    }

    protected void addToHistory(ContentEntityObject content) {
        UserHistory history = (UserHistory)this.getSession().get("confluence.user.history");
        if (history == null) {
            history = new UserHistory(20);
            this.getSession().put("confluence.user.history", history);
        }
        history.addContentEntity(content);
    }

    public Map getSession() {
        return ActionContext.getContext().getSession();
    }

    protected UserInterfaceState getUserInterfaceState() {
        if (this.userInterfaceState == null) {
            this.userInterfaceState = new UserInterfaceState(this.getRemoteUser(), this.getUserAccessor());
        }
        return this.userInterfaceState;
    }

    public boolean isAnonymousUser() {
        return this.getRemoteUser() == null;
    }

    public boolean isDevMode() {
        return ConfluenceSystemProperties.isDevMode();
    }

    public String getCancelResult() {
        return CANCEL;
    }

    public String getNiceContentType(ContentEntityObject entityObject) {
        if (entityObject instanceof Page) {
            return this.getText("content.page");
        }
        if (entityObject instanceof BlogPost) {
            return this.getText("content.blogpost");
        }
        if (entityObject instanceof Mail) {
            return this.getText("content.mail");
        }
        return "Unknown content type";
    }

    public ResourceBundle getDefaultResourceBundle() {
        return this.getI18n().getResourceBundle();
    }

    public Settings getGlobalSettings() {
        if (this.settingsManager == null) {
            return new Settings();
        }
        return this.settingsManager.getGlobalSettings();
    }

    public boolean isEmailVisible() {
        return this.permissionManager.isConfluenceAdministrator(this.getRemoteUser()) || !this.settingsManager.getGlobalSettings().areEmailAddressesPrivate();
    }

    public boolean isLabelable(Object object) {
        return object instanceof Labelable;
    }

    public void setSettingsManager(SettingsManager settingsManager) {
        this.settingsManager = settingsManager;
    }

    protected boolean hasPermissionForSpace(List permissionTypes, Space space) {
        return this.spacePermissionManager.hasPermissionForSpace(this.getRemoteUser(), permissionTypes, space);
    }

    public EventManager getEventManager() {
        return this.eventManager;
    }

    public void setEventManager(EventManager eventManager) {
        this.eventManager = eventManager;
    }

    public void setBootstrapManager(BootstrapManager bootstrapManager) {
        this.bootstrapManager = bootstrapManager;
    }

    public BootstrapManager getBootstrapManager() {
        if (this.bootstrapManager == null) {
            this.bootstrapManager = (BootstrapManager)BootstrapUtils.getBootstrapManager();
        }
        return this.bootstrapManager;
    }

    public void setSpacePermissionManager(SpacePermissionManager spacePermissionManager) {
        this.spacePermissionManager = spacePermissionManager;
    }

    public void setPermissionManager(PermissionManager permissionManager) {
        this.permissionManager = permissionManager;
    }

    public WebInterfaceManager getWebInterfaceManager() {
        return this.webInterfaceManager;
    }

    public void setWebInterfaceManager(WebInterfaceManager webInterfaceManager) {
        this.webInterfaceManager = webInterfaceManager;
    }

    public void setLabelManager(LabelManager labelManager) {
        this.labelManager = labelManager;
    }

    public LabelManager getLabelManager() {
        return this.labelManager;
    }

    public void setLanguageManager(LanguageManager languageManager) {
        this.languageManager = languageManager;
    }

    public LanguageManager getLanguageManager() {
        return this.languageManager;
    }

    public ThemeHelper getHelper() {
        if (this.globalHelper == null) {
            this.globalHelper = new GlobalHelper(this);
        }
        return this.globalHelper;
    }

    public UserAccessor getUserAccessor() {
        if (this.userAccessor == null) {
            this.userAccessor = (UserAccessor)ContainerManager.getComponent((String)"userAccessor");
        }
        return this.userAccessor;
    }

    public void setUserAccessor(UserAccessor userAccessor) {
        this.userAccessor = userAccessor;
    }

    public ThemeHelper getGlobalHelper() {
        return this.getHelper();
    }

    public ThemeHelper getSpaceHelper() {
        return this.getHelper();
    }

    public static String getTextStatic(String key) {
        ConfluenceActionSupport dummy = GeneralUtil.newWiredConfluenceActionSupport();
        return dummy.getText(key);
    }

    public static String getTextStatic(String key, Object[] list) {
        ConfluenceActionSupport dummy = GeneralUtil.newWiredConfluenceActionSupport();
        return dummy.getText(key, list);
    }

    public Locale getLocale() {
        if (this.userLocale == null) {
            this.userLocale = this.getLocaleManager().getLocale(this.getRemoteUser());
        }
        return this.userLocale;
    }

    public String getLocaleString() {
        return this.getLocale().toString();
    }

    public String getLanguageUserFriendly(String locale) {
        try {
            String[] keys = locale.split("_");
            Locale temp = new Locale(keys[0], keys[1]);
            return temp.getDisplayLanguage(temp);
        }
        catch (Exception e) {
            return locale;
        }
    }

    public List getInstalledLanguages() {
        return this.getLanguageManager().getLanguages();
    }

    public void addFieldError(String fieldName, String textKey, Object[] args) {
        Object[] encodedArgs = this.safeXmlEncodeArgs(args);
        this.addFieldError(fieldName, this.getText(textKey, encodedArgs));
    }

    public void addActionError(String textKey, Object[] args) {
        Object[] encodedArgs = this.safeXmlEncodeArgs(args);
        this.addActionError(this.getText(textKey, encodedArgs));
    }

    private Object[] safeXmlEncodeArgs(Object[] args) {
        Object[] encodedArgs = new Object[args.length];
        for (int i = 0; i < args.length; ++i) {
            encodedArgs[i] = !(args[i] instanceof String) ? args[i] : GeneralUtil.escapeXml((String)args[i]);
        }
        return encodedArgs;
    }

    public I18NBean getI18n() {
        if (this.i18NBean == null) {
            return this.getI18NBeanFactory().getI18NBean(this.getLocale());
        }
        return this.i18NBean;
    }

    public void setLocaleManager(LocaleManager localeManager) {
        this.localeManager = localeManager;
    }

    public LocaleManager getLocaleManager() {
        if (this.localeManager == null) {
            this.localeManager = (LocaleManager)ContainerManager.getComponent((String)"localeManager");
        }
        return this.localeManager;
    }

    public void setI18NBeanFactory(I18NBeanFactory i18NBeanFactory) {
        this.i18NBeanFactory = i18NBeanFactory;
    }

    private I18NBeanFactory getI18NBeanFactory() {
        if (this.i18NBeanFactory == null) {
            this.i18NBeanFactory = new DefaultI18NBeanFactory();
        }
        return this.i18NBeanFactory;
    }

    public TimeZone getTimeZone() {
        if (this.getBootstrapManager().isSetupComplete() && this.getRemoteUser() != null) {
            return this.getUserAccessor().getConfluenceUserPreferences(this.getRemoteUser()).getTimeZone();
        }
        return this.getGlobalSettings().getTimeZone();
    }

    public DateFormatter getDateFormatter() {
        if (this.dateFormatter == null) {
            this.dateFormatter = new DateFormatter(this.getTimeZone(), this.formatSettingsManager);
        }
        return this.dateFormatter;
    }

    public FriendlyDateFormatter getFriendlyDateFormatter() {
        if (this.friendlyDateFormatter == null) {
            this.friendlyDateFormatter = new FriendlyDateFormatter(RequestTimeThreadLocal.getTimeOrNow(), this.getDateFormatter());
        }
        return this.friendlyDateFormatter;
    }

    public String formatFriendlyDate(Date date) {
        Message message = this.getFriendlyDateFormatter().getFormatMessage(date);
        return this.getText(message.getKey(), message.getArguments());
    }

    public void setFormatSettingsManager(FormatSettingsManager formatSettingsManager) {
        this.formatSettingsManager = formatSettingsManager;
    }

    public boolean isUsingHSQL() {
        String dialect = this.getBootstrapManager().getString(HIBERNATE_DIALECT);
        return dialect.equals(HSQL_DIALECT);
    }

    public void setI18NBean(I18NBean i18NBean) {
        this.i18NBean = i18NBean;
    }

    @Override
    public WebInterfaceContext getWebInterfaceContext() {
        DefaultWebInterfaceContext context = new DefaultWebInterfaceContext();
        context.setUser(this.getRemoteUser());
        if (this instanceof PageAware) {
            context.setPage(((PageAware)((Object)this)).getPage());
        }
        if (this instanceof Spaced) {
            context.setSpace(((Spaced)((Object)this)).getSpace());
        } else if (context.getPage() != null) {
            context.setSpace(((AbstractPage)context.getPage().getLatestVersion()).getSpace());
        }
        return context;
    }
}

