/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.core;

import com.atlassian.confluence.core.SynchronizationManager;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Category;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class ConfluenceSynchronizationManager
implements SynchronizationManager {
    private static final Category log = Category.getInstance(ConfluenceSynchronizationManager.class);

    public static ConfluenceSynchronizationManager getInstance() {
        return new ConfluenceSynchronizationManager();
    }

    public void runOnSuccessfulCommit(Runnable task) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Queueing task for run on txn commit: " + task));
        }
        if (!this.isTransactionActive()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("No transaction found. Running task immediately: " + task));
            }
            this.runTask(task);
            return;
        }
        for (Object o : TransactionSynchronizationManager.getSynchronizations()) {
            if (!(o instanceof PostCommitRunnableSynchronization)) continue;
            ((PostCommitRunnableSynchronization)((Object)o)).addTask(task);
            return;
        }
        PostCommitRunnableSynchronization synchronization = new PostCommitRunnableSynchronization();
        synchronization.addTask(task);
        this.registerSynchronization((TransactionSynchronization)synchronization);
    }

    public boolean isTransactionActive() {
        return TransactionSynchronizationManager.isSynchronizationActive();
    }

    public void registerSynchronization(TransactionSynchronization synchronization) {
        TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)synchronization);
    }

    public List getSynchronizations() {
        return TransactionSynchronizationManager.getSynchronizations();
    }

    private void runTask(Runnable task) {
        try {
            task.run();
        }
        catch (Exception t) {
            log.error((Object)("Error executing task in post-commit queue: " + task), (Throwable)t);
        }
    }

    private class PostCommitRunnableSynchronization
    extends TransactionSynchronizationAdapter {
        private final List taskQueue = new LinkedList();

        private PostCommitRunnableSynchronization() {
        }

        public void afterCompletion(int i) {
            if (i != 0) {
                return;
            }
            Iterator taskIterator = this.taskQueue.iterator();
            while (taskIterator.hasNext()) {
                Runnable task = (Runnable)taskIterator.next();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Running post-commit task: " + task));
                }
                ConfluenceSynchronizationManager.this.runTask(task);
                taskIterator.remove();
            }
        }

        void addTask(Runnable task) {
            this.taskQueue.add(task);
        }
    }
}

