/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.core;

import com.atlassian.bonnie.Searchable;
import com.atlassian.bonnie.search.summary.Summarizer;
import com.atlassian.confluence.core.AbstractVersionedEntityObject;
import com.atlassian.confluence.core.Addressable;
import com.atlassian.confluence.core.BodyContent;
import com.atlassian.confluence.core.VersionHistorySummary;
import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.labels.LabelPermissionSupport;
import com.atlassian.confluence.labels.Labelable;
import com.atlassian.confluence.labels.Labelling;
import com.atlassian.confluence.labels.Namespace;
import com.atlassian.confluence.labels.PermittedLabelView;
import com.atlassian.confluence.links.OutgoingLink;
import com.atlassian.confluence.links.ReferralLink;
import com.atlassian.confluence.links.TrackbackLink;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.security.ContentPermission;
import com.atlassian.confluence.security.ContentPermissionSet;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.util.LabelUtil;
import com.atlassian.confluence.velocity.htmlsafe.HtmlSafe;
import com.atlassian.renderer.util.RendererUtil;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.user.User;
import com.opensymphony.util.TextUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.sf.hibernate.Hibernate;
import org.apache.log4j.Logger;

public abstract class ContentEntityObject
extends AbstractVersionedEntityObject
implements Searchable,
Comparable,
Addressable,
Labelable {
    public static final String CURRENT = "current";
    public static final String DELETED = "deleted";
    public static final String CREATED = "created";
    public static final String MODIFIED = "modified";
    private static final Logger log = Logger.getLogger(ContentEntityObject.class);
    private String title;
    private List bodyContents = new ArrayList();
    private String versionComment = "";
    private List outgoingLinks = new ArrayList();
    private List referralLinks = new ArrayList();
    private List trackbackLinks = new ArrayList();
    private String contentStatus = "current";
    private List attachments = new ArrayList();
    private transient UserAccessor userAccessor;
    private List labellings;
    private List contentPermissionSets = new ArrayList();
    private List historicalVersions = new ArrayList();

    protected ContentEntityObject() {
    }

    public abstract String getType();

    public String getIdAsString() {
        return Long.toString(this.getId());
    }

    public String getDisplayTitle() {
        return this.getTitle();
    }

    public final String getRealTitle() {
        return this.getDisplayTitle();
    }

    public abstract String getUrlPath();

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getContent() {
        if (!this.bodyContents.isEmpty()) {
            return ((BodyContent)this.bodyContents.get(0)).getBody();
        }
        return "";
    }

    public void setContent(String content) {
        if (content == null) {
            content = "";
        }
        if (this.bodyContents.isEmpty()) {
            BodyContent bodyContent = new BodyContent();
            bodyContent.setContent(this);
            this.bodyContents.add(bodyContent);
        }
        ((BodyContent)this.bodyContents.get(0)).setBody(content);
    }

    public List getBodyContents() {
        return this.bodyContents;
    }

    public void setBodyContents(List bodyContents) {
        this.bodyContents = bodyContents;
    }

    private List getHistoricalVersions() {
        return this.historicalVersions;
    }

    private void setHistoricalVersions(List historicalVersions) {
        this.historicalVersions = historicalVersions;
    }

    public List getOutgoingLinks() {
        return this.outgoingLinks;
    }

    public void setOutgoingLinks(List outgoingLinks) {
        this.outgoingLinks = outgoingLinks;
    }

    public void addOutgoingLink(OutgoingLink link) {
        this.getOutgoingLinks().add(link);
    }

    public void removeOutgoingLink(OutgoingLink link) {
        this.getOutgoingLinks().remove(link);
    }

    public List getReferralLinks() {
        return this.referralLinks;
    }

    public void setReferralLinks(List referralLinks) {
        this.referralLinks = referralLinks;
    }

    public void addReferralLink(ReferralLink link) {
        this.getReferralLinks().add(link);
    }

    public void removeReferralLink(ReferralLink link) {
        this.getReferralLinks().remove(link);
    }

    public List getTrackbackLinks() {
        return this.trackbackLinks;
    }

    public void setTrackbackLinks(List trackbackLinks) {
        this.trackbackLinks = trackbackLinks;
    }

    public void addTrackbackLink(TrackbackLink link) {
        this.getTrackbackLinks().add(link);
    }

    public void removeTrackbackLink(TrackbackLink link) {
        this.getTrackbackLinks().remove(link);
    }

    public void convertToHistoricalVersion() {
        super.convertToHistoricalVersion();
        this.setOutgoingLinks(new ArrayList());
        this.setReferralLinks(new ArrayList());
        this.setTrackbackLinks(new ArrayList());
        this.setAttachments(new ArrayList());
        this.setLabellings(new ArrayList());
        this.setContentPermissionSets(new ArrayList());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || Hibernate.getClass((Object)this) != Hibernate.getClass((Object)o)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ContentEntityObject that = (ContentEntityObject)o;
        return !(this.getTitle() != null ? !this.getTitle().equalsIgnoreCase(that.getTitle()) : that.getTitle() != null);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 29 * result + (this.getTitle() != null ? this.getTitle().toLowerCase().hashCode() : 0);
        return result;
    }

    public String toString() {
        return this.getType() + ": " + this.getDisplayTitle() + " v." + this.getVersion() + " (" + this.getId() + ")";
    }

    public abstract String getNameForComparison();

    public final int compareTo(Object o) {
        long otherCreationDate;
        ContentEntityObject otherEntity = (ContentEntityObject)o;
        int comparison = this.getNameForComparison().compareToIgnoreCase(otherEntity.getNameForComparison());
        long thisCreationDate = this.getCreationDate() != null ? this.getCreationDate().getTime() : 0L;
        long l = otherCreationDate = otherEntity.getCreationDate() != null ? otherEntity.getCreationDate().getTime() : 0L;
        return comparison == 0 ? (thisCreationDate < otherCreationDate ? -1 : (thisCreationDate == otherCreationDate ? 0 : 1)) : comparison;
    }

    public Collection getSearchableDependants() {
        ArrayList dependents = new ArrayList();
        dependents.addAll(this.getLatestVersionsOfAttachments());
        return dependents;
    }

    public final PageContext toPageContext() {
        return new PageContext(this);
    }

    public boolean isRecentlyUpdatedFor(User user) {
        if (user == null) {
            return false;
        }
        Date lastLogin = this.getUserAccessor().getPropertySet(user).getDate("confluence.user.previous.login.date");
        if (lastLogin == null) {
            return false;
        }
        if (this.getLastModificationDate() != null) {
            return lastLogin.before(this.getLastModificationDate());
        }
        if (this.getCreationDate() != null) {
            return lastLogin.before(this.getCreationDate());
        }
        return false;
    }

    public boolean isIndexable() {
        return this.isLatestVersion() && this.isCurrent();
    }

    public List getPermissions() {
        ArrayList<ContentPermission> result = new ArrayList<ContentPermission>();
        for (ContentPermissionSet contentPermissionSet : this.getContentPermissionSets()) {
            Iterator permIterator = contentPermissionSet.iterator();
            while (permIterator.hasNext()) {
                ContentPermission permission = (ContentPermission)permIterator.next();
                result.add(permission);
            }
        }
        return result;
    }

    public synchronized ContentPermission getContentPermission(String permissionType) {
        ContentPermissionSet permissionSet = this.getContentPermissionSet(permissionType);
        if (permissionSet != null && permissionSet.size() > 0) {
            return (ContentPermission)permissionSet.iterator().next();
        }
        return null;
    }

    public String getContentStatus() {
        return this.contentStatus;
    }

    public void setContentStatus(String contentStatus) {
        this.contentStatus = contentStatus;
    }

    public boolean isCurrent() {
        return CURRENT.equals(this.getContentStatus());
    }

    public boolean isDeleted() {
        return DELETED.equals(this.getContentStatus());
    }

    public void trash() {
        this.setContentStatus(DELETED);
    }

    public List getAttachments() {
        return this.attachments;
    }

    public List getLatestVersionsOfAttachments() {
        HashMap<String, Attachment> alreadyAddedAttachments = new HashMap<String, Attachment>();
        for (int i = 0; i < this.attachments.size(); ++i) {
            Attachment attachment = (Attachment)this.attachments.get(i);
            Attachment alreadyAdded = (Attachment)alreadyAddedAttachments.get(attachment.getFileName().toLowerCase());
            if (alreadyAdded != null && attachment.getVersion() <= alreadyAdded.getVersion()) continue;
            alreadyAddedAttachments.put(attachment.getFileName().toLowerCase(), attachment);
        }
        ArrayList latestVersions = new ArrayList(alreadyAddedAttachments.values());
        Collections.sort(latestVersions, new Comparator(){

            public int compare(Object o1, Object o2) {
                Attachment attachment1 = (Attachment)o1;
                Attachment attachment2 = (Attachment)o2;
                return attachment1.getFileName().compareToIgnoreCase(attachment2.getFileName());
            }
        });
        return latestVersions;
    }

    public void setAttachments(List attachments) {
        this.attachments = attachments;
    }

    public void addAttachment(Attachment attachment) {
        this.getAttachments().add(attachment);
        attachment.setContent(this);
    }

    public void removeAttachment(Attachment attachment) {
        attachment.setContent(null);
        this.getAttachments().remove(attachment);
    }

    public String getExcerpt() {
        try {
            String strippedContent = RendererUtil.stripBasicMarkup((String)this.getContent());
            Summarizer summer = (Summarizer)ContainerManager.getComponent((String)"summarizer");
            return summer.getSummary(strippedContent).toString();
        }
        catch (IOException e) {
            log.error((Object)("error exctracting excerpt: " + e.getMessage()), (Throwable)e);
            return null;
        }
    }

    public String getAttachmentsUrlPath() {
        return "/download/attachments/" + this.getIdAsString();
    }

    public Attachment getAttachmentNamed(String fileName) {
        for (Attachment attachment : this.getAttachments()) {
            if (!attachment.getFileName().equalsIgnoreCase(fileName)) continue;
            return attachment;
        }
        return null;
    }

    private void setLabellings(List labellings) {
        this.labellings = labellings;
    }

    public List getLabellings() {
        if (this.labellings == null) {
            this.labellings = new ArrayList();
        }
        return this.labellings;
    }

    public void addLabelling(Labelling content) {
        if (this.getLabellings().contains(content)) {
            return;
        }
        this.getLabellings().add(content);
    }

    public void removeLabelling(Labelling labelling) {
        this.getLabellings().remove(labelling);
    }

    public List getLabels() {
        return LabelUtil.extractLabelsFromLabellings(this.getLabellings());
    }

    public int getLabelCount() {
        return this.getLabellings().size();
    }

    public boolean isFavourite(User user) {
        return user != null && (this.hasPersonalLabel("favourite", user) || this.hasPersonalLabel("favorite", user));
    }

    private boolean hasPersonalLabel(String labelName, User user) {
        return this.getLabels().contains(new Label(labelName, Namespace.PERSONAL, user.getName()));
    }

    public List getVisibleLabels(User user) {
        return new PermittedLabelView(this, user, false).getLabels();
    }

    public List getPersonalLabels(User user) {
        return LabelPermissionSupport.filterLabelsByNamespace(this.getLabelsForDisplay(user), user, Namespace.PERSONAL);
    }

    public List getGlobalLabels(User user) {
        return LabelPermissionSupport.filterLabelsByNamespace(this.getLabelsForDisplay(user), user, Namespace.GLOBAL);
    }

    public List getLabelsForDisplay(User user) {
        return new PermittedLabelView(this, user, true).getLabels();
    }

    public LabelUtil getLabelUtil() {
        return new LabelUtil();
    }

    public String getVersionComment() {
        return this.versionComment;
    }

    public void setVersionComment(String versionComment) {
        this.versionComment = versionComment;
    }

    public boolean isVersionCommentAvailable() {
        return TextUtils.stringSet((String)this.getVersionComment()) && this.getVersionComment().trim().length() > 0;
    }

    public UserAccessor getUserAccessor() {
        if (this.userAccessor == null) {
            this.userAccessor = (UserAccessor)ContainerManager.getComponent((String)"userAccessor");
        }
        return this.userAccessor;
    }

    public void setUserAccessor(UserAccessor userAccessor) {
        this.userAccessor = userAccessor;
    }

    public Object clone() throws CloneNotSupportedException {
        ContentEntityObject clone = (ContentEntityObject)super.clone();
        ArrayList<BodyContent> newBodyContents = new ArrayList<BodyContent>(1);
        if (!clone.getBodyContents().isEmpty()) {
            BodyContent newBodyContent = (BodyContent)((BodyContent)clone.getBodyContents().get(0)).clone();
            newBodyContent.setId(0L);
            newBodyContent.setContent(clone);
            newBodyContents.add(newBodyContent);
        }
        clone.setBodyContents(newBodyContents);
        clone.historicalVersions = new ArrayList();
        return clone;
    }

    @HtmlSafe
    public String getRenderedVersionComment() {
        return VersionHistorySummary.renderVersionComment(this.getVersionComment());
    }

    public ContentPermissionSet getContentPermissionSet(String type) {
        for (ContentPermissionSet permissionSet : this.contentPermissionSets) {
            if (type == null || !type.equals(permissionSet.getType())) continue;
            return permissionSet;
        }
        return null;
    }

    public boolean hasPermissions(String type) {
        return this.getContentPermissionSet(type) != null;
    }

    private List getContentPermissionSets() {
        return this.contentPermissionSets;
    }

    private void setContentPermissionSets(List contentPermissionSets) {
        this.contentPermissionSets = contentPermissionSets;
    }

    public void addPermission(ContentPermission permission) {
        String type = permission.getType();
        ContentPermissionSet set = this.getContentPermissionSet(type);
        if (set == null) {
            set = new ContentPermissionSet(type, this);
            this.contentPermissionSets.add(set);
        }
        set.addContentPermission(permission);
    }

    public void removeContentPermissionSet(ContentPermissionSet set) {
        this.contentPermissionSets.remove((Object)set);
        set.setOwningContent(null);
    }
}

