/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.core;

import com.atlassian.confluence.core.FormatSettingsManager;
import com.atlassian.confluence.core.TimeZone;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class DateFormatter {
    private final TimeZone timeZone;
    private final DateFormat dateFormat;
    private final DateFormat dateTimeFormat;
    private final DateFormat timeFormat;
    private final DateFormat dayFormat;
    private final DateFormat blogDateFormat;
    private final DateFormat serverDateFormat;
    private final DateFormat serverDateTimeFormat;

    public DateFormatter(TimeZone timeZone, FormatSettingsManager formatSettingsManager) {
        this.timeZone = timeZone;
        this.dateFormat = this.createFormat(formatSettingsManager.getDateFormat());
        this.dateTimeFormat = this.createFormat(formatSettingsManager.getDateTimeFormat());
        this.timeFormat = this.createFormat(formatSettingsManager.getTimeFormat());
        this.dayFormat = this.createFormat(formatSettingsManager.getDayFormat());
        this.blogDateFormat = this.createServerFormat("dd MMM '@' h:mm a");
        this.serverDateFormat = this.createServerFormat(formatSettingsManager.getDateFormat());
        this.serverDateTimeFormat = this.createServerFormat(formatSettingsManager.getDateTimeFormat());
    }

    public String format(Date date) {
        return this.formatWith(this.dateFormat, date);
    }

    public String formatDateTime(Date date) {
        return this.formatWith(this.dateTimeFormat, date);
    }

    public String formatTime(Date date) {
        return this.formatWith(this.timeFormat, date);
    }

    public String formatDay(Date date) {
        return this.formatWith(this.dayFormat, date);
    }

    public String formatDateFull(Date date) {
        DateFormat format = DateFormat.getDateInstance(0);
        format.setLenient(false);
        format.setTimeZone(this.timeZone.getWrappedTimeZone());
        return this.formatWith(format, date);
    }

    public String formatServerDate(Date date) {
        return this.formatWith(this.serverDateFormat, date);
    }

    public String formatServerDateTime(Date date) {
        return this.formatWith(this.serverDateTimeFormat, date);
    }

    public String formatBlogDate(Date date) {
        return this.formatWith(this.blogDateFormat, date);
    }

    public String formatServerDateFull(Date date) {
        DateFormat format = DateFormat.getDateInstance(0);
        format.setLenient(false);
        format.setTimeZone(TimeZone.getDefault().getWrappedTimeZone());
        return this.formatWith(format, date);
    }

    public String getCurrentDateTime() {
        return this.formatDateTime(new Date());
    }

    public String getCurrentDate() {
        return this.format(new Date());
    }

    private String formatWith(DateFormat format, Date date) {
        try {
            return format.format(date);
        }
        catch (Exception e) {
            return "";
        }
    }

    private DateFormat createFormat(String pattern) {
        SimpleDateFormat format = new SimpleDateFormat(pattern);
        format.setLenient(false);
        format.setTimeZone(this.timeZone.getWrappedTimeZone());
        return format;
    }

    private DateFormat createServerFormat(String pattern) {
        SimpleDateFormat format = new SimpleDateFormat(pattern);
        format.setLenient(false);
        format.setTimeZone(TimeZone.getDefault().getWrappedTimeZone());
        return format;
    }

    public Calendar getCalendar() {
        return Calendar.getInstance(this.timeZone.getWrappedTimeZone());
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public static String formatMillis(long millis) {
        SimpleDateFormat format = new SimpleDateFormat("HH:mm:ss.S");
        format.setTimeZone(java.util.TimeZone.getTimeZone("UTC"));
        String result = format.format(new Date(millis));
        result = result.replaceFirst("^00:", "");
        return result;
    }
}

