/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.core;

import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.user.User;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.apache.lucene.search.BooleanClause;

public class ListQuery
implements Cloneable {
    public static final int UNLIMITED_TIMESPAN = -1;
    public static final String SORT_BY_TIME_CREATED = "created";
    public static final String SORT_BY_TIME_MODIFIED = "modified";
    public static final String ALL_VERSIONS = "all";
    public static final List ALL_TYPES = Arrays.asList("page", "blogpost", "comment", "mail", "userinfo", "spacedesc", "personalspacedesc", "attachment");
    public static final String LATEST_VERSIONS = "latest";
    private String name;
    private String sortBy = "modified";
    private User user;
    private List spaceList;
    private List typeList;
    private List statusList;
    private List labelList;
    private List spaceScopes;
    private int maxResults;
    private float timeSpan = -1.0f;
    private BooleanClause.Occur labelOccur = BooleanClause.Occur.SHOULD;

    public String toString() {
        return "ListQuery{name='" + this.name + '\'' + ", sortBy='" + this.sortBy + '\'' + ", user=" + this.user + ", spaceList=" + this.spaceList + ", typeList=" + this.typeList + ", statusList=" + this.statusList + ", labelList=" + this.labelList + ", spaceScopes=" + this.spaceScopes + ", maxResults=" + this.maxResults + ", timeSpan=" + this.timeSpan + ", labelOccur=" + this.labelOccur + '}';
    }

    public ListQuery() {
    }

    public ListQuery(ListQuery query) {
        this.name = query.getName();
        this.user = query.getUser();
        this.getSpaceList().addAll(query.getSpaceList());
        this.getSpaceScopes().addAll(query.getSpaceScopes());
        this.getTypeList().addAll(query.getTypeList());
        this.getStatusList().addAll(query.getStatusList());
        this.getLabelList().addAll(query.getLabelList());
        this.maxResults = query.getMaxResults();
        this.timeSpan = query.getTimeSpan();
        this.sortBy = query.getSortBy();
        this.labelOccur = query.getLabelOccur();
    }

    public User getUser() {
        return this.user;
    }

    public List getSpaceList() {
        if (this.spaceList == null) {
            this.spaceList = new LinkedList();
        }
        return this.spaceList;
    }

    public List getTypeList() {
        if (this.typeList == null) {
            this.typeList = new LinkedList();
        }
        return this.typeList;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public void setSpaceList(List spaceList) {
        this.spaceList = spaceList;
    }

    public ListQuery addType(String type) {
        if (!this.getTypeList().contains(type)) {
            this.getTypeList().add(type);
        }
        return this;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getMaxResults() {
        return this.maxResults;
    }

    public void setMaxResults(int maxResults) {
        this.maxResults = maxResults;
    }

    public float getTimeSpan() {
        return this.timeSpan;
    }

    public void setTimeSpan(float timeSpan) {
        this.timeSpan = timeSpan;
    }

    public void setTypeList(List typeList) {
        this.typeList = typeList;
    }

    public List getStatusList() {
        if (this.statusList == null) {
            this.statusList = new LinkedList();
        }
        return this.statusList;
    }

    public void setStatusList(List statusList) {
        this.statusList = statusList;
    }

    public ListQuery addStatus(String str) {
        if (!this.getStatusList().contains(str)) {
            this.getStatusList().add(str);
        }
        return this;
    }

    public String getDescription() {
        StringBuffer sb = new StringBuffer();
        return sb.append(this.getMaxResultsDescription(this.maxResults)).append(this.getStatusDescription(this.getStatusList())).append(this.getTypeDescription(this.getTypeList())).append(this.getTimeSpanDescription(this.timeSpan)).append(this.getSpaceDescription(this.getSpaceList())).append(this.getLabelDescription(this.getLabelList())).toString();
    }

    private String getLabelDescription(List labelList) {
        if (labelList.size() == 0) {
            return ".";
        }
        StringBuffer sb = new StringBuffer(labelList.size() == 1 ? " with label" : " with labels");
        String sep = " ";
        for (Label label : labelList) {
            String labelName = label.getName();
            sb.append(sep).append(labelName);
            sep = ", ";
        }
        sb.append(".");
        return sb.toString();
    }

    private String getSpaceDescription(List spaceList) {
        if (spaceList.size() == 0) {
            return " in all Spaces";
        }
        StringBuffer sb = new StringBuffer(spaceList.size() == 1 ? " in space" : " in spaces");
        String sep = " ";
        for (Space space : spaceList) {
            sb.append(sep).append(space.getName());
            sep = ", ";
        }
        return sb.toString();
    }

    private String getTimeSpanDescription(float timeSpan) {
        if (timeSpan > 0.0f) {
            return " less than " + timeSpan + " days old";
        }
        return "";
    }

    private String getTypeDescription(List typeList) {
        String s = "";
        String sep = "";
        for (String type : typeList) {
            s = s + sep + type + "s";
            sep = ", ";
        }
        return s;
    }

    private String getStatusDescription(List statusList) {
        String s = "";
        String sep = "";
        if (statusList.contains(SORT_BY_TIME_CREATED)) {
            s = "creations of ";
            sep = "or ";
        }
        if (statusList.contains(SORT_BY_TIME_MODIFIED)) {
            s = s + sep + "modifications to ";
        }
        return s;
    }

    private String getMaxResultsDescription(int maxResults) {
        if (maxResults > 0) {
            return "The " + maxResults + " most recent ";
        }
        return "";
    }

    public List getLabelList() {
        if (this.labelList == null) {
            this.labelList = new LinkedList();
        }
        return this.labelList;
    }

    public void setLabelList(List labelList) {
        this.labelList = labelList;
    }

    public ListQuery addLabel(String name) {
        if (!this.getLabelList().contains(name)) {
            this.getLabelList().add(name);
        }
        return this;
    }

    public ListQuery addSpace(Space space) {
        if (space != null && !this.getSpaceList().contains(space)) {
            this.getSpaceList().add(space);
        }
        return this;
    }

    public List getSpaceScopes() {
        if (this.spaceScopes == null) {
            this.spaceScopes = new LinkedList();
        }
        return this.spaceScopes;
    }

    public void setSpaceScopes(List spaceScopes) {
        this.spaceScopes = spaceScopes;
    }

    public String getSortBy() {
        return this.sortBy;
    }

    public void setSortBy(String sortBy) {
        this.sortBy = sortBy;
    }

    public BooleanClause.Occur getLabelOccur() {
        return this.labelOccur;
    }

    public void setLabelOccur(BooleanClause.Occur labelOccur) {
        this.labelOccur = labelOccur;
    }
}

