/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.core;

import com.opensymphony.xwork.ActionInvocation;
import com.opensymphony.xwork.interceptor.LoggingInterceptor;
import org.apache.log4j.Logger;

public class ResultLoggingInterceptor
extends LoggingInterceptor {
    private static final Logger logger = Logger.getLogger(LoggingInterceptor.class);

    protected void after(ActionInvocation actionInvocation, String result) throws Exception {
        super.after(actionInvocation, result);
        this.logMessage(actionInvocation, "Result was \"" + result + "\" for action ");
    }

    private void logMessage(ActionInvocation invocation, String baseMessage) {
        if (logger.isInfoEnabled()) {
            StringBuffer message = new StringBuffer(baseMessage);
            String namespace = invocation.getProxy().getNamespace();
            if (namespace != null && namespace.trim().length() > 0) {
                message.append(namespace).append("/");
            }
            message.append(invocation.getProxy().getActionName());
            logger.info((Object)message.toString());
        }
    }
}

